function decode_time(d_time)
	local m = math.floor(d_time/(60*1000))
	local s = (d_time - m*60*1000)/1000
	if (s < 10) then
		s = string.format('0%s', s)
	end
	return { d_time = string.format('%s:%s0', m, s) }
end

-------------------------------------------------------
function l_init(imsg)
	user = {}
	s = {}
	luaLFS:tiny(1, TINY_NCN)
	luaLFS:tiny(1, TINY_NPL)
	luaLFS:tiny(1, TINY_RST)
end
evt_bind(EVT_CONNECTED, l_init)


function username(imsg)
	local t = luaLFS:ncn(imsg)
	user[t.pname] = t.uname
--	print("name="..t.pname)
--	print("user="..t.uname)
end
evt_bind(ISP_NCN, username)


function trackname(imsg)
	local t = luaLFS:rst(imsg)
	track = t.track
--	print("\nTrack="..track)
end
evt_bind(ISP_RST, trackname)


function put_massive(imsg)
	local t = luaLFS:npl(imsg)
	if (user[t.pname] ~= nil) then
		s[t.plid] = { user = user[t.pname], plate = t.plate, car = t.cname, sp1 = 0, sp2 = 0, sp3 = 0 }
--		print("\nUser: "..s[t.plid].user)
--		print("Car: "..s[t.plid].car)
--		print("Plate: "..s[t.plid].plate)
	end
end
evt_bind(ISP_NPL, put_massive)


function l_split(imsg)
	local t = luaLFS:spx(imsg)
	if (s[t.plid] ~= nil) then
		t.stime = decode_time(t.stime).d_time
		if (t.split == 1) then
			s[t.plid].sp1 = t.stime
--			print ("SP1="..s[t.plid].sp1)
			s[t.plid].sp2 = 0
			s[t.plid].sp3 = 0
		end
		if (t.split == 2) then
			s[t.plid].sp2 = t.stime
--			print ("SP1="..s[t.plid].sp1)
--			print ("SP2="..s[t.plid].sp2)
		end
		if (t.split == 3) then
			s[t.plid].sp3 = t.stime
--			print ("SP1="..s[t.plid].sp1)
--			print ("SP2="..s[t.plid].sp2)
--			print ("SP3="..s[t.plid].sp3)
		end
	end
end
evt_bind(ISP_SPX, l_split)


function l_lap(imsg)
	local t = luaLFS:lap(imsg)
	if (s[t.plid] ~= nil) then
		local laps_log = os.date('%Y%m%d %H:%M:%S')
		laps_log = string.format( '%s,%s,%s,%s,%s,%s,%s', laps_log, s[t.plid].user, track, s[t.plid].plate, s[t.plid].car, decode_time(t.ltime).d_time, s[t.plid].sp1 )
		if (s[t.plid].sp2 ~= 0) then
			laps_log = string.format( '%s,%s',laps_log, s[t.plid].sp2 )
		end
		if (s[t.plid].sp3 ~= 0) then
			laps_log = string.format( '%s,%s',laps_log, s[t.plid].sp3 )
		end
		local file_w = io.open("laps.log","a")
--		print(laps_log.."\n")
		file_w:write(laps_log.."\n")
		file_w:close()
	end
end
evt_bind(ISP_LAP, l_lap)

--- REMOVE UNUSED TABLE ---
function l_plp(imsg)
	local t = luaLFS:plp(imsg)
--	luaLFS:mst("player pits")
	table.remove(s, t.plid)
	print("Remove data of "..s[t.plid].user)
end
evt_bind(ISP_PLP, l_plp)


function l_pll(imsg)
	local t = luaLFS:pll(imsg)
--	luaLFS:mst("player spectate")
	table.remove(s, t.plid)
	print("Remove data of "..s[t.plid].user)
end
evt_bind(ISP_PLL, l_pll)


--- DON'T KNOW HOW DO IT ---
--function l_cnl(imsg)
--	local t = luaLFS:cnl(imsg)
--	luaLFS:mst("player disconnected")
--	table.remove(user, ???)
--	print("Remove data of "..???)
--end
--evt_bind(ISP_CNL, l_cnl)

--function l_cpr(imsg)
--	local t = luaLFS:cpr(imsg)
--	luaLFS:mst("player renamed")
--	table.remove(user, ???)
--	print("Remove data of "..???)
--end
--evt_bind(ISP_CPR, l_cpr)
--------------------------