VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "RayOK's VB6 InSim Example"
   ClientHeight    =   3345
   ClientLeft      =   45
   ClientTop       =   375
   ClientWidth     =   7320
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   223
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   488
   StartUpPosition =   3  'Windows Default
   Begin VBInSimExample.okSocket InSimSocket 
      Left            =   6360
      Top             =   3000
      _ExtentX        =   423
      _ExtentY        =   450
      Protocol        =   17
   End
   Begin VBInSimExample.ucStatusbar StatusBar 
      Height          =   375
      Left            =   0
      Top             =   3000
      Width           =   3735
      _ExtentX        =   6588
      _ExtentY        =   661
   End
   Begin VB.Timer KeepAlive 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   5760
      Top             =   2880
   End
   Begin VB.TextBox txtPassword 
      Height          =   285
      Left            =   6000
      MaxLength       =   15
      TabIndex        =   7
      Top             =   120
      Width           =   1215
   End
   Begin VB.TextBox txtRecvPort 
      Height          =   285
      Left            =   4320
      MaxLength       =   5
      TabIndex        =   6
      Top             =   120
      Width           =   735
   End
   Begin VB.TextBox txtSendPort 
      Height          =   285
      Left            =   2640
      MaxLength       =   5
      TabIndex        =   5
      Top             =   120
      Width           =   735
   End
   Begin VB.CommandButton cmdConnect 
      Caption         =   "Connect"
      Enabled         =   0   'False
      Height          =   285
      Left            =   120
      TabIndex        =   4
      Top             =   120
      Width           =   1455
   End
   Begin VB.CommandButton cmdSend 
      Caption         =   "Send"
      Enabled         =   0   'False
      Height          =   285
      Left            =   6240
      TabIndex        =   2
      Top             =   2640
      Width           =   975
   End
   Begin VB.TextBox txtSend 
      Enabled         =   0   'False
      Height          =   285
      Left            =   600
      MaxLength       =   63
      TabIndex        =   1
      Top             =   2640
      Width           =   5535
   End
   Begin VB.TextBox txtChat 
      Height          =   2055
      Left            =   120
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   480
      Width           =   7095
   End
   Begin VB.Label lblSendPort 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Send Port:"
      Height          =   255
      Left            =   1770
      TabIndex        =   10
      Top             =   165
      Width           =   855
   End
   Begin VB.Label lblRecv 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Recv Port:"
      Height          =   255
      Left            =   3450
      TabIndex        =   9
      Top             =   165
      Width           =   855
   End
   Begin VB.Label lblPassword 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Password:"
      Height          =   255
      Left            =   5130
      TabIndex        =   8
      Top             =   165
      Width           =   855
   End
   Begin VB.Label lblChat 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Chat!:"
      Height          =   255
      Left            =   90
      TabIndex        =   3
      Top             =   2685
      Width           =   495
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'Welcome! As I said, I went all out and made a "simple" InSim program :P
'I guess I just love open source, learning-by-example, and especiall LFS! Have
'fun with this and if any questions and the comments don't help, send me a
'message on the forums and I can try to answer. You can do whatever you want
'with this code. Fine by me.

'I setup the Winsock user-control to be as simple as I could think of. The major
'thing you have to do is remember and check for socket handles. ConnectTo() or
'ListenTo() are the first methods you call and they return the socket handles. For
'all other events you should check the socket handle to know what to do. A basic
'explanation of how TCP and UDP sockets work can be found at www.WinsockVB.com

'                                                            - RayOK (stuff)

Private lngInSimClient As Long      'send to LFS on this socket with the send port. used with /insim
Private lngInSimServer As Long      'listen for LFS on this socket with the receive port. in the ISI packet

Public lngTimer As Long            'number of seconds for the KeepAlive timer stored here

Private Sub Form_Load()
    Dim ctl As Control
    
    'flatter controls
    For Each ctl In Me.Controls
        If TypeName(ctl) = "TextBox" Or TypeName(ctl) = "CommandButton" Then MakeFlat ctl.hWnd
    Next
    
    'setup the status bar, a Charles P.V. user-control. found here:
    'http://www.pscode.com/vb/scripts/ShowCode.asp?txtCodeId=56837&lngWId=1
    StatusBar.Initialize False, True
    StatusBar.AddPanel sbNormal, , , sbSpring, "Welcome! Fill in the ports and your password then connect to chat.."
End Sub

Private Sub cmdConnect_Click()
    'depending on the caption either connect, cancel or disconnect
    If cmdConnect.Caption = "Connect" Then
        cmdConnect.Caption = "Cancel"
        StatusBar.PanelText(1) = "Connecting to localhost:" + txtSendPort.Text
        
        txtSendPort.Enabled = False
        txtRecvPort.Enabled = False
        txtPassword.Enabled = False
        
        lngInSimClient = InSimSocket.ConnectTo("127.0.0.1", CLng(txtSendPort.Text))
        If lngInSimClient Then
            lngInSimServer = InSimSocket.ListenTo(CLng(txtRecvPort.Text))
            If lngInSimServer Then    'connected to sockets, send INI packet
                lngTimer = 0
                KeepAlive.Enabled = True
            Else
                StatusBar.PanelText(1) = "Could not create server socket!"
                Call InSimSocket.CloseIt(lngInSimClient)
            End If
        Else
            StatusBar.PanelText(1) = "Could not create client socket!"
        End If
    ElseIf cmdConnect.Caption = "Cancel" Then
        StatusBar.PanelText(1) = "Cancelled.."
        Call CloseDown
        KeepAlive.Enabled = False
    Else
        'do this for disconnect
        StatusBar.PanelText(1) = "Disconnected.."
        Call CloseDown
        KeepAlive.Enabled = False
    End If
End Sub

Private Sub InSimSocket_ReceivedBytes(lngSocket As Long, bytData As Variant, lngLength As Long)
    'we have data from InSim! just pass the received bytes over to ParseMessage() in InSim.bas
    'makes it a little easier to keep organized
    If lngSocket = lngInSimServer Then Call ParseMessage(bytData, lngLength)
End Sub

'check the send and receive ports for numbers only, if they are there and
'they are not the same. if so, enable the connect button
Private Sub txtSendPort_KeyPress(KeyAscii As Integer)
    Call OnlyNumber(KeyAscii)
End Sub
Private Sub txtSendPort_Change()
    If txtSendPort.Text = "" Then cmdConnect.Enabled = False
    If txtSendPort.Text <> "" And txtRecvPort.Text <> "" Then cmdConnect.Enabled = True
    If txtSendPort.Text = txtRecvPort.Text Then cmdConnect.Enabled = False
End Sub

Private Sub txtRecvPort_KeyPress(KeyAscii As Integer)
    Call OnlyNumber(KeyAscii)
End Sub
Private Sub txtRecvPort_Change()
    If txtRecvPort.Text = "" Then cmdConnect.Enabled = False
    If txtSendPort.Text <> "" And txtRecvPort.Text <> "" Then cmdConnect.Enabled = True
    If txtSendPort.Text = txtRecvPort.Text Then cmdConnect.Enabled = False
End Sub

Private Sub txtSend_KeyPress(KeyAscii As Integer)
    'if enter, send the text
    If KeyAscii = 13 Then
        If txtSend.Text <> "" Then Call SendMST(lngInSimClient, txtSend.Text)
        txtSend.Text = ""
    End If
End Sub
Private Sub cmdSend_Click()
    If txtSend.Text <> "" Then Call SendMST(lngInSimClient, txtSend.Text)
    txtSend.Text = ""
End Sub

Private Sub KeepAlive_Timer()
    If cmdConnect.Caption = "Cancel" Then       'send a VER packet every 10 seconds, 3 times
        If lngTimer = 30 Then
            Call cmdConnect_Click
            StatusBar.PanelText(1) = "No response in 3 tries. InSim running? (use: /insim " & txtSendPort.Text & " in LFS)"
            Exit Sub
        ElseIf lngTimer Mod 10 = 0 Then
            StatusBar.PanelText(1) = "Connecting to localhost:" & txtSendPort.Text & " (" & lngTimer \ 10 + 1 & "/3)"
            Call SendISI(lngInSimClient, CLng(txtRecvPort.Text), txtPassword.Text)
            Call SendISP(lngInSimClient, "VER")
        End If
    Else
        'send ack every 30 seconds for a keep alive
        If lngTimer Mod 30 = 0 Then Call SendISP(lngInSimClient, "ACK")
        
        'if no ACK's in 2 minutes, timeout disconnect
        If lngTimer > 120 Then
            Call cmdConnect_Click
            StatusBar.PanelText(1) = "No response in 2 minutes.. InSim running?"
        End If
    End If
    
    'store the timer count
    lngTimer = lngTimer + 1
End Sub

Public Sub CloseDown()
    'disconnect from LFS
    Call SendISP(lngInSimClient, "ISC")

    'close the InSim sockets we used
    Call InSimSocket.CloseIt(lngInSimServer)
    Call InSimSocket.CloseIt(lngInSimClient)
    
    'change form back to normal
    cmdConnect.Caption = "Connect"
    txtSendPort.Enabled = True
    txtRecvPort.Enabled = True
    txtPassword.Enabled = True
    cmdSend.Enabled = False
    txtSend.Enabled = False
End Sub

Private Sub OnlyNumber(intAsc As Integer)
    If intAsc = 8 Or intAsc >= 48 And intAsc <= 57 Then
        'its backspace or a number, don't change it
    Else
        intAsc = 0
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Call CloseDown
End Sub
