Attribute VB_Name = "InSim"
Option Explicit

'my InSim type/struct implementation.. use it if you want :)

'use copy memory to transfer the received bytes into the InSim type (struct)
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (pDst As Any, pSrc As Any, ByVal ByteLen As Long)

Private Type MSHT
    bytMin As Byte  'minutes
    bytSec As Byte  'seconds
    bytHnd As Byte  'hundredths
    bytThs As Byte  'thousandths
End Type

Private Const ISF_RACE_TRACKING As Byte = 1      'bit 0 turns on race tracking
Private Const ISF_GUARANTEE As Byte = 2          'bit 1 turns on guaranteed delivery
Private Const ISF_SPLIT_MESSAGE As Byte = 4      'bit 2 makes LFS use MSS for user messages instead of MSO
Private Const ISF_NO_WARNINGS As Byte = 8        'bit 3 turns off packet warnings
Private Const ISF_KEEP_ALIVE As Byte = 16        'bit 4 makes LFS send keep alive packets
Private Const ISF_NLP_MCI As Byte = 32           'bit 5 makes lfs send MCI instead of NLP

Private Type InSimInit
    bytID(0 To 3) As Byte
    bytPort(0 To 1) As Byte
    bytFlags As Byte
    bytNodeSecs As Byte
    bytAdmin(0 To 15) As Byte
End Type

Private Type InSimPack           'blank packet..
    bytID(0 To 3) As Byte       'VER, ACK, ISC, etc..
    bytValue(0 To 3) As Byte
End Type

Private Type InSimVersion        'only received, dont send!
    bytID(0 To 3) As Byte       'VER
    bytVersion(0 To 7) As Byte  'LFS version, e.g. 0.3G
    bytProduct(0 To 5) As Byte  'Product : DEMO or S1
    bytInSimVer(0 To 1) As Byte 'InSim Version : increased when InSim packets change
End Type

Private Type StAtePack
    bytID(0 To 3) As Byte       'STA
    bytReplaySpeed(0 To 3) As Byte '4-byte float - 1.0 is normal speed
    bytFlags(0 To 1) As Byte    'State Flags (see below)
    bytInGameCam As Byte        'Which type of camera is selected (see below)
    bytViewPlayer As Byte       'Player index of viewed car
    bytNumPlayers As Byte       'Num in race
    bytNumConns As Byte         'Num connections including host
    bytNumFinished As Byte      'Number finished or qualified
    bytRaceInProgress As Byte   '0 - no / 1 - race / 2 - qualifying
    bytQualMins As Byte
    bytRaceLaps As Byte         '0=practice,1-99=laps,100-190=(n-100)*10+100,191-238=n-190 hours
    bytSpare2 As Byte
    bytSpare3 As Byte
    bytTrack(0 To 5) As Byte    'short name for track e.g. FE2R
    bytWeather As Byte          '0,1,2...
    bytWind As Byte             '0=off 1=weak 2=strong
End Type

'The bits stored in "State Flags" are :
'--------------------------------------
'first byte (0)
Private Const ISS_GAME As Byte = 1              'in game (or MPR)
Private Const ISS_REPLAY As Byte = 2            'in SPR
Private Const ISS_PAUSED As Byte = 4            'paused
Private Const ISS_SHIFTU As Byte = 8            'in SHIFT+U mode
Private Const ISS_SHIFTU_HIGH As Byte = 16      'HIGH view
Private Const ISS_SHIFTU_FOLLOW As Byte = 32    'following car
Private Const ISS_SHIFTU_NO_OPT As Byte = 64    'buttons are hidden
Private Const ISS_SHOW_2D As Byte = 128         'showing 2d display
'second byte (1)
Private Const ISS_FRONT_END As Byte = 1         '256   in front end screen
Private Const ISS_MULTI As Byte = 2             '512   multiplayer mode
Private Const ISS_MPSPEEDUP As Byte = 4         '1024  multiplayer speedup option
Private Const ISS_WINDOWED As Byte = 8          '2048  lfs is running in a window
Private Const ISS_SOUND_MUTE As Byte = 16       '4096  sound is switched off
Private Const ISS_VIEW_OVERRIDE As Byte = 32    '8192  override user view

Private Type MsgTypePack         'send to LFS to simulate typing message or command
    bytID(0 To 3) As Byte       'MST
    bytMsg(0 To 63) As Byte
End Type

Private Type MsgOutPack          '128 chars - LFS reporting displayed messages
    bytID(0 To 3) As Byte       'MSO
    bytMsg(0 To 127) As Byte
End Type

Private Type MsgOutSplit         '64 chars - user messages if ISF_SPLIT_MESSAGE flag is ON
    bytID(0 To 3) As Byte       'MSS
    bytUName(0 To 23) As Byte
    bytPName(0 To 23) As Byte
    bytMsg(0 To 63) As Byte
End Type

Private Type MsgToConn           'send to LFS and on to a chosen connection (0 = host)
    bytID(0 To 3) As Byte       'MTC
    bytConn As Byte             'connection
    bytUniqueId As Byte         'destination player UniqueId : if set, Conn is ignored
    bytSp2 As Byte
    bytSp3 As Byte
    bytMsg(0 To 63) As Byte
End Type

'Multiplayer Notification
'------------------------
'LFS will send this packet when a host is started or joined :
Private Type InSimMulti
    bytID(0 To 3) As Byte       'ISM
    bytHost As Byte             '0 = guest / 1 = host
    bytSp1 As Byte
    bytSp2 As Byte
    bytSp3 As Byte
    bytName(0 To 31) As Byte    'the name of the host joined or started
End Type

'On ending or leaving a host, LFS will send this InSimPack :
'Id  : "MPE"  (MultiPlayerEnd)
'Value   : 0

'To request a InSimMulti packet at any time, send a InSimPack with Id = "ISM".
'- If LFS is not in multiplayer mode, the host name in the ISM will be empty.

'RACE TRACKING PACKETS - you must send an acknowledgement reply to these packets
'---------------------
Private Type IS_RST              'Race STart
    bytID(0 To 3) As Byte       'RST
    bytRaceLaps As Byte         '0=practice,1-99=laps,100-190=(n-100)*10+100,191-238=n-190 hours
    bytQualMins As Byte         '0 if race
    bytNumInRace As Byte
    bytSpare As Byte
    bytTrack(0 To 5) As Byte
    bytWeather As Byte
    bytWind As Byte
    bytSp0 As Byte
    bytSp1 As Byte
    bytVerifyId(0 To 1) As Byte
End Type

Private Type IS_REN              'Race ENd
    bytID(0 To 3) As Byte       'REN
    bytSp0 As Byte
    bytSp1 As Byte
    bytVerifyId(0 To 1) As Byte
End Type

Private Type IS_NCN              'New ConN
    bytID(0 To 3) As Byte       'NCN
    bytUName(0 To 23) As Byte
    bytPName(0 To 23) As Byte
    bytAdmin As Byte
    bytSp1 As Byte
    bytSp2 As Byte
    bytSp3 As Byte
    bytConnNum As Byte          'new conn's number (0 = host, 1, 2...)
    bytTotal As Byte            'number of connections on host, including host
    bytVerifyId(0 To 1) As Byte
End Type

Private Type IS_CNL              'ConN Leave (end connection is moved down into this slot)
    bytID(0 To 3) As Byte       'CNL
    bytUName(0 To 23) As Byte
    bytPName(0 To 23) As Byte
    bytConnNum As Byte
    bytTotal As Byte
    bytVerifyId(0 To 1) As Byte
End Type

Private Type IS_NPL              'New PLayer joining race (if number already exists, then leaving pits)
    bytID(0 To 3) As Byte       'NPL
    bytUName(0 To 23) As Byte
    bytPName(0 To 23) As Byte
    bytPlate(0 To 7) As Byte    'number plate - NO ZERO AT END!
    bytCName(0 To 31) As Byte   'car name
    bytFlags(0 To 1) As Byte    'player flags (see below)
    bytType As Byte             'bit 0 - female / bit 1 - AI
    bytUniqueId As Byte         'player's assigned unique id
    bytPlyNum As Byte           'player's number (0 = pole, 1, 2...)
    bytTotal As Byte            'number in race (same when leaving pits, 1 more if new)
    bytVerifyId(0 To 1) As Byte
End Type

Private Type IS_PLP              'PLayer Pits (go to settings - stays in player list)
    bytID(0 To 3) As Byte       'PLP
    bytUName(0 To 23) As Byte
    bytPName(0 To 23) As Byte
    bytUniqueId As Byte
    bytSp1 As Byte
    bytSp2 As Byte
    bytSp3 As Byte
    bytPlyNum As Byte           'player's number (stays in list)
    bytTotal As Byte            'new total (expect same as before)
    bytVerifyId(0 To 1) As Byte
End Type

Private Type IS_PLL              'PLayer Leave race (spectate - leaves player list, all are shunted down)
    bytID(0 To 3) As Byte       'PLL
    bytUName(0 To 23) As Byte
    bytPName(0 To 23) As Byte
    bytUniqueId As Byte
    bytSp1 As Byte
    bytSp2 As Byte
    bytSp3 As Byte
    bytPlyNum As Byte           'player's number (others shunt down)
    bytTotal As Byte            'new total (expect : 1 less than before)
    bytVerifyId(0 To 1) As Byte
End Type

Private Type IS_CPR              'Conn Player Rename
    bytID(0 To 3) As Byte       'CPR
    bytUName(0 To 23) As Byte
    bytOldName(0 To 23) As Byte 'old name
    bytNewName(0 To 23) As Byte 'new name
    bytPlate(0 To 7) As Byte    'number plate - NO ZERO AT END!
    bytUniqueId As Byte         '0 = connection has no player in race
    bytSp1 As Byte
    bytVerifyId(0 To 1) As Byte
End Type

Private Type IS_CLR              'CLear Race - all players removed from race in one go
    bytID(0 To 3) As Byte       'CLR [4];
    bytSp0 As Byte
    bytSp1 As Byte
    bytVerifyId(0 To 1) As Byte
End Type

Private Type IS_LAP              'LAP time
    bytID(0 To 3) As Byte       'LAP
    bytUName(0 To 23) As Byte
    bytPName(0 To 23) As Byte
    bytCName(0 To 31) As Byte   'car name
    mshtTime As MSHT            'lap time
    bytPlyNum As Byte           'player's number
    bytUniqueId As Byte
    bytVerifyId(0 To 1) As Byte
End Type

Private Type IS_SPX              'SPlit X time
    bytID(0 To 3) As Byte       'SPX + zero, SP1 / SP2 / SP3
    mshtTime As MSHT            'split time
    bytPlyNum As Byte           'player's number
    bytUniqueId As Byte
    bytVerifyId(0 To 1) As Byte
End Type

Private Type IS_RES             'RESult (qualify or finish)
    bytID(0 To 3) As Byte       'RES [4];
    bytUName(0 To 23) As Byte
    bytPName(0 To 23) As Byte
    bytPlate(0 To 7) As Byte    'number plate - NO ZERO AT END!
    bytCName(0 To 3) As Byte    'short car name / skin prefix (e.g. XRT)
    bytSpare(0 To 23) As Byte   'zero
    bytLapsDone(0 To 1) As Byte 'laps completed
    byttFlags(0 To 1) As Byte   'player flags : help settings etc - see below
    bytConfirmFlags As Byte     'confirmation flags : disqualified etc - see below
    bytNumStops As Byte         'number of pit stops
    bytType As Byte             'bit 0 - female / bit 1 - AI
    bytUniqueId As Byte         '0 = player already left before result was sent
    mshtTotalTime As MSHT       'race time
    mshtBestLap As MSHT         'best lap
    bytResultNum As Byte        'position in results table (qualify may be inserted not at end)
    bytNumResults As Byte       'total number of results (qualify doesn't always add a new one)
    bytVerifyId(0 To 1) As Byte
End Type

Private Type PosId               'NOT A PACKET - small 2-byte structure - part of the REO (below)
    bytOldPos As Byte           'old position in list
    bytUniqueId As Byte
End Type

Private Type IS_REO              'REOrder (when race restarts after qualifying)
    bytID(0 To 3) As Byte       'REO
    udtPosId As PosId           'PosId   Info    [28];   // old positions and unique id
    bytSp0 As Byte
    bytNumPlayers As Byte       'number of players in race
    bytVerifyId(0 To 1) As Byte
End Type

'Player flags definition
'-----------------------
'SWAPSIDE 1
'GEARCHANGECUT 2
'GEARCHANGEBLIP 4
'AUTOGEARS 8
'RESERVED_1 16
'OLD MOUSE   32
'HELP_BRAKE 64
'HELP_THROTTLE 128
'RESERVED_2 256
'AUTOCLUTCH 512
'MOUSE 1024
'KB_NO_HELP 2048
'KB_STABILISED 4096

'Confirmation flags definition
'-----------------------------
'MENTIONED 1
'CONFIRMED 2
'PENALTY_DT 4
'PENALTY_SG 8
'PENALTY_30 16
'PENALTY_45 32
'DID_NOT_PIT 64

'NON-VERIFIED TRACKING PACKETS - do not send an acknowledgement reply to these packets
'-----------------------------
'If NodeSecs was set in the InSimInit packet, LFS will send IS_NLP or IS_MCI packets at
'the specified interval, depending on the InSimInit initialisation flag ISF_NLP_MCI.

'When ISF_NLP_MCI flag is NOT set...
Private Type NodeLap             'NOT A PACKET - small 4-byte structure - part of the NLP (below)
    bytNode(0 To 1) As Byte     'current path node
    bytLap As Byte              'current lap
    bytUniqueId As Byte
End Type

Private Type IS_NLP              'Node and Lap Packet
    bytID(0 To 3) As Byte       'NLP
    bytNumNodes(0 To 1) As Byte 'total number of nodes in the path
    bytFinishLine(0 To 1) As Byte 'the node number of the finish line
    bytNumPlayers As Byte       'number of players in race
    bytSp1 As Byte
    bytSp2 As Byte
    bytSp3 As Byte
    udtNodeLap As NodeLap       '[28] node and lap of each player
End Type

'When ISF_NLP_MCI flag IS set...
Private Type CompCar             'NOT A PACKET - Car info in a 24-byte structure - part of the MCI (below)
    bytNode(0 To 1) As Byte     'current path node
    bytLap As Byte              'current lap
    bytUniqueId As Byte
    lngX As Long                'X map (65536 = 1 metre)
    lngY As Long                'Y map (65536 = 1 metre) will use the X, Y to see if in the pits
    lngZ As Long                'Z alt (65536 = 1 metre)
    bytSpeed(0 To 1) As Byte    'speed (32768 = 100 m/s)
    bytDirection(0 To 1) As Byte 'direction of car's motion : (see note 1 below)
    bytHeading(0 To 1) As Byte  'direction of forward axis : (see note 1 below)
    bytAngVel(0 To 1) As Byte   'signed, rate of change of heading : (see note 2)
End Type
'Note 1 : 0 = world y axis direction, 32768 = 180 degrees, anticlockwise from above
'Note 2 : 0 = no change in heading, 8192 = 180 degrees per second anticlockwise

Private Type IS_MCI              'MultiCarInfo - if more than 8 in race then more than one of these is sent
    bytID(0 To 3) As Byte       'MCI [4];
    bytNumNodes(0 To 1) As Byte 'total number of nodes in the path
    bytFinishLine(0 To 1) As Byte 'the node number of the finish line
    bytNumPlayers As Byte       'number of players in race
    bytFirstPly As Byte         'first player in this packet (0 in 1st packet, 8 in 2nd...)
    bytSp2 As Byte
    bytSp3 As Byte
    udtCompCar As CompCar       '[8] car info for each player, max 8 per packet
End Type

'You can change the rate of NLP or MCI after initialisation by sending this InSimPack :
'
'Id  : "NLI"         (Node Lap Interval)
'Value   : Interval      (0 means stop, otherwise interval in milliseconds, minimum 100)
'
'TRACKING PACKET REQUESTS
'------------------------
'- send to LFS to request player / connection / result packets
'- these requests work even if race tracking is not switched on
'To request a IS_RES, send a InSimPack with Id = "RES" and value = result number (0,1,2...)
'To request a IS_NPL, send a InSimPack with Id = "NPL" and value = player number (0,1,2...)
'To request a IS_NCN, send a InSimPack with Id = "NCN" and value = conn number (0,1,2...)
'To request a IS_NLP, send a InSimPack with Id = "NLP" and value = 0
'To request a IS_MCI, send a InSimPack with Id = "MCI" and value = 0

'send this first, the InitialiSatIon packet
Public Sub SendISI(ByVal lngSocket As Long, ByVal lngRPort As Long, ByVal strPassword As String)
  Dim udtInSimInit As InSimInit, i As Byte, bytData() As Byte

  For i = 0 To 3
    udtInSimInit.bytID(i) = CByte(Asc(Mid("ISI" & vbNullChar, i + 1, 1)))
  Next i
  udtInSimInit.bytPort(0) = lngRPort Mod 256
  udtInSimInit.bytPort(1) = lngRPort \ 256
  udtInSimInit.bytFlags = ISF_KEEP_ALIVE + ISF_SPLIT_MESSAGE
  udtInSimInit.bytNodeSecs = 0
  For i = 0 To 15
    If Mid(strPassword, i + 1, 1) = "" Then
      udtInSimInit.bytAdmin(i) = CByte(Asc(vbNullChar))
    Else
      udtInSimInit.bytAdmin(i) = CByte(Asc(Mid(strPassword, i + 1, 1)))
    End If
  Next i
  
  ReDim bytData(LenB(udtInSimInit)) As Byte
  CopyMemory bytData(0), udtInSimInit, LenB(udtInSimInit)

  Call frmMain.InSimSocket.SendBytes(lngSocket, bytData, UBound(bytData))
End Sub

'basic InSimPacket, ACK, VER, etc..
Public Sub SendISP(ByVal lngSocket As Long, ByVal strID As String, Optional ByVal bytVerify0 As Byte, Optional ByVal bytVerify1 As Byte)
  Dim udtInSimPack As InSimPack, i As Byte, bytData() As Byte

  For i = 0 To 3
    udtInSimPack.bytID(i) = CByte(Asc(Mid(strID & vbNullChar, i + 1, 1)))
  Next i
  udtInSimPack.bytValue(0) = bytVerify0
  udtInSimPack.bytValue(1) = bytVerify1
  udtInSimPack.bytValue(2) = 0
  udtInSimPack.bytValue(3) = 0

  ReDim bytData(LenB(udtInSimPack)) As Byte
  CopyMemory bytData(0), udtInSimPack, LenB(udtInSimPack)

  Call frmMain.InSimSocket.SendBytes(lngSocket, bytData, UBound(bytData))
End Sub

'chat as if you typed it
Public Sub SendMST(ByVal lngSocket As Long, ByVal strMsg As String)
  Dim udtMsgTypePack As MsgTypePack, i As Byte, bytData() As Byte

  For i = 0 To 3
    udtMsgTypePack.bytID(i) = CByte(Asc(Mid("MST" & vbNullChar, i + 1, 1)))
  Next i
  For i = 0 To 62
    If Mid(strMsg, i + 1, 1) = "" Then
      udtMsgTypePack.bytMsg(i) = 0
    Else
      udtMsgTypePack.bytMsg(i) = CByte(Asc(Mid(strMsg, i + 1, 1)))
    End If
  Next i
  udtMsgTypePack.bytMsg(63) = 0

  ReDim bytData(LenB(udtMsgTypePack)) As Byte
  CopyMemory bytData(0), udtMsgTypePack, LenB(udtMsgTypePack)

  Call frmMain.InSimSocket.SendBytes(lngSocket, bytData, UBound(bytData))
End Sub

'only goes to the specified person, host is default
Public Sub SendMTC(ByVal lngSocket As Long, ByVal strMsg As String, Optional ByVal bytUniqueId As Byte = 0, Optional ByVal bytConnNum As Byte = 0)
  Dim udtMsgToConn As MsgToConn, i As Byte, bytData() As Byte

  For i = 0 To 3
    udtMsgToConn.bytID(i) = CByte(Asc(Mid("MTC" & vbNullChar, i + 1, 1)))
  Next i
  udtMsgToConn.bytConn = bytConnNum
  udtMsgToConn.bytUniqueId = bytUniqueId
  udtMsgToConn.bytSp2 = 0
  udtMsgToConn.bytSp3 = 0
  For i = 0 To 62
    If Mid(strMsg, i + 1, 1) = "" Then
      udtMsgToConn.bytMsg(i) = 0
    Else
      udtMsgToConn.bytMsg(i) = CByte(Asc(Mid(strMsg, i + 1, 1)))
    End If
  Next i
  udtMsgToConn.bytMsg(63) = 0

  ReDim bytData(LenB(udtMsgToConn)) As Byte
  CopyMemory bytData(0), udtMsgToConn, LenB(udtMsgToConn)

  Call frmMain.InSimSocket.SendBytes(lngSocket, bytData, UBound(bytData))
End Sub

Public Sub ParseMessage(bytData As Variant, lngLength As Long)
    Dim i As Integer, bytRecvData() As Byte, strID As String
    ReDim bytRecvData(lngLength)
  
    'copy the returned array so we can manipulate it
    For i = 0 To lngLength
          bytRecvData(i) = bytData(i)
    Next
    
    'reset the timeout counter
    frmMain.lngTimer = 0
    
    'get the packet ID
    strID = Left(StrConv(bytRecvData, vbUnicode), 3)
      
    'depending on the packet, take action
    Select Case strID
        Case "VER"
            If frmMain.cmdConnect.Caption = "Cancel" Then   'VER acknowledgmed! we're connected
                Dim udtVER As InSimVersion
                CopyMemory udtVER, bytRecvData(0), LenB(udtVER)
                
                frmMain.StatusBar.PanelText(1) = "Connected to LFS " & _
                    byt2str(udtVER.bytProduct) & " " & byt2str(udtVER.bytVersion)
                frmMain.cmdConnect.Caption = "Disconnect"
                frmMain.txtSend.Enabled = True
                frmMain.cmdSend.Enabled = True
            Else
                frmMain.StatusBar.PanelText(1) = "VER packet received?"
            End If
        Case "ACK"
            'just a keep alive, don't need to do anything.. just clear the status bar I guess
            frmMain.StatusBar.PanelText(1) = ""
        Case "MSO"
            Dim udtMSO As MsgOutPack
            CopyMemory udtMSO, bytRecvData(0), LenB(udtMSO)
            Call AddMSOChat(udtMSO)
        Case "MSS"
            Dim udtMSS As MsgOutSplit
            CopyMemory udtMSS, bytRecvData(0), LenB(udtMSS)
            Call AddMSSChat(udtMSS)
        Case Else
            frmMain.StatusBar.PanelText(1) = strID & " packet received"
    End Select
End Sub

Private Sub AddMSOChat(udtMSO As MsgOutPack)
On Error GoTo AddMSOErr
    Dim strMsg As String, intPos As Integer
    
    strMsg = "[" & Format(Now(), "YYYYMMDD HH:mm:ss") & "] - " & byt2str(udtMSO.bytMsg)
    
    frmMain.txtChat.Text = frmMain.txtChat.Text & vbNewLine & strMsg
    frmMain.txtChat.SelStart = Len(frmMain.txtChat.Text)

    Exit Sub
AddMSOErr:
    frmMain.StatusBar.PanelText(1) = "ERROR! AddMSOChat() - " & err.Number & ": " & err.Description
End Sub

Private Sub AddMSSChat(udtMSS As MsgOutSplit)
On Error GoTo AddMSSErr
    Dim strMsg As String

    strMsg = "[" & Format(Now(), "YYYYMMDD HH:mm:ss") & "] <" & _
          StripColors(byt2str(udtMSS.bytPName)) & "> " & StripColors(byt2str(udtMSS.bytMsg))

    frmMain.txtChat.Text = frmMain.txtChat.Text & vbNewLine & strMsg
    frmMain.txtChat.SelStart = Len(frmMain.txtChat.Text)

    Exit Sub
AddMSSErr:
    frmMain.StatusBar.PanelText(1) = "ERROR! AddMSSChat() - " & err.Number & ": " & err.Description
End Sub

'this converts the returned byte array to a string and converts those weird InSim occurances
Private Function byt2str(bytData() As Byte) As String
On Error GoTo byt2strErr
    Dim strString As String, bytNull As Byte
    
    strString = StrConv(bytData, vbUnicode)
    
    strString = Replace(strString, "^a", "*")
    strString = Replace(strString, "^c", ":")
    strString = Replace(strString, "^d", "\")
    strString = Replace(strString, "^l", "<")
    strString = Replace(strString, "^q", "?")
    strString = Replace(strString, "^r", ">")
    strString = Replace(strString, "^s", "/")
    strString = Replace(strString, "^t", """")  'double quote
    strString = Replace(strString, "^v", "|")

    bytNull = InStr(1, strString, vbNullChar)
    If bytNull > 0 Then
        byt2str = Left(strString, bytNull - 1)
    Else
        byt2str = strString
    End If

    Exit Function
byt2strErr:
    frmMain.StatusBar.PanelText(1) = "-ERROR- byt2str() - " & err.Number & ": " & err.Description
End Function

'simple loop to remove the InSim color codes
Private Function StripColors(ByVal strString As String) As String
On Error GoTo StripColorsErr
    Dim i As Byte
    
    For i = 0 To 9
        strString = Replace(strString, "^" & CStr(i), "")
    Next i

    StripColors = strString

    Exit Function
StripColorsErr:
    frmMain.StatusBar.PanelText(1) = "-ERROR- StripColors() - " & err.Number & ": " & err.Description
End Function
