#ifndef __MPR_H__
#define __MPR_H__

#define MPR_MAX_PLAYERS 47

#define MPR_MAGIC_OFFSET 0xF50
#define MPR_RACER_INFO_IDENT 0x444
#define MPR_USERNAME_INFO_IDENT 0x73C

typedef unsigned char byte;
typedef unsigned short word;

typedef struct {
    char          LFSMPR[6];        // 0   : do not read file if no match
    byte          game_version;     // 6   : ignore
    byte          game_revision;    // 7   : ignore
    byte          MPR_version;      // 8   : ignore
    byte          immediate_start;  // 9   : joined already running game
    byte          reserved1;        // 10  : -
    byte          reserved2;        // 11  : -
    int           rules;            // 12  : -
    int           flags;            // 16  : -
    byte          laps_byte;        // 20  : laps / hours (see notes)
    byte          skill;            // 21  : skill level (0,1,2,3,4)
    byte          wind;             // 22  : 0=off 1=weak 2=strong
    byte          num_players;      // 23  : players at start of race
    char          LFS_version[8];      // 24  : text, ends 0
    char          short_track_name[4]; // 32  : e.g. BL2R
    int           start_time;       // 36  : seconds since 00:00 1/1/1970
    char          track_name[32];   // 40  : text, ends 0
    byte          config;           // 72  : 1,2,3.. (first config is 1)
    byte          reversed;         // 73  : 0=no 1=yes
    byte          weather;          // 74  : 0,1,2.. (first weather is 0)
    byte          num_finished;     // 75  : players in results table
    int           zero;             // 76  : -
} __attribute__ ((packed)) MPR_HEADER;

typedef struct {
    char          player_name[24];    //   0  : text, ends 0, no colours
    char          number_plate[8];    //   24 : text, NOTE : NO ZERO AT END
    char          short_car_name[4];  //   32 : text, ends 0
    byte          zero1[24];          //   36 : -
    word          laps_done;          //   60 : total laps completed
    word          player_flags;       //   62 : driver settings (see NOTES)
    byte          confirm_flags;      //   64 : penalties (see NOTES)
    byte          number_of_stops;    //   65 : pit stops count
    word          penalty_seconds;    //   66 : penalty time added
    int           overall_time;       //   68 : milliseconds
    int           best_lap_time;      //   72 : milliseconds
    int           zero2;              //   76 : -
} __attribute__ ((packed)) RESULT_INFO;

typedef struct {
	word racer_info_ident; //always 0x444
	byte conection_id; //?
	byte unknown1[2];
	char player_name[24];
	char number_plate[8];
	char unknown2[298];
} __attribute__ ((packed)) PLAYER_INFO;

typedef struct {
	word username_info_ident; //always 0x73C
	byte unknown[3];
	char player_name[24];
	char number_plate[8];
	char lfs_username[24];
} __attribute__ ((packed)) LFS_USERNAME_INFO;
	
extern RESULT_INFO MPR_RESULTS [MPR_MAX_PLAYERS];
extern int MPR_NO_PLAYERS_FINISHED;
extern int MPR_NO_PLAYERS_STARTED;

extern PLAYER_INFO MPR_PLAYERS [MPR_MAX_PLAYERS];
extern LFS_USERNAME_INFO MPR_USERNAMES [MPR_MAX_PLAYERS];

void mpr_read (char *filename);
void mpr_print_order();

#endif
