#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "log.h"
#include "mpr.h"

RESULT_INFO MPR_RESULTS [MPR_MAX_PLAYERS];
PLAYER_INFO MPR_PLAYERS [MPR_MAX_PLAYERS];
LFS_USERNAME_INFO MPR_USERNAMES [MPR_MAX_PLAYERS];

int MPR_NO_PLAYERS_STARTED;
int MPR_NO_PLAYERS_FINISHED;

void init_players () {
	memset (MPR_PLAYERS, 0, sizeof (MPR_PLAYERS));
	memset (MPR_RESULTS, 0, sizeof (MPR_RESULTS));
	MPR_NO_PLAYERS_FINISHED = -1;
	MPR_NO_PLAYERS_STARTED = -1;
}

void strip_colors_in_name (LFS_USERNAME_INFO *li) {
	char result[24];
	int i, pos = 0;
	memset (result, 0, 24);
	for (i = 0; i < 24; i++) {
		if (li->player_name[i] == '^') {
			if ((li->player_name[i+1] >= '0') &&
					(li->player_name[i+1] <= '9')) {
				i++;
				continue;
			}
		}
		result[pos] = li->player_name[i];
		pos++;
	}
	memcpy (li->player_name, result, 24);
}

char* mpr_search_for_username (char *name) {
	int i;
	for (i = 0; i < MPR_NO_PLAYERS_STARTED; i++) {
		if (strcmp (name, MPR_USERNAMES[i].player_name) == 0)
			return (MPR_USERNAMES[i].lfs_username);
	}
	return (NULL);
}

void mpr_print_order() {
	int i;
	char *username;

	for (i = 0; i < MPR_NO_PLAYERS_FINISHED; i++) {
		username = mpr_search_for_username (MPR_RESULTS[i].player_name);
		if (username == NULL) {
			error ("Name '%s' not found in usernames.\n",
					MPR_RESULTS[i].player_name);
			exit (1);
		}
		printf ("%d\t%s\n", i+1, username);
	}
}

void mpr_read (char *filename) {
	MPR_HEADER header;
	FILE *f;
	size_t size;
	int i;
	word racer_info_ident;

	init_players();

	f = fopen (filename, "r");
	if (f == NULL) {
		error ("Can't open %s\n", filename);
		exit (1);
	}
	size = fread (&header, 1, sizeof (MPR_HEADER), f);
	if (size != sizeof (MPR_HEADER)) {
		error ("IO, reading file header, expected %d, got %d\n",
				sizeof (MPR_HEADER), size);
		exit (1);
	}
	if (strcmp (header.LFSMPR, "LFSMPR") != 0) {
		error ("The file is not a LFS MPR file.\n");
		exit (1);

	}
//	printf ("Track: %s\n", header.track_name);
//	printf ("Players finished: %d\n", header.num_finished);

	MPR_NO_PLAYERS_FINISHED = header.num_finished;
	for (i = 0 ; i < MPR_NO_PLAYERS_FINISHED; i++) {
		size = fread (&(MPR_RESULTS[i]), 1, sizeof (RESULT_INFO), f);
		if (size != sizeof (RESULT_INFO)) {
			error ("IO, reading players, expected %d, got %d\n",
					sizeof (RESULT_INFO), size);
			exit (1);
		}
//		printf ("%s\n", MPR_RESULTS[i].player_name);
	}
	fseek (f, MPR_MAGIC_OFFSET - sizeof (MPR_HEADER) -
			(sizeof (RESULT_INFO) * header.num_finished), SEEK_CUR);

//	printf ("Current position: %lx\n", ftell (f));

	i = 0;
	while (1) {
		size = fread (&racer_info_ident, 1, sizeof (word), f);
		if (size != sizeof (word)) {
			error ("IO, reading players, expected %d, got %d\n",
					sizeof (word), size);
			exit (1);
		}
		if (racer_info_ident != MPR_RACER_INFO_IDENT) {
			if (racer_info_ident == MPR_USERNAME_INFO_IDENT)
				break;
			error ("I didn't get what I expected, can't continue, sorry.\n");
			exit (1);
		}
		MPR_PLAYERS[i].racer_info_ident = racer_info_ident;
		size = fread (&(MPR_PLAYERS[i]) + sizeof (word), 1,
				sizeof (PLAYER_INFO) - sizeof (word), f);

		if (size != sizeof (PLAYER_INFO) - sizeof (word)) {
			error ("IO, reading players, expected %d, got %d\n",
					sizeof (PLAYER_INFO) - sizeof (word), size);
			exit (1);
		}
		i++;
		if (i == MPR_MAX_PLAYERS) {
			error ("Too many players?\n");
			error ("I didn't get what I expected, can't continue, sorry.\n");
			exit (1);
		}
	}
	MPR_NO_PLAYERS_STARTED = i;

//	printf ("Current position: %lx\n", ftell (f));

	//Skip host block
	fseek (f, sizeof (LFS_USERNAME_INFO) - sizeof (word), SEEK_CUR);

//	printf ("Current position: %lx\n", ftell (f));
	for (i = 0 ; i < MPR_NO_PLAYERS_STARTED; i++) {
		size = fread (&(MPR_USERNAMES[i]), 1, sizeof (LFS_USERNAME_INFO), f);
		if (size != sizeof (LFS_USERNAME_INFO)) {
			error ("IO, reading players, expected %d, got %d\n",
					sizeof (LFS_USERNAME_INFO), size);
			exit (1);
		}
		if (MPR_USERNAMES[i].username_info_ident != MPR_USERNAME_INFO_IDENT) {
			error ("username_info_ident doesn't match, expected %x, got %x\n",
					MPR_USERNAME_INFO_IDENT,
					MPR_USERNAMES[i].username_info_ident);
			exit(1);
		}
		strip_colors_in_name (&(MPR_USERNAMES[i]));
//		printf ("%s\n", MPR_USERNAMES[i].lfs_username);
	}

	fclose(f);
		
}

