using System;
using WebCamService;
using System.Threading;
using System.IO;


public class ThreadUpload
{
		private string server = "localhost";
		private string remotePath = ".";
		private string username = "anonymous";
        private string password = "anonymous@anonymous.net";
        private string filename = "Filename";
        private string filenameDest = "Filename";
        private Object thisLock = new Object();
        private Mutex myMutex;  

	// Constructeur
    public ThreadUpload(string server, string remotePath, string username, string password, string filename, Mutex mut )
	{
		this.server = server;
		this.remotePath = remotePath;
		this.username = username;
		this.password = password;
		this.filename = filename;
        this.filenameDest = Path.GetDirectoryName( filename ) + Path.DirectorySeparatorChar + "TMP" + Path.GetFileName(filename);
        this.myMutex = mut ;


	}
	
	// Mthode boucle du thread
	public void UpLoad()
	{
        lock (thisLock)
        {
            // RENAME WITH Mutex
                if (myMutex.WaitOne())
                {
                    try
                    {
                        File.Copy(filename, filenameDest, true);
                    }
                    catch (Exception e)
                    {
                        Console.WriteLine("Caught Error ftp.Copy:" + e.Message);
                        System.Threading.Thread.Sleep(200);
                        return;
                    }
                    finally
                    {
                        myMutex.ReleaseMutex();
                    }
                }
            //UPLOAD
                FtpClient ftp = new FtpClient(this.server, this.username, this.password);
                ftp.RemotePath = this.remotePath;
                try
                {
                    ftp.Login();
                }
                catch (Exception e)
                {
                    Console.WriteLine("Caught Error ftp.login:" + e.Message);
                    return;
                }
                try
                {
                    // Upload Temp file to FTP
                    ftp.Upload(this.filenameDest, this.filename);
                }
                catch (Exception e)
                {
                    Console.WriteLine("Caught Error ftp.Upload:" + e.Message);
                    System.Threading.Thread.Sleep(200);
                }
                finally
                {
                    File.Delete(this.filenameDest);
                }
                try
                {
                    ftp.Close();
                }
                catch (Exception e)
                {
                    Console.WriteLine("Caught Error ftp.Close:" + e.Message);
                    System.Threading.Thread.Sleep(200);
                }
       }
    }
}