using System;
using System.Text;

namespace LFSLapper
{
    public class Task
    {
        public readonly string Command;
        public readonly bool IsOnceToExecuteOnly = true;

        int s = -1;
        int min = -1;
        int hr = -1;
        int day = -1;
        int mon = -1;
        int yr = -1;

        public Task(string Command, DateTime DateTime)
        {
            this.Command = Command;

            s = DateTime.Second;
            min = DateTime.Minute;
            hr = DateTime.Hour;
            day = DateTime.Day;
            mon = DateTime.Month;
            yr = DateTime.Year;

            IsOnceToExecuteOnly = true;
        }

        public Task(string Command, string CronSchedule)
        {
            this.Command = Command;

            //parse CronSchedule
            System.Text.RegularExpressions.Regex regex = new System.Text.RegularExpressions.Regex(@"\d+|\*");
            System.Text.RegularExpressions.MatchCollection mc = regex.Matches(CronSchedule);

            if (!regex.IsMatch(CronSchedule) || mc.Count != 6)
                throw new Exception("Error in schedule");

            int val = 0;
            for (int i = 0; i < mc.Count; i++)
            {
                if (mc[i].Value == "*")
                {
                    val = -1;
                    IsOnceToExecuteOnly = false;
                }
                else
                    val = int.Parse(mc[i].Value);

                switch (i)
                {
                    case 0: this.s = val; break;
                    case 1: min = val; break;
                    case 2: hr = val; break;
                    case 3: day = val; break;
                    case 4: mon = val; break;
                    case 5: yr = val; break;
                    default: throw new Exception("Too many fields in schedule");
                }
            }

        }

        bool Equals(DateTime dt)
        {
            return
                (dt.Year == yr || yr == -1) &&
                (dt.Month == mon || mon == -1) &&
                (dt.Day == day || day == -1) &&
                (dt.Hour == hr || hr == -1) &&
                (dt.Minute == min || min == -1) &&
                (dt.Second == s || s == -1);
        }

        public bool IsToExecuteNow()
        {
            return this.Equals(System.DateTime.Now);
        }
    }
}
