using System;
using WebCamService;
using System.Threading;
using System.Diagnostics;
using System.IO;

namespace LFS
{

    public class PlayerStats
    {
        public long personalBestLapTime;
        public string nickName;
        public string datePb;
        public string timePb;
        public long[] splitTime = new long[3];
        public PlayerStats(string nN , string dPb, string tPb, long pb, long s1, long s2, long s3)
        {
            nickName = nN;
            datePb = dPb;
            timePb = tPb;
            //            datePb = System.DateTime.Now.ToShortDateString();
            //            timePb = System.DateTime.Now.ToShortTimeString();
            personalBestLapTime = pb;
            splitTime[0] = s1;
            splitTime[1] = s2;
            splitTime[2] = s3;
            for (int i = 0; i < 3; i++)
            {
                if ( object.ReferenceEquals( splitTime[i],null ) )
                {
                    splitTime[i] = 0;
                }
            }
        }
    }

    class Db
    {

        System.Collections.Hashtable trackTable = new System.Collections.Hashtable();
        string filepath = null;
        string FtpServer = null;
        string FtpLogin = null;
        string FtpPasswd = null;
        string FtpRemotePath = null;
        ThreadUpload threadHandle;
        Mutex myMutex;
        string curVersion = "USERNAME 01";
        
        public Db( Mutex mut )
        {
            Process myProcess = System.Diagnostics.Process.GetCurrentProcess();
            //            this.stringMutex = "LFSDb" + myProcess.Id.ToString();
            this.myMutex = mut;
        }
   
        public bool Load(string filepath, string FtpServer, string FtpLogin, string FtpPasswd, string FtpRemotePath )
        {
            this.filepath = filepath;
            this.FtpServer = FtpServer;
            this.FtpLogin = FtpLogin;
            this.FtpPasswd = FtpPasswd;
            this.FtpRemotePath = FtpRemotePath;

            this.threadHandle = new ThreadUpload(FtpServer, FtpRemotePath, FtpLogin, FtpPasswd, filepath, myMutex);

            try
            {
                while (updPbVersion(filepath) == true) ;
            }
            catch (System.Exception)
            {
                return false;
            }


            try
            {
                using (System.IO.StreamReader sr = new System.IO.StreamReader(filepath))
                {
                    string userName,nickName, datePb, timePb, time, carName, trackName;
                    string split1time, split2time, split3time;

// Update PB file if needed
                    string pbVersion = sr.ReadLine();
                    if (pbVersion.IndexOf( "USERNAME" ) == -1 ) // Si pas fichier avec Username, on efface et on recrer
                        return false;
                    while (true)
                    {
                        userName = sr.ReadLine();
                        nickName = sr.ReadLine();
                        datePb = sr.ReadLine();
                        timePb = sr.ReadLine();
                        if (nickName == null)
                            return true;
                        carName = sr.ReadLine();
                        time = sr.ReadLine();
                        trackName = sr.ReadLine();
                        split1time = sr.ReadLine();
                        split2time = sr.ReadLine();
                        split3time = sr.ReadLine();
                        InsertLapTime(userName, 
                                        nickName, 
                                        datePb, 
                                        timePb, 
                                        carName, 
                                        LFSLapper.timeConv.HMSToLong( time ), 
                                        trackName, 
                                        LFSLapper.timeConv.HMSToLong( split1time ), 
                                        LFSLapper.timeConv.HMSToLong( split2time), 
                                        LFSLapper.timeConv.HMSToLong(split3time)
                        );
                    }
                }
            }
            catch (System.Exception)
            {
                return false;
            }
        }

        public bool Save()
        {
            try
            {
                //Exclude Concurrent access to same file when upload to FTP
                if (myMutex.WaitOne())
                {
                    using (System.IO.StreamWriter sw = new System.IO.StreamWriter(filepath))
                    {
                        sw.WriteLine( curVersion );
                        System.Collections.IDictionaryEnumerator trackenum = trackTable.GetEnumerator();
                        while (trackenum.MoveNext()) //for each track
                        {
                            System.Collections.IDictionaryEnumerator carenum = (trackenum.Value as System.Collections.Hashtable).GetEnumerator();
                            while (carenum.MoveNext()) //for each car type
                            {
                                System.Collections.IDictionaryEnumerator entryenum = (carenum.Value as System.Collections.Hashtable).GetEnumerator();
                                while (entryenum.MoveNext())	//for each player
                                {
                                    sw.WriteLine(entryenum.Key.ToString());
                                    sw.WriteLine((entryenum.Value as PlayerStats).nickName);
                                    sw.WriteLine((entryenum.Value as PlayerStats).datePb);
                                    sw.WriteLine((entryenum.Value as PlayerStats).timePb);
                                    sw.WriteLine(carenum.Key.ToString());
                                    sw.WriteLine(LFSLapper.timeConv.LongToHMS((entryenum.Value as PlayerStats).personalBestLapTime));
                                    sw.WriteLine(trackenum.Key.ToString());
                                    for (int i = 0; i < 3; i++)
                                        sw.WriteLine(LFSLapper.timeConv.LongToHMS((entryenum.Value as PlayerStats).splitTime[i]));

                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("(" + filepath + ")" + ex.Message);   // Print the error message.
                return false;
            }
            finally
            {
                myMutex.ReleaseMutex();
            }
            if (FtpServer != "")
            {
                Thread ftpUpload = new Thread(new ThreadStart(threadHandle.UpLoad));
                ftpUpload.Start();
            }
            return true;
        }

        public bool InsertLapTime(string userName, string nickName, string datePb, string timePb, string carName, long timeLap, string trackName, long split1, long split2, long split3)
        {
            string keyName;
            
            if ( userName == "" )
                keyName = nickName.ToLower();
            else
                keyName = userName.ToLower();

                // create new track table if it doesnt exist yet
            if (!trackTable.ContainsKey(trackName))
                 trackTable[trackName] = new System.Collections.Hashtable();

            System.Collections.Hashtable carTable = trackTable[trackName] as System.Collections.Hashtable;

            // create new car table if it doesnt exist yet
            if (!carTable.ContainsKey(carName))
                carTable[carName] = new System.Collections.Hashtable();

            System.Collections.Hashtable playerTable = carTable[carName] as System.Collections.Hashtable;

            if (playerTable.ContainsKey(keyName))
            {
                if (timeLap < (playerTable[keyName] as PlayerStats).personalBestLapTime)
                {
                    playerTable[keyName] = new PlayerStats(nickName,datePb, timePb, timeLap, split1, split2, split3);
                    return true;
                }
                else return false;
            }

            playerTable[keyName] = new PlayerStats(nickName, datePb, timePb, timeLap, split1, split2, split3);
            return true;
        }


        public class DriverLapEntry : System.IComparable
        {
            public string userName;
            public int group;
            public PlayerStats playerStats;

            public DriverLapEntry(string user, PlayerStats ps)
            {
                userName = user;
                group = -1;
                playerStats = ps;
            }

            public int CompareTo(object x)
            {
                if ((x as DriverLapEntry).playerStats.personalBestLapTime < playerStats.personalBestLapTime)
                    return 1;
                else if ((x as DriverLapEntry).playerStats.personalBestLapTime > playerStats.personalBestLapTime)
                    return -1;
                else
                    return 0;
            }

        }
        public System.Collections.ArrayList MkGroup(int MaxGroupQual, int MaxUserGroupQual, int MinUserGroupQual, int NbRacer)
        {
        
        System.Collections.ArrayList group = new System.Collections.ArrayList();

	    int NbGroup =  NbRacer/MaxUserGroupQual;
	    int reste = NbRacer - ( NbGroup * MaxUserGroupQual );
//        Console.WriteLine("NbGroup:" + NbGroup + " Reste:" + reste);
	    if( NbGroup >= MaxGroupQual ){
		    NbGroup = MaxGroupQual-1;
		    reste = MaxUserGroupQual;
	    }
// Mettre le nombre de pilote pour chaque poule
        int i;
	    for( i = 0; i < NbGroup;i++ )
		    group.Add( MaxUserGroupQual );
        if (reste != 0)
            group.Add(reste);

// Equilibration des poules
	    if( (reste < MinUserGroupQual) && (NbGroup > 0) && (reste != 0)){
//            Console.WriteLine(group[i]);
            group[i] = MinUserGroupQual;
		    int diff = MinUserGroupQual - reste;
		    while( true ){
                for (int j = NbGroup-1; j >= 0; j--)
                {
                    group[j] = ( int )group[j] - 1;
                    diff--;
		    		if( diff == 0 ){
		    			return group;
		    		}
		    	}
		    }
	    }
	    else
		    return group;
	
}
        public System.Collections.ArrayList GetTable(string trackName, string carName, string Filter, bool colorSensitive, System.Collections.Hashtable playerFilter, int MaxGroupQual, int MaxUserGroupQual, int MinUserGroupQual  )
        {
            System.Collections.ArrayList list = new System.Collections.ArrayList();

            if (!trackTable.ContainsKey(trackName))
                return list;

            System.Collections.Hashtable carTable = trackTable[trackName] as System.Collections.Hashtable;

            if (!carTable.ContainsKey(carName))
                return list;

            System.Collections.Hashtable playerTable = carTable[carName] as System.Collections.Hashtable;
            System.Collections.IDictionaryEnumerator entryenum = playerTable.GetEnumerator();

            while (entryenum.MoveNext())
            {
                string userName = entryenum.Key.ToString();
                if (playerFilter == null || playerFilter.ContainsKey(userName.ToLower()))
                {
                    if (colorSensitive)
                    {
                        if ((entryenum.Value as PlayerStats).nickName.ToString().IndexOf(Filter) != -1)
                            list.Add(new DriverLapEntry(entryenum.Key.ToString(), entryenum.Value as PlayerStats));
                    }
                    else
                    {
                        if ((entryenum.Value as PlayerStats).nickName.ToString().Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "").IndexOf(Filter) != -1)
                            list.Add(new DriverLapEntry(entryenum.Key.ToString(), entryenum.Value as PlayerStats));
                    }
                }
            }
            list.Sort();
// Mise  jour des poules, par dfaut tous le monde est -1 = Not Qualified
            if (MaxGroupQual != 0)
            {
                System.Collections.ArrayList group = MkGroup(MaxGroupQual, MaxUserGroupQual, MinUserGroupQual, list.Count);
                int j = 0;
                for (int i = 0; i < group.Count; i++)
                {
                    int k = (int)group[i];
                    while (k-- != 0)
                    {
                        (list[j] as DriverLapEntry).group = i;
                        j++;
                    }
                }
            }
            return list;
        }

        public System.Collections.ArrayList GetTable(string trackName, string carName, System.Collections.Hashtable playerFilter, int MaxGroupQual, int MaxUserGroupQual, int MinUserGroupQual)
        {
            System.Collections.ArrayList list = new System.Collections.ArrayList();

            if (!trackTable.ContainsKey(trackName))
                return list;

            System.Collections.Hashtable carTable = trackTable[trackName] as System.Collections.Hashtable;

            if (!carTable.ContainsKey(carName))
                return list;

            System.Collections.Hashtable playerTable = carTable[carName] as System.Collections.Hashtable;
            System.Collections.IDictionaryEnumerator entryenum = playerTable.GetEnumerator();

            while (entryenum.MoveNext())
            {
                string userName = entryenum.Key.ToString();
                if (playerFilter == null || playerFilter.ContainsKey(userName.ToLower()))
                {
                    list.Add(new DriverLapEntry(entryenum.Key.ToString(), entryenum.Value as PlayerStats));
                }
            }

            list.Sort();
            // Mise  jour des poules, par dfaut tous le monde est -1 = Not Qualified
            if (MaxGroupQual != 0)
            {
                System.Collections.ArrayList group = MkGroup(MaxGroupQual, MaxUserGroupQual, MinUserGroupQual, list.Count);
                int j = 0;
                for (int i = 0; i < group.Count; i++)
                {
                    int k = (int)group[i];
                    while (k-- != 0)
                    {
                        (list[j] as DriverLapEntry).group = i;
                        j++;
                    }
                }
            }
                return list;

        }

        /// <summary>
        /// Gets list of car names.
        /// </summary>
        /// <param name="trackName">Name of track.</param>
        /// <returns></returns>
        public System.Collections.ArrayList GetCars(string trackName)
        {
            System.Collections.ArrayList list = new System.Collections.ArrayList();
            System.Collections.IDictionaryEnumerator carTable = (trackTable[trackName] as System.Collections.Hashtable).GetEnumerator();
            while (carTable.MoveNext())
                list.Add(carTable.Key.ToString());

            list.Sort();
            return list;
        }
        private bool updPbVersion(string filePath)
        {
// If it's not a new version, do nothing
            using (System.IO.StreamReader sr = new System.IO.StreamReader(filepath))
            {
                string pbVersion = sr.ReadLine();
                if (pbVersion.IndexOf("USERNAME") == -1) // Si pas fichier avec Username, on efface et on recrer
                    return false;
                if (pbVersion == curVersion )
                    return false;
            }
            string orig = Path.GetDirectoryName(filepath) + Path.DirectorySeparatorChar + "TMP_" + Path.GetFileName(filepath);
            File.Delete( orig );
            File.Move(filepath, orig);
            using (System.IO.StreamReader sr = new System.IO.StreamReader(orig))
            {
                using (System.IO.StreamWriter sw = new System.IO.StreamWriter(filepath,false))
                {
                    string userName, carName;

                    string pbVersion = sr.ReadLine();
                    switch( pbVersion ){
                        case "USERNAME": // To version 01
                            sw.WriteLine("USERNAME 01");
                            Console.WriteLine("Convert file PB : USERNAME -> USERNAME 01");
                            while (true)
                            {
                                userName = sr.ReadLine();
                                if (userName == null)
                                {
                                    sw.Close();
                                    sr.Close();
                                    File.Delete(orig);
                                    return true;
                                }
                                sw.WriteLine(userName); //username
                                sw.WriteLine(sr.ReadLine()); //nickname
                                sw.WriteLine(sr.ReadLine()); //datePb
                                sw.WriteLine(sr.ReadLine()); //timepB
                                carName = sr.ReadLine();
                                switch (carName)
                                {
                                    case "UF 1000":
                                        carName = "UF1";
                                        break;
                                  case "XF GTI":
                                        carName = "XFG";
                                        break;
                                    case "XR GT":
                                        carName = "XRG";
                                        break;
                                    case "XR GT TURBO":
                                        carName = "XRT";
                                        break;
                                    case "RB4 GT":
                                       carName = "RB4";
                                       break;
                                    case "FXO TURBO":
                                        carName = "FXO";
                                        break;
                                    case "LX4":
                                        carName = "LX4";
                                        break;
                                    case "LX6":
                                        carName = "LX6";
                                        break;
                                    case "RA":
                                        carName = "RAC";
                                        break;
                                    case "FZ50":
                                        carName = "FZ5";
                                        break;
                                    case "MRT5":
                                        carName = "MRT";
                                        break;
                                    case "XF GTR":
                                        carName = "XFR";
                                        break;
                                    case "UF GTR":
                                        carName = "UFR";
                                        break;
                                    case "FORMULA XR":
                                        carName = "FOX";
                                        break;
                                    case "FORMULA V8":
                                        carName = "FO8";
                                        break;
                                    case "FXO GTR":
                                        carName = "FXR";
                                        break;
                                    case "XR GTR":
                                        carName = "XRR";
                                        break;
                                    case "FZ50 GTR":
                                        carName = "FZR";
                                        break;
                                    case "BMW SAUBER":
                                        carName = "BF1";
                                        break;
                                }
                                sw.WriteLine(carName);
                                sw.WriteLine(sr.ReadLine()); //time
                                sw.WriteLine(sr.ReadLine()); //trackName;
                                sw.WriteLine(sr.ReadLine()); //split1time;
                                sw.WriteLine(sr.ReadLine()); //split2time;
                                sw.WriteLine(sr.ReadLine()); //split3time;
                            }
                        default:
                            break;
                    }
                    return false;
                }
            }
        }
    }
}