using System;
namespace LFSLapper
{

    class trackCarData
    {
        public string[] splitAction = new string[3];
        class carInfo
        {
            public string[] splitAction = new string[3];
            public bool[] splitActionSet = new bool[3];
            public string[] split = new string[3];
            public long MaxLapTime;
            
            public carInfo()
            {
                for (int i = 0; i < 3; i++)
                {
                    this.split[i] = "";
                    this.splitAction[i] = "";
                    this.splitActionSet[i] = false;
                    this.MaxLapTime = timeConv.HMSToLong("5.00.00");
                }
            }
        }
        class trackInfo
        {
            public Double len;
            public System.Collections.Hashtable carTable = new System.Collections.Hashtable();
            public trackInfo()
            {
                this.len = 0;
            }
        }
        System.Collections.Hashtable trackTable = new System.Collections.Hashtable();
        System.Collections.Hashtable carTable = new System.Collections.Hashtable();

        public trackCarData(string filePath)
        {
            string readLine;
            string currTrack = null;
            string currCar = null;
            bool debug = false;
            int lineCounter = 0;
            string key;
            string val;
            int idxSplit;

            this.splitAction[0] = "";
            this.splitAction[1] = "";
            this.splitAction[2] = "";
            if (filePath == "")
                return;
            {
                using (System.IO.StreamReader sr = new System.IO.StreamReader(filePath))
                {
                    while (true)
                    {
                        lineCounter++;
                        readLine = sr.ReadLine();
                        if (readLine == null)
                            return;
                        readLine = readLine.Replace("\t", "").Trim();
                        if (readLine.Length == 0)
                            continue;
                        if (readLine[0] == '#') //skip comments
                            continue;
                        int index = readLine.IndexOf('='); //look for first "="
                        if (index == -1)
                            throw new System.Exception(string.Format("Corrupted line #{2} ('{1}') in file {0} (can not find '=' symbol)", filePath, readLine, lineCounter));
                        key = readLine.Substring(0, index);
                        val = readLine.Substring(index + 1);
                        key = key.ToLower().Trim();
                        val = val.Trim();
                        switch (key)
                        {
                            case "track":
                                currTrack = val;
                                break;
                            case "car":
                                currCar = val;
                                break;
                            case "len":
                                if (currTrack == null )
                                    throw new System.Exception(string.Format("Corrupted line #{2} ('{1}') in file {0} (Track no set)", filePath, readLine, lineCounter));
                                val = val.Replace(".", System.Globalization.NumberFormatInfo.CurrentInfo.CurrencyDecimalSeparator);
                                if (!this.trackTable.ContainsKey(currTrack))
                                    this.trackTable[currTrack] = new trackInfo();
                                try
                                {
                                    (this.trackTable[currTrack] as trackInfo).len = double.Parse(val);
                                    if( debug ) Console.WriteLine("Track length"
                                        + "  " + currTrack + " = " + (this.trackTable[currTrack] as trackInfo).len);
                                }
                                catch { }
                                break;
                            case "maxlaptime":
                                if (currTrack == null || currCar == null)
                                {
                                    throw new System.Exception(string.Format("Corrupted line #{2} ('{1}') in file {0} (Track or/and Car no set)", filePath, readLine, lineCounter));
                                }
                                if (!this.trackTable.ContainsKey(currTrack))
                                {
                                    this.trackTable[currTrack] = new trackInfo();
                                }
                                if (!(this.trackTable[currTrack] as trackInfo).carTable.ContainsKey(currCar))
                                {
                                    (this.trackTable[currTrack] as trackInfo).carTable[currCar] = new carInfo();
                                }
                                ((this.trackTable[currTrack] as trackInfo).carTable[currCar] as carInfo).MaxLapTime = timeConv.HMSToLong( val );
                                if (debug) Console.WriteLine("MaxLapTime" 
                                    + "  " + currTrack + "/" + currCar + " = " + val);
                                break;
                            case "split1":
                            case "split2":
                            case "split3":
                                idxSplit = int.Parse(key.Substring(5, 1)) - 1;
                                if (currTrack == null || currCar == null)
                                    throw new System.Exception(string.Format("Corrupted line #{2} ('{1}') in file {0} (Car or track no set)", filePath, readLine, lineCounter));
                                if (!this.trackTable.ContainsKey(currTrack))
                                {
                                    this.trackTable[currTrack] = new trackInfo();
                                }
                                if (!(this.trackTable[currTrack] as trackInfo).carTable.ContainsKey(currCar))
                                {
                                    (this.trackTable[currTrack] as trackInfo).carTable[currCar] = new carInfo();
                                }
                                ((this.trackTable[currTrack] as trackInfo).carTable[currCar] as carInfo).split[idxSplit] = val;
                                if( debug ) Console.WriteLine("Split" + idxSplit
                                        + "  " + currTrack + "/" + currCar + " = " + val); 
                                break;
                            case "split1action":
                            case "split2action":
                            case "split3action":
                                idxSplit = int.Parse(key.Substring(5, 1)) - 1;
                                if (currTrack == null || currCar == null)
                                {
                                    if (debug) Console.WriteLine("GlobSplitAction" + idxSplit + " = " + val); 
                                    this.splitAction[idxSplit] = val;
                                    break;
                                }
                                if (!this.trackTable.ContainsKey(currTrack))
                                {
                                    this.trackTable[currTrack] = new trackInfo();
                                }
                                if (!(this.trackTable[currTrack] as trackInfo).carTable.ContainsKey(currCar))
                                {
                                    (this.trackTable[currTrack] as trackInfo).carTable[currCar] = new carInfo();
                                }
                                ((this.trackTable[currTrack] as trackInfo).carTable[currCar] as carInfo).splitAction[idxSplit] = val;
                                ((this.trackTable[currTrack] as trackInfo).carTable[currCar] as carInfo).splitActionSet[idxSplit] = true;
                                if (debug) Console.WriteLine("SplitAction" + idxSplit 
                                    + "  " + currTrack + "/" + currCar + " = " + val); 
                                break;
                        }
                    }
                }
            }
        }
        public double getLen( string track )
        {
            if (track == "" || track == null )
                return 0;
            if (this.trackTable.ContainsKey(track))
                return (this.trackTable[track] as trackInfo).len;
            else
                return 0;
        }
        public string getSplitAction(string track, string car, int splitNumber, long STime)
        {
            carInfo ci;
            string retVal = "";

            if (track == "" || track == null)
                goto fin;
            if (car == "" || car == null)
                goto fin;
            if (this.trackTable.ContainsKey(track))
            {
                if ((this.trackTable[track] as trackInfo).carTable.ContainsKey(car))
                    ci = ((this.trackTable[track] as trackInfo).carTable[car] as carInfo);
                else
                    goto fin;
            }
            else
                goto fin;
// If no split Set
            if (ci.split[splitNumber - 1] == "")
            {
                goto fin;
            }
//Explode all split test
            string[] arSplit = ci.split[splitNumber - 1].Split(':');
//Explode all action and select the appropriate action
            string[] arSplitAction;
            if (ci.splitActionSet[splitNumber - 1])
                arSplitAction = ci.splitAction[splitNumber - 1].Split(':');
            else
                arSplitAction = this.splitAction[splitNumber - 1].Split(':');
            
            for (int i = 0; i <= arSplit.GetUpperBound(0); i++)
            {
                if (STime <= timeConv.HMSToLong(arSplit[i]))
                {
                    try
                    {
                        retVal = arSplitAction[i];
                        goto fin;
                    }
                    catch { goto fin; }
                }
            }
fin:
//            Console.WriteLine("Temp : " + track + "/" + car + " " + timeConv.LongToHMS( STime ) + " Action : >" + retVal + "<" );

            return retVal;
        }
        public string getAvgSpeed(string track, long STime)
        {
            string retVal = "";

            if (track == "" || track == null)
                goto finavg;
            if (this.trackTable.ContainsKey(track))
            {
                try
                {
                    double avgSpeed = ((double)(this.trackTable[track] as trackInfo).len * timeConv.HMSToLong("60.00.00") )/ STime;
                    if (avgSpeed == 0)
                        retVal = "-";
                    else
                        retVal = string.Format("{0:n}" ,avgSpeed);
                    goto finavg;
                }
                catch
                {
                    goto finavg;
                }
            }
        finavg:

//            Console.WriteLine("Temp : " + track + " " + timeConv.LongToHMS(STime) + " AvgSpeed = " + retVal);
            return retVal;
        }
        public long getMaxLapTime(string track, string car)
        {
            long retVal = timeConv.HMSToLong( "5.00.00" );

            if (track == "" || track == null)
                goto finavg;
            if (this.trackTable.ContainsKey(track))
            {
                if ((this.trackTable[track] as trackInfo).carTable.ContainsKey(car))
                {
                    carInfo ci = ((this.trackTable[track] as trackInfo).carTable[car] as carInfo);
                    retVal = ci.MaxLapTime;
                }
            }
        finavg:
//            Console.WriteLine("MaxLapTime : " + track + "/" + car + " " + timeConv.LongToHMS( retVal ));
            return retVal;
        }
    }
}