using System;
using System.Text;

namespace LFSLapper
{
    class Player
    {
        public string UserName;
        public string NickName;
        public int ConnectionNumber;
        public int UniqueID;

        public double absangle;
        public double totaldriftscore,lastdriftscore,driftticks;
        public double speed, direction, heading;

        public int idleticks;
        public bool OnIdleAction1Sended = false;
        
        public int stuntticks;
        public double AngVel;

        public double maxLapSpeed;

        public bool accelerationInProgress;
        public System.DateTime timeSinceZeroSpeed;
        public System.TimeSpan accelerationTime;
        public bool accelerationTimeValid;

        public double x, y;

        public int floodcount;
        public DateTime LastLine = DateTime.Now;

        public int drivethroughcount;
        public int stopgocount;

        public Player(string username, string nickname, int connectionnum)
        {
            UserName = username;
            NickName = nickname;
            ConnectionNumber = connectionnum;
            UniqueID = -1;
        }
    }

    public class Players
    {
        public System.Collections.ArrayList plys = new System.Collections.ArrayList();

        public void Add(string username, string nickname, int connectionnum )
        {
            plys.Add(new Player(username,nickname,connectionnum));
        }

        public void Remove(string username, string nickname)
        {
            for (int i = 0; i < plys.Count; i++)
            {
                Player p = (Player)plys[i];
                if (p.UserName == username && p.NickName == nickname)
                {
                    plys.RemoveAt(i);
                    return;
                }
            }
        }

        public void UpdateUniqueID(string username, string nickname, int uniqueid)
        {
            int idx = GetByUsernameAndNickname(username, nickname);
            if(idx == -1)
                idx = plys.Add(new Player(username, nickname, 1));
            
            if (idx != -1 && uniqueid != -1)
                ((Player)plys[idx]).UniqueID = uniqueid;
        }

        public static double Distance(double x1, double y1, double x2, double y2)
        {
            return Math.Sqrt(Math.Pow((x1-x2),2) + Math.Pow((y1-y2),2));
        }
        static double AbsoluteAngleDifference(double d, double h)
        {
            double absdiff = Math.Abs(d - h);

            if (absdiff <= 180)
                return absdiff;

            if (d < 180)
            {
                h -= 360;
                return d - h;
            }
            else
            {
                d -= 360;
                return h - d;
            }
        }

        public void UpdateState(int uniqueid, double x, double y, double z, double speed, double direction, double heading, double anglevelocity, int minspeed, int minangle, int maxangle, int MinVel, double accelStartSpeed, double accelEndSpeed)
        {
            int idx = GetByUniqueID(uniqueid);
            //System.Console.WriteLine("update state index:{0}", idx);
            if(idx != -1)
            {
                Player p = (Player)plys[idx];

                // drifting

                p.absangle = AbsoluteAngleDifference(p.direction, p.heading);
                double driftscoreinthistick = p.absangle * speed * speed / 10000d;

                if (speed < minspeed)
                {
                    p.driftticks = 0;
                    p.totaldriftscore = 0;
                    p.lastdriftscore = 0;
                }
                else
                {
                    if (p.absangle > minangle && p.absangle < maxangle)
                    {
                        p.driftticks++;
                        p.lastdriftscore += driftscoreinthistick;
                        p.totaldriftscore += driftscoreinthistick;
                        //System.Console.WriteLine(string.Format("DRIFT: {0} {1} {2} {3} score: {4}", p.UserName, p.NickName, p.UniqueID, p.ConnectionNumber, p.driftscore));
                    }
                    else
                    {
                        p.driftticks = 0;
                    }
                }

                p.direction = direction;
                p.heading = heading;
                p.speed = speed;
                p.AngVel = anglevelocity;
                p.x = x;
                p.y = y;
                
                // anglevelocity

                if (anglevelocity > MinVel)
                    p.stuntticks++;
                else
                    p.stuntticks = 0;

                // idling

                p.idleticks = speed>1?0:p.idleticks+1;
                if (speed > 1)
                    p.OnIdleAction1Sended = false;
                
                // speed

                if (speed > p.maxLapSpeed)
                    p.maxLapSpeed = speed;

                // acceleration

                if (speed < accelStartSpeed/*0.1*/)
                {
                    p.timeSinceZeroSpeed = System.DateTime.Now;
                    p.accelerationInProgress = true;
                    //System.Console.WriteLine("measurement started");
                }
                else if (speed > accelEndSpeed/*100*/ && p.accelerationInProgress)
                {
                    p.accelerationTime = System.DateTime.Now - p.timeSinceZeroSpeed;
                    //System.Console.WriteLine("100 km/h in {0} seconds",p.accelerationTime.TotalSeconds);
                    p.accelerationInProgress = false;
                    p.accelerationTimeValid = true;
                }

            }
        }

        public void Rename(string username, string oldnick, string newnick)
        {
            int idx = GetByUsernameAndNickname(username, oldnick);
            if (idx != -1)
                ((Player)plys[idx]).NickName = newnick;
        }

        public int GetByUsernameAndNickname(string username, string nickname)
        {
            for (int i = 0; i < plys.Count; i++)
            {
                Player p = (Player)plys[i];
                if (p.UserName == username && p.NickName == nickname)
                    return i;
            }

            return -1;
        }

        public int GetByUniqueID(int uniqueid)
        {
            for (int i = 0; i < plys.Count; i++)
                if (((Player)plys[i]).UniqueID == uniqueid && uniqueid!=-1)
                    return i;

            return -1;
        }

        public int GetByNickname(string nickname)
        {
            for (int i = 0; i < plys.Count; i++)
            {
                Player p = (Player)plys[i];
                if (p.NickName == nickname)
                    return i;
            }

            return -1;
        }

        public int GetByColorlessNickname(string nickname)
        {
            for (int i = 0; i < plys.Count; i++)
            {
                Player p = (Player)plys[i];
                if (p.NickName.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "") == nickname)
                    return i;
            }

            return -1;
        }
    }
}
