#define MONO

using System;
using System.Diagnostics;
using System.Threading;

namespace LFSLapper
{
    class LFSLapper
    {
        #region Main

        /// <summary>
        /// References GNU GPL License
        /// </summary>
        static void PrintLicense()
        {
            Console.WriteLine(System.Reflection.Assembly.GetExecutingAssembly().ToString());
            Console.WriteLine("Copyright (C) 2005-2007 Janez Cufer");
            Console.WriteLine("LFSLapper comes with ABSOLUTELY NO WARRANTY");
            Console.WriteLine("This is free software, and you are welcome to redistribute it");
            Console.WriteLine("under certain conditions. Read LICENSE for details.");
            Console.WriteLine();
        }

        /// <summary>
        /// Prints command line usage with license.
        /// </summary>
        static void PrintUsage()
        {
            Console.WriteLine("Usage: LFSLapper.exe scriptfilename [debug]\n");
            Console.WriteLine("Report bugs and suggestions to: janez@monkster.hopto.org\n");
        }

        [STAThread]
        static void Main(string[] Args)
        {
            try
            {
                PrintLicense();
                
                if (Args.Length > 2)
                {
                    PrintUsage();
                    return;
                }

                bool debugmode = false;
                if (Args.Length > 1)
                    debugmode = Args[1].ToUpper() == "DEBUG";

                if (Args.Length == 0)
                {
                    LFSClient lfsclient = new LFSClient("LFSLapper.cfg", false);
//                    LFSClient lfsclient = new LFSClient("LFSLapper.cfg", true);
                }
                else
                {
                    LFSClient lfsclient = new LFSClient(Args[0], debugmode);
                }
            }
            catch (Exception ex)
            {
//                System.Console.WriteLine(ex.Message);
                Console.WriteLine("The following error occurred:");
                Console.WriteLine(ex.Message);   // Print the error message.
                Console.WriteLine(ex.Source);    // Name of application or object that caused the error.
                Console.WriteLine(ex.StackTrace); //String that contains the stack trace for this exception.
                Console.WriteLine(ex.TargetSite ); //String that contains the stack trace for this exception.
                System.Threading.Thread.Sleep(50000);
            }
        }

        #endregion
    }
    class tempStat{
        public int PLID;
        public int UCID;
        public string userName;
        public long split1;
        public long split2;
        public long split3;
        public long splitLast;
        public long bestSplit1Diff;
        public long bestSplit2Diff;
        public long bestSplit3Diff;
        public long bestSplitLast;
        public double bestSpeed;
        public string CName;

        public tempStat()
        {
            this.split1 = 0;
            this.split2 = 0;
            this.split3 = 0;
            this.splitLast = 0;
            this.bestSplit1Diff = 0;
            this.bestSplit2Diff = 0;
            this.bestSplit3Diff = 0;
            this.bestSplitLast = 0;
            this.bestSpeed = (double)0;
            this.CName = "";
           
        }
    }
    public class posQualUser
    {
        public int posUser;
        public int totalUser;
        public int groupUser;

        public posQualUser(int pos, int total, int group)
        {
            this.posUser = pos;
            this.totalUser = total;
            this.groupUser = group;
        }
    }

    class LFSClient
    {
        Mutex myMutex = new Mutex(false);
        LFS.Db lfsDb;
        LFS.DriftDb lfsDriftDb;

        InSim.Connect insimConnection = new InSim.Connect();

        class UN
        {
            public string userName;
            public string nickName;
            public UN(string userName, string nickName)
            {
                this.userName = userName;
                this.nickName = nickName;
            }
        }
        trackCarData trackInfo;
        System.Collections.Hashtable playerTmpStatTable = new System.Collections.Hashtable();
        System.Collections.Hashtable PLIDToUCID = new System.Collections.Hashtable();
        System.Collections.Hashtable UCIDToUN = new System.Collections.Hashtable();
//        System.Collections.Hashtable playerTable = new System.Collections.Hashtable();
        System.Collections.Hashtable playerFilter = new System.Collections.Hashtable();
        #region file configuration options

        string[] onConnectLines;
        string[] autoActionLines;
        string[] autoMsgLinesPrivate;
        string PBAction;
        string PBQualAction;
        string DriftPBAction;
        string DriftLapAction;
        string DriftTooLowAction;
        string RaceStartAction;
        string PrivMessSpb1Up, PrivMessSpb2Up, PrivMessSpb3Up, PrivMessSpbLastUp;
        string PrivMessSpb1Low, PrivMessSpb2Low, PrivMessSpb3Low, PrivMessSpbLastLow;
        string OnIdleAction1;
        string OnIdleAction2;
        int OnIdleTimeout1 = 60;
        int OnIdleTimeout2 = 120;
        
        int MaxNbInStunt = -1;
        String MaxNbInStuntAction = "";

        #region Drifting options
        int MinimumDriftScore = 1;
        string PrivateMessageOnDriftScore;
        int MinimumDriftSpeed = 50;
        int MinimumDriftAngle = 15; int MaximumDriftAngle = 90;
        string GoodDriftAction = "";
        int GoodDriftScore = 5000;
        #endregion

        #region Acceleration options
        double AccelerationStartSpeed = 1000;//0.1;
        double AccelerationEndSpeed = 10000;//100.0;
        string AccelerationPrivateMessage = "";
        double AccelerationPrivateMaxTime = 10;
        #endregion

        #region Flood options

        string FloodAction = "";
        int MaxFloodLines = 3;
        int MaxFloodLinesTime = 3000;

        #endregion

        string EnterPitAction = "";
        string LeaveRaceAction = "";

        string DriveThroughPenaltyAction = "";
        string StopGoPenaltyAction = "";
        string Time45PenaltyAction = "";
        string Time30PenaltyAction = "";
        int MaxDriveThroughPenalties = 3;
        int MaxStopGoPenalties = 3;

        bool UseUsernameForAuthentication = false;
        bool ShowPlayerControl = false;

        bool ShowSplitPB = true;
        
        #region Qualification Option
        string QualUsers;
        bool RefreshQualUsers = false;
        int MaxGroupQual = 0;
        int MaxUserGroupQual = 0;
        int MinUserGroupQual = 0;
        #endregion

        int MinAngleVelocity = 200;
        string AngleVelocityAction = "";

        string DefaultTopCar = "";

        int MessageTime = 10000;

        System.Collections.ArrayList shortCarNames = new System.Collections.ArrayList();
        System.Collections.ArrayList longCarNames = new System.Collections.ArrayList();
        bool debugmode = false;
        string currentTrackName = "";
        System.Timers.Timer timer;
        System.Timers.Timer ScheduleTimer;

        System.Collections.ArrayList Tasks = new System.Collections.ArrayList();

        Players lfsPlayers = new Players();

        #endregion
        
        #region Send Message Helpers

        /// <summary>
        /// Executes action
        /// </summary>
        /// <param name="msg"></param>

        bool UpdateQualUsers(string QualUsers)
        {
            int authidx;
           
            playerFilter.Clear();
            if (QualUsers == "")
                return true;
            authidx = QualUsers.IndexOf("@"); // If list of user is in cfg file
            if (authidx != -1)
            {
                string[] ListUsers = QualUsers.Substring(authidx + 1).Split(',');
                foreach ( string username in ListUsers)
                {
                    if (username.IndexOf("DefGroup") != -1)
                    {
                        string[] line = username.Split(':');
                        string[] value = line[1].Trim().Split(';');
                        try { 
                            MaxGroupQual = int.Parse(value[0]);
                            MaxUserGroupQual = int.Parse(value[1]);
                            MinUserGroupQual = int.Parse(value[2]);
                        }
                        catch (Exception) 
                        { 
                            MaxGroupQual = 0;
                            MaxUserGroupQual = 0;
                            MinUserGroupQual = 0;
                        }
                        
                    }
                    else
                        playerFilter[username.ToLower()] = true;
                }
                return true;
            }
            authidx = QualUsers.IndexOf("&"); // if QualUsers is a name of file containing list of user
            if (authidx != -1)
            {
                string username;
                try
                {
                    using (System.IO.StreamReader sr = new System.IO.StreamReader(QualUsers.Substring(authidx + 1)))
                    {
                        while (true)
                        {
                            username = sr.ReadLine();
                            if (username == null)
                                return true;
                            if (username.IndexOf("DefGroup") != -1)
                            {
                                string[] line = username.Split(':');
                                string[] value = line[1].Trim().Split(';');
                                try
                                {
                                    MaxGroupQual = int.Parse(value[0]);
                                    MaxUserGroupQual = int.Parse(value[1]);
                                    MinUserGroupQual = int.Parse(value[2]);
                                }
                                catch (Exception)
                                {
                                    MaxGroupQual = 0;
                                    MaxUserGroupQual = 0;
                                    MinUserGroupQual = 0;
                                }

                            }
                            else
                                playerFilter[username.ToLower()] = true;
                        }
                    }
                }
                catch (System.Exception ex)
                {
                    Console.WriteLine("(" + QualUsers + ")" + ex.Message);   // Print the error message.
                    return false;
                }
            }
            return false;
        }
        public string UserNameByUCID(int UCID)
        {
            return (UCIDToUN[UCID] as UN).userName;
        }
        public string NickNameByUCID(int UCID)
        {
            return (UCIDToUN[UCID] as UN).nickName;
        }
        public string UserNameByPLID(int PLID)
        {
            return (UCIDToUN[(int)PLIDToUCID[PLID]] as UN).userName;
        }
        public string NickNameByPLID(int PLID)
        {
            return (UCIDToUN[(int)PLIDToUCID[PLID]] as UN).nickName;
        }
        void SendMsg(string msg)
        {
            if (msg.Length > 0)
            {
                byte[] outMsg = InSim.Encoder.MST(msg);
                insimConnection.Send(outMsg, outMsg.Length);
            }
        }

        void SendMsg(byte []msg)
        {
            byte[] outMsg = InSim.Encoder.MST(msg);
            insimConnection.Send(outMsg, outMsg.Length);
        }

        void SendMsgToConnection(int UCID, string msg)
        {
            if (msg.Length > 0)
            {
//                System.Console.WriteLine(msg);
                byte[] outMsg = InSim.Encoder.MTC(UCID, 0, msg);
                insimConnection.Send(outMsg, outMsg.Length);
            }
        }

        void SendMsgToConnection(int UCID, byte []msg)
        {
            byte[] outMsg = InSim.Encoder.MTC(UCID, 0, msg);
            insimConnection.Send(outMsg, outMsg.Length);
        }
/*
        void SendMsgToPlayer(int playerID, string msg)
        {
            if (msg.Length > 0)
            {
                byte[] outMsg = InSim.Encoder.MTC(0, playerID, msg);
                insimConnection.Send(outMsg, outMsg.Length);
            }
        }

        void SendMsgToPlayer(int PLID, byte []msg)
        {
            byte[] outMsg = InSim.Encoder.MTC(0, PLID, msg);
            insimConnection.Send(outMsg, outMsg.Length);
        }
*/
        #endregion


        bool SplitNotify(InSim.Decoder.SPX splitdec)
        {
            string nickName = null;
            long t;
            long diff;
            long best;
            string CurSplit="";
            string DiffSplit="";
            string BestSplit="";
            string BestSpeed="";
            string Tpb="";
            string splitAction = "";
            string spbAction = "";
            
            if (!PLIDToUCID.ContainsKey(splitdec.PLID))
                return true;


            nickName = NickNameByPLID(splitdec.PLID);
            if (!playerTmpStatTable.ContainsKey(nickName))
            {
                return true;
            }
            if (splitdec.Split == 1)
            {
                    t = splitdec.STime;
                    diff = t - (playerTmpStatTable[nickName] as tempStat).bestSplit1Diff;

                    CurSplit = timeConv.LongToHMS( t );
                    DiffSplit = timeConv.LongToHMS(diff);
                    BestSplit = timeConv.LongToHMS(((playerTmpStatTable[nickName] as tempStat).bestSplit1Diff));
                    BestSpeed = string.Format("{0:n}",(playerTmpStatTable[nickName] as tempStat).bestSpeed.ToString());

                    if (t < (playerTmpStatTable[nickName] as tempStat).bestSplit1Diff || (playerTmpStatTable[nickName] as tempStat).bestSplit1Diff == 0 )
                    {
                        (playerTmpStatTable[nickName] as tempStat).bestSplit1Diff = t;
                        spbAction = PrivMessSpb1Low;
                    }
                    else
                    {
                        spbAction = PrivMessSpb1Up;
                    }
                    best = ((playerTmpStatTable[nickName]as tempStat).bestSplit1Diff)
                                + (playerTmpStatTable[nickName] as tempStat).bestSplit2Diff
                                + (playerTmpStatTable[nickName]as tempStat).bestSplit3Diff
                                + (playerTmpStatTable[nickName] as tempStat).bestSplitLast
                                ;
                    Tpb = timeConv.LongToHMS( best );

            }
            else if (splitdec.Split == 2)
            {
                    t = splitdec.STime - (playerTmpStatTable[nickName] as tempStat).split1;
                    diff = t - (playerTmpStatTable[nickName] as tempStat).bestSplit2Diff;
                    CurSplit = timeConv.LongToHMS(t);
                    DiffSplit = timeConv.LongToHMS(diff);
                    BestSplit = timeConv.LongToHMS((playerTmpStatTable[nickName] as tempStat).bestSplit2Diff);
                    BestSpeed = string.Format("{0:n}",(playerTmpStatTable[nickName] as tempStat).bestSpeed.ToString());

                    if (t < (playerTmpStatTable[nickName] as tempStat).bestSplit2Diff || (playerTmpStatTable[nickName] as tempStat).bestSplit2Diff == 0 )
                    {
                        (playerTmpStatTable[nickName] as tempStat).bestSplit2Diff = t;
                        spbAction = PrivMessSpb2Low;

                    }
                    else
                    {
                        spbAction = PrivMessSpb2Up;
                    }
                    best = ((playerTmpStatTable[nickName] as tempStat).bestSplit1Diff)
                                + (playerTmpStatTable[nickName] as tempStat).bestSplit2Diff
                                + (playerTmpStatTable[nickName] as tempStat).bestSplit3Diff
                                + (playerTmpStatTable[nickName] as tempStat).bestSplitLast
                                ;
                    Tpb = timeConv.LongToHMS( best );

            }
            else if (splitdec.Split == 3)
            {
                t = splitdec.STime - (playerTmpStatTable[nickName]as tempStat).split2;
                diff = t - (playerTmpStatTable[nickName] as tempStat).bestSplit3Diff;
                CurSplit = timeConv.LongToHMS(t);
                DiffSplit = timeConv.LongToHMS( diff );
                BestSplit = timeConv.LongToHMS((playerTmpStatTable[nickName] as tempStat).bestSplit3Diff );
                BestSpeed = string.Format("{0:n}",(playerTmpStatTable[nickName] as tempStat).bestSpeed.ToString());

                if (t < (playerTmpStatTable[nickName] as tempStat).bestSplit3Diff || (playerTmpStatTable[nickName] as tempStat).bestSplit3Diff == 0)
                {
                    (playerTmpStatTable[nickName] as tempStat).bestSplit3Diff = t;
                    spbAction = PrivMessSpb3Low;

                 }
                 else
                 {
                    spbAction = PrivMessSpb3Up;
                 }
                 best = ((playerTmpStatTable[nickName] as tempStat).bestSplit1Diff)
                             + (playerTmpStatTable[nickName] as tempStat).bestSplit2Diff
                             + (playerTmpStatTable[nickName] as tempStat).bestSplit3Diff
                             + (playerTmpStatTable[nickName] as tempStat).bestSplitLast
                             ;
                 Tpb = timeConv.LongToHMS( best );

            }
            splitAction = trackInfo.getSplitAction(currentTrackName, (playerTmpStatTable[nickName] as tempStat).CName, splitdec.Split, splitdec.STime);
            if (splitAction != "")
            {
                splitAction = splitAction.Replace("{SplitTime}", timeConv.LongToHMS( splitdec.STime));
                splitAction = splitAction.Replace("{Nickname}", nickName);

                if (splitAction.IndexOf("/rcm_") != -1)
                    RestartTimer();

                string[] respcommands = splitAction.Split('|');
                foreach (string respcommand in respcommands)
                    SendMsg(respcommand);
            }
            if (ShowSplitPB && spbAction != "" )
            {
                spbAction = spbAction.Replace("{Nickname}", nickName);
                spbAction = spbAction.Replace("{Username}", (playerTmpStatTable[nickName] as tempStat).userName);
                spbAction = spbAction.Replace("{CurSplit}", CurSplit);
                spbAction = spbAction.Replace("{BestSplit}", BestSplit);
                spbAction = spbAction.Replace("{DiffSplit}", DiffSplit);
                spbAction = spbAction.Replace("{BestSpeed}", string.Format("{0:n}", BestSpeed));
                spbAction = spbAction.Replace("{Tpb}", Tpb);
                posQualUser retValue;
                retValue = getPosQual((playerTmpStatTable[nickName] as tempStat).userName, nickName, true);
                if( retValue.posUser != 0 )
                    spbAction = spbAction.Replace("{Posqual}", retValue.posUser + "/" + retValue.totalUser);
                else
                    spbAction = spbAction.Replace("{Posqual}", "-/-");
                if( retValue.groupUser != -1 )
                    spbAction = spbAction.Replace("{Groupqual}", ((char)(retValue.groupUser + 65)).ToString());
                else
                    spbAction = spbAction.Replace("{Groupqual}", "-");

                retValue = getPosQual((playerTmpStatTable[nickName] as tempStat).userName, nickName, false);
                spbAction = spbAction.Replace("{Posabs}", retValue.posUser + "/" + retValue.totalUser);

                SendMsgToConnection((playerTmpStatTable[nickName] as tempStat).UCID, spbAction);
//                SendMsgToPlayer((playerTmpStatTable[nickName] as tempStat).PLID, spbAction);
            }
            return true;

        }

        void Ver(int UCID)
        {
            try
            {
//                playerIdToSend = (byte)(playerTmpStatTable[(string)playerNameToSend] as tempStat).PLID;


                SendMsgToConnection(UCID, System.Reflection.Assembly.GetExecutingAssembly().FullName);
                SendMsgToConnection(UCID, "^3http://monkster.hopto.org/~janez/LFSLapper/LFSLapper.html");
            }
            catch (System.Exception)
            {
                return;
            }
        }
        
        void SendMultilineMsgPrivate(int UCID,string nickname,string cmd, string resp, int off)
        {
            string playerNameToSend = nickname;

            string[] multilineresp = resp.Split(':');

            try
            {
                for (int i = 0; i < multilineresp.Length; i++)
                {
                    string lineToSend = multilineresp[i];

                    lineToSend = lineToSend.Replace("{Nickname}", playerNameToSend);
                    SendMsgToConnection(UCID, this.GlobalOptionsReplace(lineToSend));
                }
            }
            catch (System.Exception)
            {
                return;
            }
        }
        
        void Top(int UCID,string username,string nickname,string cmd, bool flagqual )
        {

            string playerNameToSend = nickname;
            string filtervalue = "";

            string carName = DefaultTopCar;
            int from = 1;

            string [] splitCmd = cmd.Split(' ');
            for (int i = 1; i <= splitCmd.GetUpperBound(0); i++) {
                if (splitCmd[i].Trim() == "")
                    continue;
// find if filter is present
                if (splitCmd[i] == "filter")
                {
                    i++;
                    try { filtervalue = splitCmd[i]; continue; }
                    catch { filtervalue = ""; continue; }
                }
// Find if car is present in line of command
                int j = 0;
                bool flagFind = false;
                foreach (string shortCarName in shortCarNames)
                {
                    if (splitCmd[i].IndexOf(shortCarName) != -1)
                    {
                        carName = (string)shortCarNames[j];
                        flagFind = true;
                        break;
                    }
                    j++;
                }
                if (flagFind)
                    continue;
// Find if offset
                try{from = int.Parse(splitCmd[i]);}
                catch (System.Exception){}
            }

            System.Collections.ArrayList list;
            if( flagqual )
                list = lfsDb.GetTable(currentTrackName, carName, filtervalue, false, playerFilter,MaxGroupQual,MaxUserGroupQual,MinUserGroupQual );
            else
                list = lfsDb.GetTable(currentTrackName, carName, filtervalue, false, null,0,0,0);

            for (int i = from - 1; i >= 0 && i < System.Math.Min(list.Count, from + 14); i++)
            {
                System.Text.StringBuilder sname = new System.Text.StringBuilder();

                string userName = (list[i] as LFS.Db.DriverLapEntry).userName;
                string nickName = (list[i] as LFS.Db.DriverLapEntry).playerStats.nickName;
                sname.Append(nickName);

                System.Text.StringBuilder sb = new System.Text.StringBuilder();
                string sGroup = "";
                if ((list[i] as LFS.Db.DriverLapEntry).group != -1)
                {
                    sGroup = ((char)((list[i] as LFS.Db.DriverLapEntry).group + 65)).ToString();
                }
                if (username.ToLower() == userName.ToLower())
                    sb.AppendFormat("^3{0}. {3}^8 {1} {2}^8", 
                                        i + 1, 
                                        timeConv.LongToHMS((list[i] as LFS.Db.DriverLapEntry).playerStats.personalBestLapTime ),
                                        sname,
                                        sGroup
                    );
                else
                    sb.AppendFormat("^7{0}. {3}^8 {1} {2}^8", 
                                        i + 1, 
                                        timeConv.LongToHMS((list[i] as LFS.Db.DriverLapEntry).playerStats.personalBestLapTime),
                                        sname,
                                        sGroup
                    );

                for (int k = 0; k < 3; k++)
                {
                    long SplitTime = (list[i] as LFS.Db.DriverLapEntry).playerStats.splitTime[k];

                    //only show split time if it is not zero
                    if ( SplitTime != 0 )
                    {
                        sb.Append(" ");
                        sb.Append( timeConv.LongToHMS( SplitTime ));
                    }
                }
                if (username.ToLower() == userName.ToLower())
                    sb.Append("^3 <--------------");
                SendMsgToConnection(UCID, sb.ToString());
            }
        }


        void TopDrift(int UCID, string username, string nickname, string cmd)
        {

            string playerNameToSend = nickname;
            string filtervalue = "";

            string carName = DefaultTopCar;

            int from = 1;

            string[] splitCmd = cmd.Split(' ');
            for (int i = 1; i <= splitCmd.GetUpperBound(0); i++)
            {
                if (splitCmd[i].Trim() == "")
                    continue;
                // find if filter is present
                if (splitCmd[i] == "filter")
                {
                    i++;
                    try { filtervalue = splitCmd[i]; continue; }
                    catch { filtervalue = ""; continue; }
                }
                // Find if car is present in line of command
                int j = 0;
                bool flagFind = false;
                foreach (string shortCarName in shortCarNames)
                {
                    if (splitCmd[i].IndexOf(shortCarName) != -1)
                    {
                        carName = (string)shortCarNames[j];
                        flagFind = true;
                        break;
                    }
                    j++;
                }
                if (flagFind)
                    continue;
                // Find if offset
                try { from = int.Parse(splitCmd[i]); }
                catch (System.Exception) { }
            }

            System.Collections.ArrayList list = lfsDriftDb.GetTable(currentTrackName, carName, filtervalue, false);

            for (int i = from - 1; i >= 0 && i < System.Math.Min(list.Count, from + 14); i++)
            {
                string userName = (list[i] as LFS.DriftDb.DriverLapEntry).userName;
                string nickName = (list[i] as LFS.DriftDb.DriverLapEntry).playerStats.nickName;

                System.Text.StringBuilder sb = new System.Text.StringBuilder();
                if (username.ToLower() == userName.ToLower())
                    sb.AppendFormat("^3{0}.^8 {1} {2}^8", i + 1, (list[i] as LFS.DriftDb.DriverLapEntry).playerStats.personalBestLap, nickName);
                else
                    sb.AppendFormat("^7{0}.^8 {1} {2}^8", i + 1, (list[i] as LFS.DriftDb.DriverLapEntry).playerStats.personalBestLap, nickName);

                if (username.ToLower() == userName.ToLower())
                    sb.Append("^3 <--------------");
                SendMsgToConnection(UCID, sb.ToString());
            }

        }

        void ShowStats(int UCID, string username, string nickname, string cmd, bool flagqual)
        {
            string searchName = nickname.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "");
            string playerNameToSend = nickname;

            // get parameter of command
            try
            {
                if (flagqual)
                    searchName = cmd.Substring(cmd.IndexOf("!statsqual") + 11);
                else
                    searchName = cmd.Substring(cmd.IndexOf("!stats") + 7);
            }
            catch (Exception)
            {
            }


            try
            {
                System.Collections.ArrayList cars = lfsDb.GetCars(currentTrackName);

                foreach (string carName in cars)
                {
                    System.Collections.ArrayList list;
                    if (flagqual)
                        list = lfsDb.GetTable(currentTrackName, carName, playerFilter,MaxGroupQual,MaxUserGroupQual,MinUserGroupQual);
                    else
                        list = lfsDb.GetTable(currentTrackName, carName, null,0,0,0);
                    int position = -1;
                    int tmppos = 0;
                    int nb = list.Count;
                    foreach (LFS.Db.DriverLapEntry de in list)
                    {
                        if (de.playerStats.nickName.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "").IndexOf(searchName) != -1)
                        {
                            position = tmppos;
                            break;
                        }
                        else tmppos++;
                    }

                    if (position == -1) continue;

                    System.Text.StringBuilder sname = new System.Text.StringBuilder();

                    string userName = (list[position] as LFS.Db.DriverLapEntry).userName;
                    string nickName = (list[position] as LFS.Db.DriverLapEntry).playerStats.nickName;
                    sname.Append(nickName);
                    SendMsgToConnection(UCID, string.Format("{3}/{4}. {0}^8 {1} {2}",
                                                                    sname, 
                                                                    timeConv.LongToHMS((list[position] as LFS.Db.DriverLapEntry).playerStats.personalBestLapTime),
                                                                    carName, 
                                                                    position + 1,
                                                                    nb)
                     );

                    System.Text.StringBuilder sb = new System.Text.StringBuilder();

                    for (int k = 0; k < 3; k++)
                    {
                        long SplitTime = (list[position] as LFS.Db.DriverLapEntry).playerStats.splitTime[k];

                        //only show split time if it is not zero
                        if ( SplitTime != 0 )
                        {
                            sb.Append(" ");
                            sb.Append(timeConv.LongToHMS( SplitTime ));
                        }
                    }
                    SendMsgToConnection(UCID, sb.ToString());
                }

            }
            catch (System.Exception)
            {
                return;
            }
        }
        posQualUser getPosQual(string username, string nickname, bool flagqual)
        {
            string searchName = nickname.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "");
            string playerNameToSend = nickname;
            if (!playerFilter.ContainsKey(username.ToLower()) && flagqual)
                return new posQualUser(0, 0, -1);
            try

            {
                string carName;
                if( playerTmpStatTable.ContainsKey(nickname))
                    carName = (playerTmpStatTable[nickname] as tempStat).CName;
                else
                    carName = DefaultTopCar;


                System.Collections.ArrayList list;
                if (flagqual)
                    list = lfsDb.GetTable(currentTrackName,  carName, playerFilter,MaxGroupQual,MaxUserGroupQual,MinUserGroupQual);
                else
                    list = lfsDb.GetTable(currentTrackName,  carName, null,0,0,0);
                int position = -1;
                int tmppos = 0;
                int nb = list.Count;
                foreach (LFS.Db.DriverLapEntry de in list)
                {
                    if (de.playerStats.nickName.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "").IndexOf(searchName) != -1)
                    {
                        position = tmppos;
                        break;
                    }
                    else tmppos++;
                }
                if (position == -1) return new posQualUser(0, 0, -1);


                System.Text.StringBuilder sname = new System.Text.StringBuilder();

                string userName = (list[position] as LFS.Db.DriverLapEntry).userName;
                string nickName = (list[position] as LFS.Db.DriverLapEntry).playerStats.nickName;
                return new posQualUser(position + 1, nb, (list[position] as LFS.Db.DriverLapEntry).group  );
            }
            catch (System.Exception)
            {
                return new posQualUser(0,0,-1);
            }
        }

        void ShowDriftStats(int UCID, string username, string nickname, string cmd)
        {
            string searchName = nickname.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "");
            string playerNameToSend = nickname;

            // get parameter of command
            try
            {
                searchName = cmd.Substring(cmd.IndexOf("!dstats") + 8);
            }
            catch (Exception)
            {
            }

            try
            {

                System.Collections.ArrayList cars = lfsDb.GetCars(currentTrackName);

                foreach (string carName in cars)
                {
                    System.Collections.ArrayList list = lfsDriftDb.GetTable(currentTrackName, carName);
                    int position = -1;
                    int tmppos = 0;
                    foreach (LFS.DriftDb.DriverLapEntry de in list)
                    {
                        if (de.playerStats.nickName.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "").IndexOf(searchName) != -1)
                        {
                            position = tmppos;
                            break;
                        }
                        else tmppos++;
                    }

                    if (position == -1) continue;

                    string userName = (list[position] as LFS.DriftDb.DriverLapEntry).userName;
                    string nickName = (list[position] as LFS.DriftDb.DriverLapEntry).playerStats.nickName;
                    int driftScore = (list[position] as LFS.DriftDb.DriverLapEntry).playerStats.personalBestLap;
                    
                    SendMsgToConnection(UCID, string.Format("{3}. {0}^8 {1} {2}", nickName, driftScore, carName, position + 1));
                }

            }
            catch (System.Exception)
            {
                return;
            }
        }

        void CheckForFlooding(string username, string nickname)
        {
            try
            {
                int idx = lfsPlayers.GetByUsernameAndNickname(username, nickname);

                if (idx != -1)
                {
                    Player p = (Player)lfsPlayers.plys[idx];
                    DateTime now = DateTime.Now;

                    System.TimeSpan ts = now - p.LastLine;
                    p.LastLine = now;

                    if (ts.TotalMilliseconds < MaxFloodLinesTime) //Maximum time betweeen lines to count as flood
                        p.floodcount++;
                    else
                    {
                        p.floodcount = 1;
                        return;
                    }

                    if (p.floodcount > MaxFloodLines)   //max lines to tolerate
                    {
                        p.floodcount = 0;

                        if (FloodAction.IndexOf("/rcm_") != -1)
                            RestartTimer();

                        string _FloodAction = FloodAction;
                        _FloodAction = _FloodAction.Replace("{Nickname}", nickname);
                        _FloodAction = _FloodAction.Replace("{Username}", username);
                        string[] floodcommands = _FloodAction.Split('|');
                        foreach (string floodcommand in floodcommands)
                            SendMsg(GlobalOptionsReplace(floodcommand));
                    }
                }
            }
            catch(Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }

        public LFSClient(string scriptfilename, bool debugmode)
        {

            this.debugmode = debugmode;
            this.lfsDb = new LFS.Db(myMutex);
            this.lfsDriftDb = new LFS.DriftDb(myMutex);


            #region Car Names Tables
            shortCarNames.Add("UF1"); longCarNames.Add("UF 1000");
            shortCarNames.Add("XFG"); longCarNames.Add("XF GTI");
            shortCarNames.Add("XRG"); longCarNames.Add("XR GT");
            shortCarNames.Add("XRT"); longCarNames.Add("XR GT TURBO");
            shortCarNames.Add("RB4"); longCarNames.Add("RB4 GT");
            shortCarNames.Add("FXO"); longCarNames.Add("FXO TURBO");
            shortCarNames.Add("LX4"); longCarNames.Add("LX4");
            shortCarNames.Add("LX6"); longCarNames.Add("LX6");
            shortCarNames.Add("RAC"); longCarNames.Add("RA");
            shortCarNames.Add("FZ5"); longCarNames.Add("FZ50");
            shortCarNames.Add("MRT"); longCarNames.Add("MRT5");
            shortCarNames.Add("XFR"); longCarNames.Add("XF GTR");
            shortCarNames.Add("UFR"); longCarNames.Add("UF GTR");
            shortCarNames.Add("FOX"); longCarNames.Add("FORMULA XR");
            shortCarNames.Add("FO8"); longCarNames.Add("FORMULA V8");
            shortCarNames.Add("FXR"); longCarNames.Add("FXO GTR");
            shortCarNames.Add("XRR"); longCarNames.Add("XR GTR");
            shortCarNames.Add("FZR"); longCarNames.Add("FZ50 GTR");
            shortCarNames.Add("BF1"); longCarNames.Add("BMW SAUBER");
            #endregion

            #region Configuring LFSLapper

            LFS.Configurator cfg = new LFS.Configurator();
            cfg.Load(scriptfilename);

            string adminPassword = cfg.Get("Password");

            string trackInfoFile = cfg.Get("TrackInfoFile");
            trackInfo = new trackCarData(trackInfoFile);
/*
            {
                trackInfo.getSplitAction("AS2", "XFG", 1, timeConv.HMSToLong("0.37.00"));
                trackInfo.getSplitAction("", "XFG", 1, timeConv.HMSToLong("0.37.00"));
                trackInfo.getSplitAction("AS2", "", 1, timeConv.HMSToLong("0.37.00"));
                trackInfo.getSplitAction("AS2", "XFG", 1, timeConv.HMSToLong("0.35.00"));
                trackInfo.getSplitAction("AS2", "XFG", 1, timeConv.HMSToLong("0.32.00"));
            }
*/

/*
            {
                trackInfo.getAvgSpeed( "BL1", timeConv.HMSToLong("1.32.93"));
            }
*/
            string databaseFilePath = cfg.Get("Database");
            if (databaseFilePath == "")
                databaseFilePath = "./PB.txt";

            string driftdatabaseFilePath = cfg.Get("DriftDatabase");
            if (driftdatabaseFilePath == "")
                driftdatabaseFilePath = "./DriftPB.txt";

            string FtpServer = cfg.Get("FtpServer");
            string FtpLogin = cfg.Get("FtpLogin");
            string FtpPasswd = cfg.Get("FtpPasswd");
            string FtpRemotePath = cfg.Get("FtpRemotePath");


            string host = cfg.Get("Host");
            if (host == "") host = "127.0.0.1";

            int port = 29999;
            try { port = int.Parse(cfg.Get("Port")); }
            catch (Exception) { }

            onConnectLines = cfg.Get("ConnectMsg").Split('|');
            PBAction = cfg.Get("PBAction");
            PBQualAction = cfg.Get("PBQualAction");

            EnterPitAction = cfg.Get("EnterPitAction");
            LeaveRaceAction = cfg.Get("LeaveRaceAction");

            #region Pitting Penalties


            DriveThroughPenaltyAction = cfg.Get("DriveThroughPenaltyAction");
            StopGoPenaltyAction = cfg.Get("StopGoPenaltyAction");
            Time45PenaltyAction = cfg.Get("Time45PenaltyAction");
            Time30PenaltyAction = cfg.Get("Time30PenaltyAction");



            try { MaxDriveThroughPenalties = int.Parse(cfg.Get("MaxDriveThroughPenalties")); }
            catch (Exception) { }
            try { MaxStopGoPenalties = int.Parse(cfg.Get("MaxStopGoPenalties")); }
            catch (Exception) { }

            #endregion

            #region Flooding options


            FloodAction = cfg.Get("FloodAction");

            try { MaxFloodLinesTime = int.Parse(cfg.Get("MaxFloodLinesTime")); }
            catch (Exception) { }

            try { MaxFloodLines = int.Parse(cfg.Get("MaxFloodLines")); }
            catch (Exception) { }

            #endregion

            #region Drifting options

            DriftPBAction = cfg.Get("DriftPBAction");
            DriftTooLowAction = cfg.Get("DriftTooLowAction");


            try { MinimumDriftScore = int.Parse(cfg.Get("MinimumDriftScore")); }
            catch (Exception) { }

            try { MinimumDriftSpeed = int.Parse(cfg.Get("MinimumDriftSpeed")); }
            catch (Exception) { }

            try { MinimumDriftAngle = int.Parse(cfg.Get("MinimumDriftAngle")); }
            catch (Exception) { }

            try { MaximumDriftAngle = int.Parse(cfg.Get("MaximumDriftAngle")); }
            catch (Exception) { }

            PrivateMessageOnDriftScore = cfg.Get("PrivateMessageOnDriftScore");
            DriftLapAction = cfg.Get("DriftLapAction");

            GoodDriftAction = cfg.Get("GoodDriftAction");
            try { GoodDriftScore = int.Parse(cfg.Get("GoodDriftScore")); }
            catch (Exception) { }

            #endregion

            #region Idling options

            OnIdleAction1 = cfg.Get("OnIdleAction1");
            OnIdleAction2 = cfg.Get("OnIdleAction2");

            try { OnIdleTimeout1 = 10 * int.Parse(cfg.Get("OnIdleTimeout1")); }
            catch (Exception) { }
            try { OnIdleTimeout2 = 10 * int.Parse(cfg.Get("OnIdleTimeout2")); }
            catch (Exception) { }

            #endregion

            try { MaxNbInStunt = int.Parse(cfg.Get("MaxNbInStunt")); }
            catch (Exception) { }
            if (MaxNbInStunt == -1)
                MaxNbInStunt = 32768;
            MaxNbInStuntAction = cfg.Get("MaxNbInStuntAction");

            autoActionLines = cfg.Get("AutoAction").Split('|');
            autoMsgLinesPrivate = cfg.Get("AutoMsgPrivate").Split('|');

            RaceStartAction = cfg.Get("RaceStartAction");

            PrivMessSpb1Low = cfg.Get("PrivMessSpb1Low");
            PrivMessSpb2Low = cfg.Get("PrivMessSpb2Low");
            PrivMessSpb3Low = cfg.Get("PrivMessSpb3Low");
            PrivMessSpbLastLow = cfg.Get("PrivMessSpbLastLow");

            PrivMessSpb1Up = cfg.Get("PrivMessSpb1Up");
            PrivMessSpb2Up = cfg.Get("PrivMessSpb2Up");
            PrivMessSpb3Up = cfg.Get("PrivMessSpb3Up");
            PrivMessSpbLastUp = cfg.Get("PrivMessSpbLastUp");

            #region Qualification
            try { RefreshQualUsers = bool.Parse(cfg.Get("RefreshQualUser")); }
            catch (Exception) { }
            QualUsers = cfg.Get("QualUsers");
            UpdateQualUsers(QualUsers);
            #endregion

            try { ShowPlayerControl = bool.Parse(cfg.Get("ShowPlayerControl")); }
            catch (Exception) { }

            try { ShowSplitPB = bool.Parse(cfg.Get("ShowSplitPB")); }
            catch (Exception) { }

            try { UseUsernameForAuthentication = bool.Parse(cfg.Get("UseUsernameForAuthentication")); }
            catch (Exception) { }

            try { MinAngleVelocity = int.Parse(cfg.Get("MinAngleVelocity")); }
            catch (Exception) { }

            AngleVelocityAction = cfg.Get("AngleVelocityAction");

            #region Acceleration options
            try { AccelerationStartSpeed = double.Parse(cfg.Get("AccelerationStartSpeed")); }
            catch (Exception) { }
            try { AccelerationEndSpeed = double.Parse(cfg.Get("AccelerationEndSpeed")); }
            catch (Exception) { }
            try { AccelerationPrivateMaxTime = double.Parse(cfg.Get("AccelerationPrivateMaxTime")); }
            catch (Exception) { }
            AccelerationPrivateMessage = cfg.Get("AccelerationPrivateMessage");
            #endregion

            DefaultTopCar = cfg.Get("DefaultTopCar");
            if (DefaultTopCar == "")
                DefaultTopCar = "XRT";

            try { MessageTime = int.Parse(cfg.Get("MessageTime")); }
            catch (Exception) { }

            timer = new System.Timers.Timer(10000);
            timer.AutoReset = false;
            timer.Elapsed += new System.Timers.ElapsedEventHandler(timer_Elapsed);


            #region load scheduled tasks

            string taskline = cfg.Get("ScheduledAction");
            string[] tasks = taskline == string.Empty ? null : taskline.Split('|');

            string[] schedules ={ };
            string[] commands = { };
            int par = 0;
            if (tasks != null)
                foreach (string task in tasks)
                {
                    if (par % 2 == 0)
                        schedules = task.Split(':');
                    else
                    {
                        commands = task.Split(':');

                        foreach (string taskCommand in commands)
                            foreach (string taskSchedule in schedules)
                                Tasks.Add(new Task(taskCommand, taskSchedule));
                    }

                    par++;
                }

            //if (par>1)
            {
                ScheduleTimer = new System.Timers.Timer(1000);
                ScheduleTimer.AutoReset = true;
                ScheduleTimer.Elapsed += new System.Timers.ElapsedEventHandler(ScheduleTimer_Elapsed);
            }

            #endregion

            #endregion

            insimConnection.insimConnect(host, port, adminPassword, "U");
            string info = "Product:" + insimConnection.Product + " Version:" + insimConnection.Version + " InSim Version:" + insimConnection.InSimVersion;
            Console.WriteLine(info);
            if (!lfsDb.Load(databaseFilePath, FtpServer, FtpLogin, FtpPasswd, FtpRemotePath))
                System.Console.WriteLine("Warning:Error loading {0} or file does not exist yet!", databaseFilePath);

            if (!lfsDriftDb.Load(driftdatabaseFilePath, FtpServer, FtpLogin, FtpPasswd, FtpRemotePath))
                System.Console.WriteLine("Warning:Error loading {0} or file does not exist yet!", driftdatabaseFilePath);

            ScheduleTimer.Enabled = true;

            byte[] intervalReq = InSim.Encoder.NLI(100);    //receive status every 100 ms
            insimConnection.Send(intervalReq, intervalReq.Length);

            Console.WriteLine("LFSLapper is running...");
            byte[] sstreq = InSim.Encoder.SST();
            insimConnection.Send(sstreq, sstreq.Length);

            Loop(insimConnection);

            // terminate
            byte[] terreq = InSim.Encoder.ISC();
            insimConnection.Send(terreq, terreq.Length);

            insimConnection.Close();
        }

        void ScheduleTimer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            try
            {
                for (int i = 0; i < Tasks.Count; i++)
                {
                    Task task = (Task)Tasks[i];
                    if (task.IsToExecuteNow())
                    {
                        if (task.Command.IndexOf("/rcm_") != -1)
                            RestartTimer();

                        this.SendMsg(this.GlobalOptionsReplace(task.Command));
                        if (task.IsOnceToExecuteOnly)
                            Tasks.RemoveAt(i--);
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
            }
        }

        void RestartTimer()
        {
            timer.Interval = MessageTime;
            timer.Start();
        }
        
        void timer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            SendMsg("/rcc_all");
        }

        string GlobalOptionsReplace(string action)
        {

            #region time
            action = action.Replace("{ShortTime}", System.DateTime.Now.ToShortTimeString());
            action = action.Replace("{LongTime}", System.DateTime.Now.ToLongTimeString());
            #endregion

            #region date
            action = action.Replace("{ShortDate}", System.DateTime.Now.ToShortDateString());
            action = action.Replace("{LongDate}", System.DateTime.Now.ToLongDateString());
            #endregion

            #region other
            action = action.Replace("{ShortTrackName}",this.currentTrackName);
            #endregion

            #region special chars
            action = action.Replace("{colon}", ":");
            action = action.Replace("{vbar}", "|");
            action = action.Replace("{at}", "@");
            #endregion

            return action;
        }

        void Loop(InSim.Connect insimConnection)
        {
            bool InRace = false;
            string lnickName;
            string luserName;
            bool flagFirst = true;
            while (true)
            {
                byte[] recvPacket = insimConnection.Receive();
#if MONO
#else
                if (remoteEP.Port != ((System.Net.IPEndPoint)uc.Client.RemoteEndPoint).Port)
                {
                    Console.WriteLine("Received UDP packet from unknown port {0}", ((System.Net.IPEndPoint)uc.Client.RemoteEndPoint).Port);
                    continue;
                }
#endif

                if (recvPacket.Length > 3)
                {
                    string packetHead = insimConnection.packetHead(recvPacket);
                    uint verifyID = insimConnection.verifyID(recvPacket);
//                    if (packetHead != "MCI")
//                        Console.WriteLine(packetHead);

                    switch (packetHead)
                    {
                        case "TINY"://confirm ack with ack
                            // Keep ALIVE
                            InSim.Decoder.TINY tiny = new InSim.Decoder.TINY(recvPacket);
                            // Keep alive connection
                            if (tiny.SubT == "TINY_NONE")
                            {
                                byte[] stiny = InSim.Encoder.TINY_NONE();
                                insimConnection.Send(stiny, stiny.Length);
                            }
                            break;

                        case "RST":
                            InRace = true;
                            if (debugmode) Console.WriteLine("Race STart");
                            InSim.Decoder.RST rst = new InSim.Decoder.RST(recvPacket);
                            //Raz of idle on start
                            foreach (Player p in lfsPlayers.plys)
                            {
                                p.idleticks = 0;
                            }
                            if (rst.QualMins == 0) //race began
                            {
                                string Action = RaceStartAction;
                                string[] respcommands = Action.Split('|');
                                foreach (string respcommand in respcommands)
                                    Tasks.Add(new Task(respcommand, DateTime.Now + new TimeSpan(0, 0, 5)));
                            }
                            break;

                        case "REN":
                            if(debugmode)Console.WriteLine("Race ENd (return to entry screen)");
                            break;

                        case "NCN":
                            InSim.Decoder.NCN newConnection = new InSim.Decoder.NCN(recvPacket);
                            
                            if (debugmode) Console.WriteLine(string.Format("New ConN Username:{0} Nickname:{1} ConnectionNumber:{2}",newConnection.userName,newConnection.nickName,newConnection.UCID));
                            UCIDToUN[newConnection.UCID] = new UN(newConnection.userName, newConnection.nickName);
                            lfsPlayers.Add(newConnection.userName, newConnection.nickName, newConnection.UCID);


                            foreach (string line in onConnectLines)
                            {
                                string line2;
                                posQualUser retValue;
                                line2 = line;
                                retValue = getPosQual(newConnection.userName, newConnection.nickName, true);
                                if( retValue.posUser != 0 )
                                    line2 = line2.Replace("{Posqual}",retValue.posUser + "/" + retValue.totalUser  );
                                else
                                    line2 = line2.Replace("{Posqual}", "-/-");
                                if (retValue.groupUser != -1)
                                    line2 = line2.Replace("{Groupqual}", ((char)(retValue.groupUser + 65)).ToString());
                                else
                                    line2 = line2.Replace("{Groupqual}", "-");
                                retValue = getPosQual(newConnection.userName, newConnection.nickName, false);
                                line2 = line2.Replace("{Posabs}", retValue.posUser + "/" + retValue.totalUser);
                                SendMsgToConnection(newConnection.UCID, this.GlobalOptionsReplace(line2));
                            }

                            break;

                        case "CNL":
                            if(debugmode)Console.WriteLine("ConN Leave (end connection is moved down into this slot)");
                            InSim.Decoder.CNL lostConnection = new InSim.Decoder.CNL(recvPacket);
                            luserName = UserNameByUCID(lostConnection.UCID);
                            lnickName = NickNameByUCID(lostConnection.UCID);
                            lfsPlayers.Remove(luserName,lnickName);
                            if (playerTmpStatTable.ContainsKey(lnickName))
                                playerTmpStatTable.Remove(lnickName);

                            
                            UCIDToUN.Remove(lostConnection.UCID);
                            if (debugmode) 
                                    Console.WriteLine(string.Format("Username:{0} Nickname:{1} ConnectionNumber:{2}", luserName, lnickName, lostConnection.UCID));
                            break;

                        case "NPL":
                            if(debugmode)Console.WriteLine("New PLayer joining race (if number already exists, then leaving pits)");
                            InSim.Decoder.NPL newPlayer = new InSim.Decoder.NPL(recvPacket);
                            PLIDToUCID[newPlayer.PLID] =  newPlayer.UCID;
                            (UCIDToUN[newPlayer.UCID] as UN).nickName = newPlayer.nickName;
                            if (!playerTmpStatTable.ContainsKey(newPlayer.nickName))
                                playerTmpStatTable[newPlayer.nickName] = new tempStat();
                            (playerTmpStatTable[newPlayer.nickName] as tempStat).PLID = newPlayer.PLID;
                            (playerTmpStatTable[newPlayer.nickName] as tempStat).UCID = newPlayer.UCID;
                            (playerTmpStatTable[newPlayer.nickName] as tempStat).userName = UserNameByUCID(newPlayer.UCID);
                            (playerTmpStatTable[newPlayer.nickName] as tempStat).CName = newPlayer.CName;
                            lfsPlayers.UpdateUniqueID(UserNameByUCID(newPlayer.UCID), newPlayer.nickName, newPlayer.PLID);
                            string addInfo = "";

                            for (int i = 1; i < 13; i++)
                            {
                                if (((uint)(newPlayer.flags) & (uint)(2 << i)) != 0)
                                    addInfo += ((InSim.Decoder.NPL.PlayerFlags)(2 << i)).ToString() + " ";
                            }
                            if (addInfo.Length != 0 && ShowPlayerControl)
                                SendMsg("/msg " + addInfo);
                            break;

                        case "PLP":
                            if(debugmode)Console.WriteLine("PLayer Pits (go to settings - stays in player list)");

                            InSim.Decoder.PLP plp = new InSim.Decoder.PLP(recvPacket);
                            lnickName = NickNameByPLID(plp.PLID);
                            luserName = UserNameByPLID(plp.PLID);

                            if (EnterPitAction.IndexOf("/rcm_") != -1)
                                RestartTimer();
                            string _EnterPitAction = EnterPitAction;
                            _EnterPitAction = _EnterPitAction.Replace("{Nickname}", lnickName );
                            _EnterPitAction = _EnterPitAction.Replace("{Username}", luserName);
                            string[] enterpitcommands = _EnterPitAction.Split('|');
                            foreach (string enterpitcommand in enterpitcommands)
                                SendMsg(GlobalOptionsReplace(enterpitcommand));

                            break;

                        case "PLL":
                            if(debugmode)Console.WriteLine("PLayer Leave race (spectate - leaves player list, all are shunted down)");

                            InSim.Decoder.PLL pll = new InSim.Decoder.PLL(recvPacket);
                            lnickName = NickNameByPLID(pll.PLID);
                            luserName = UserNameByPLID(pll.PLID);

                            if (LeaveRaceAction.IndexOf("/rcm_") != -1)
                                RestartTimer();
                            string _LeaveRaceAction = LeaveRaceAction;
                            _LeaveRaceAction = _LeaveRaceAction.Replace("{Nickname}", lnickName);
                            _LeaveRaceAction = _LeaveRaceAction.Replace("{Username}", luserName);
                            string[] leaveracecommands = _LeaveRaceAction.Split('|');
                            foreach (string leaveracecommand in leaveracecommands)
                                SendMsg(GlobalOptionsReplace(leaveracecommand));

                            PLIDToUCID.Remove(pll.PLID);
                            break;

                        case "CPR":
                            InSim.Decoder.CPR cpr = new InSim.Decoder.CPR(recvPacket);
                            luserName = UserNameByUCID(cpr.UCID);
                            string oldnickName = UserNameByUCID( cpr.UCID );
                            lfsPlayers.Rename( luserName , oldnickName , cpr.newNickName);
// Sometime LFS send a CPR with same oldNickname and newNickname, maybe a new uniqueID
// if you do .Remove of Var the programm crash because the ref of var are same and the program crash;
                            if (oldnickName != cpr.newNickName)
                            {
                                if( playerTmpStatTable.ContainsKey(oldnickName)){
                                    playerTmpStatTable[cpr.newNickName] = playerTmpStatTable[oldnickName];
                                    playerTmpStatTable.Remove(oldnickName);
                                }
                            }                                     
                            if (debugmode) Console.WriteLine(string.Format("Conn Player {0} Rename from {1} to {2}, id:{3}",
                                                        luserName,
                                                        oldnickName,
                                                        cpr.newNickName,
                                                        cpr.UCID)
                             );
                            (UCIDToUN[cpr.UCID] as UN).nickName = cpr.newNickName;
                            break;

                        case "CLR":
                            InRace = false;
                            if(debugmode)Console.WriteLine("CLear Race - all players removed from race in one go");
                            break;

                        case "LAP":
                            if(debugmode)Console.WriteLine("LAP time");
                            InSim.Decoder.LAP lapDec = new InSim.Decoder.LAP(recvPacket);
                            lnickName = NickNameByPLID(lapDec.PLID);
                            luserName = UserNameByPLID(lapDec.PLID);
                            if (lapDec.LTime == timeConv.HMSToLong(60, 0, 0))
                                break;
                            // drift scores
                            int idx = lfsPlayers.GetByUniqueID(lapDec.PLID);
                            if (idx != -1)
                            {
                                
                                long t;
                                long diff;
                                long best;
                                if (playerTmpStatTable.ContainsKey(lnickName))
                                {
                                    t = lapDec.LTime - (playerTmpStatTable[lnickName] as tempStat).splitLast;
                                    diff = t - (playerTmpStatTable[lnickName] as tempStat).bestSplitLast;
                                    string CurSplit = timeConv.LongToHMS( t );
                                    string DiffSplit = timeConv.LongToHMS( diff );
                                    string BestSplit = timeConv.LongToHMS((playerTmpStatTable[lnickName] as tempStat).bestSplit1Diff);
                                    string BestSpeed = string.Format("{0:n}", (playerTmpStatTable[lnickName] as tempStat).bestSpeed);
                                    string Tpb = "";
                                    string spbAction;
                                    if (t < (playerTmpStatTable[lnickName] as tempStat).bestSplitLast || (playerTmpStatTable[lnickName] as tempStat).bestSplitLast == 0)
                                    {
                                        (playerTmpStatTable[lnickName] as tempStat).bestSplitLast = t;
                                        spbAction = PrivMessSpbLastLow;
                                    }
                                    else
                                    {
                                        spbAction = PrivMessSpbLastUp;
                                    }
                                    best = ((playerTmpStatTable[lnickName] as tempStat).bestSplit1Diff)
                                                + (playerTmpStatTable[lnickName] as tempStat).bestSplit2Diff
                                                + (playerTmpStatTable[lnickName] as tempStat).bestSplit3Diff
                                                + (playerTmpStatTable[lnickName] as tempStat).bestSplitLast
                                                ;
                                    Tpb = timeConv.LongToHMS( best );
                                    if (ShowSplitPB && spbAction != "")
                                    {
                                        spbAction = spbAction.Replace("{Nickname}", lnickName);
                                        spbAction = spbAction.Replace("{Username}", (playerTmpStatTable[lnickName] as tempStat).userName);
                                        spbAction = spbAction.Replace("{CurSplit}", CurSplit);
                                        spbAction = spbAction.Replace("{BestSplit}", BestSplit);
                                        spbAction = spbAction.Replace("{DiffSplit}", DiffSplit);
                                        spbAction = spbAction.Replace("{BestSpeed}", BestSpeed);
                                        spbAction = spbAction.Replace("{AvgSpeed}", trackInfo.getAvgSpeed( currentTrackName, lapDec.LTime ));
                                        spbAction = spbAction.Replace("{Tpb}", Tpb);
                                        posQualUser retValue;
                                        retValue = getPosQual((playerTmpStatTable[lnickName] as tempStat).userName, lnickName, true);
                                        if (retValue.posUser != 0) 
                                            spbAction = spbAction.Replace("{Posqual}", retValue.posUser + "/" + retValue.totalUser);
                                        else
                                            spbAction = spbAction.Replace("{Posqual}", "-/-");
                                        if (retValue.groupUser != -1)
                                            spbAction = spbAction.Replace("{Groupqual}", ((char)(retValue.groupUser + 65)).ToString());
                                        else
                                            spbAction = spbAction.Replace("{Groupqual}", "-");
                                        retValue = getPosQual((playerTmpStatTable[lnickName] as tempStat).userName, lnickName, false);
                                        spbAction = spbAction.Replace("{Posabs}", retValue.posUser + "/" + retValue.totalUser);


                                        SendMsgToConnection( (int)PLIDToUCID[lapDec.PLID], spbAction);
                                    }
                                    (playerTmpStatTable[lnickName] as tempStat).bestSpeed = (double)0;
                                }
                                else
                                    Console.Write("Contient pas");
                                Player p = (Player)lfsPlayers.plys[idx];
                                if (p.totaldriftscore >= MinimumDriftScore)
                                {
                                    if (lfsDriftDb.InsertLapTime(luserName, 
                                                    lnickName, 
                                                    System.DateTime.Now.ToShortDateString(),
                                                    System.DateTime.Now.ToShortTimeString(),
                                                    (playerTmpStatTable[lnickName] as tempStat).CName, 
                                                    (int)p.totaldriftscore, currentTrackName))
                                    {
                                        try
                                        {
                                            if (DriftPBAction.IndexOf("/rcm_") != -1)
                                                RestartTimer();

                                            string Action = DriftPBAction;
                                            Action = Action.Replace("{Nickname}", lnickName);
                                            Action = Action.Replace("{DriftScore}", ((int)p.totaldriftscore).ToString());
                                            Action = Action.Replace("{Car}", (playerTmpStatTable[lnickName] as tempStat).CName);
                                            Action = Action.Replace("{Username}", luserName);
                                            string[] respcommands = Action.Split('|');
                                            foreach (string respcommand in respcommands)
                                                SendMsg(this.GlobalOptionsReplace(respcommand));
                                        }
                                        catch (Exception ex)
                                        {
                                            Console.WriteLine(ex.ToString());
                                        }
                                        lfsDriftDb.Save(); //always save to file on new pb
                                    }
                                    else
                                    {
                                        try
                                        {

                                            if (DriftLapAction.IndexOf("/rcm_") != -1)
                                                RestartTimer();

                                            string Action = DriftLapAction;
                                            Action = Action.Replace("{Nickname}", lnickName);
                                            Action = Action.Replace("{DriftScore}", ((int)p.totaldriftscore).ToString());
                                            Action = Action.Replace("{Car}", (playerTmpStatTable[lnickName] as tempStat).CName);
                                            Action = Action.Replace("{Username}", luserName);
                                            string[] respcommands = Action.Split('|');
                                            foreach (string respcommand in respcommands)
                                                SendMsg(this.GlobalOptionsReplace(respcommand));
                                        }
                                        catch (Exception ex)
                                        {
                                            Console.WriteLine(ex.ToString());
                                        }
                                    }
                                }
                                else
                                {
                                    try
                                    {
                                        if (DriftTooLowAction.IndexOf("/rcm_") != -1)
                                            RestartTimer();

                                        string Action = DriftTooLowAction;
                                        Action = Action.Replace("{Nickname}", lnickName);
                                        Action = Action.Replace("{DriftScore}", ((int)p.totaldriftscore).ToString());
                                        Action = Action.Replace("{Car}", (playerTmpStatTable[lnickName] as tempStat).CName);
                                        Action = Action.Replace("{Username}", luserName);
                                        string[] respcommands = Action.Split('|');
                                        foreach (string respcommand in respcommands)
                                            SendMsg(this.GlobalOptionsReplace(respcommand));
                                    }
                                    catch(Exception ex)
                                    {
                                            Console.WriteLine(ex.ToString());
                                    }
                                }
                                p.totaldriftscore = 0;//reset score to 0

                                //SendMsgToPlayer((byte)p.UniqueID, string.Format("Max lap speed:{0} km/h",p.maxLapSpeed.ToString("F0")));
                                p.maxLapSpeed = 0;//reset maxlapspeed to 0
                            }

                            if(debugmode)
                                    Console.WriteLine(string.Format(
                                        "UserName:{0} NickName:{1} CarName:{2} PlayerID:{3} Time:{4}",
                                        luserName,
                                        lnickName,
                                        (playerTmpStatTable[lnickName] as tempStat).CName,
                                        lapDec.PLID.ToString(),
                                        timeConv.LongToHMS( lapDec.LTime )
                            ));

                            if(lapDec.LTime > trackInfo.getMaxLapTime( currentTrackName,(playerTmpStatTable[lnickName] as tempStat).CName))
                                break;

                            if (!playerTmpStatTable.ContainsKey(lnickName))
                            {
                                playerTmpStatTable[lnickName] = new tempStat();
                                (playerTmpStatTable[lnickName] as tempStat).PLID = lapDec.PLID;
                                (playerTmpStatTable[lnickName] as tempStat).UCID = (int)PLIDToUCID[lapDec.PLID];
                                (playerTmpStatTable[lnickName] as tempStat).userName = luserName;
                            }
                            if (lfsDb.InsertLapTime(luserName, 
                                                    lnickName, 
                                                    System.DateTime.Now.ToShortDateString(), 
                                                    System.DateTime.Now.ToShortTimeString(), 
                                                    (playerTmpStatTable[lnickName] as tempStat).CName,
                                                    lapDec.LTime,
                                                    currentTrackName,
                                                    (playerTmpStatTable[lnickName] as tempStat).split1,
                                                    (playerTmpStatTable[lnickName] as tempStat).split2, 
                                                    (playerTmpStatTable[lnickName] as tempStat).split3)
                            )
                                {
                                try
                                {
                                    string CurAction;
                                    if (playerFilter.ContainsKey(luserName.ToLower()))
                                        CurAction = PBQualAction;
                                    else
                                        CurAction = PBAction;

                                    if (CurAction.IndexOf("/rcm_")!=-1)
                                        RestartTimer();

                                    string Action = CurAction;

                                    Action = Action.Replace("{Nickname}", lnickName);
                                    Action = Action.Replace("{LapTime}", timeConv.LongToHMS( lapDec.LTime ));
                                    Action = Action.Replace("{Car}", (playerTmpStatTable[lnickName] as tempStat).CName);
                                    Action = Action.Replace("{Username}", luserName);
                                    posQualUser retValue;
                                    retValue = getPosQual(luserName, lnickName, true);
                                    if (retValue.posUser != 0)
                                        Action = Action.Replace("{Posqual}", retValue.posUser + "/" + retValue.totalUser);
                                    else
                                        Action = Action.Replace("{Posqual}", "-/-");
                                    if (retValue.groupUser != -1)
                                        Action = Action.Replace("{Groupqual}", ((char)(retValue.groupUser + 65)).ToString());
                                    else
                                        Action = Action.Replace("{Groupqual}", "-");
                                    retValue = getPosQual(luserName, lnickName, false);
                                    Action = Action.Replace("{Posabs}", retValue.posUser + "/" + retValue.totalUser);
                                    string[] respcommands = Action.Split('|');
                                    foreach (string respcommand in respcommands)
                                        SendMsg(this.GlobalOptionsReplace(respcommand));
                                }
                                catch(Exception ex)
                                {
                                    Console.WriteLine(ex.ToString());
                                }
                                lfsDb.Save(); //always save to file on new pb
                            }
                            break;

                        case "SP1":
                        case "SP2":
                        case "SP3":
                        case "SPX":
                            InSim.Decoder.SPX splitdec = new InSim.Decoder.SPX(recvPacket);

                            lnickName = NickNameByPLID(splitdec.PLID);
                            luserName = UserNameByPLID(splitdec.PLID);
                            if (debugmode) Console.WriteLine("SPlit" + splitdec.Split + " " + lnickName + " time :" + timeConv.LongToHMS( splitdec.STime));
                            if ( splitdec.STime == timeConv.HMSToLong(60,0,0))
                                break;
                            if( playerTmpStatTable.ContainsKey( lnickName )){
                                if (splitdec.Split == 1)
                                {
                                    (playerTmpStatTable[lnickName] as tempStat).split1 = splitdec.STime;
                                }
                                else if (splitdec.Split == 2)
                                {
                                    (playerTmpStatTable[lnickName] as tempStat).split2 = splitdec.STime;
                                }
                                else if (splitdec.Split == 3)
                                {
                                    (playerTmpStatTable[lnickName] as tempStat).split3 = splitdec.STime;
                                }
                                SplitNotify(splitdec);
                                (playerTmpStatTable[lnickName] as tempStat).splitLast = splitdec.STime;
                            }

                            break;

                        case "RES":
                            InRace = false;
                            if (debugmode) Console.WriteLine("RESult (qualify or finish)");
                            break;
                        case "FIN": // New Insim Packet
                            if (debugmode) Console.WriteLine("FINISH (qualify or finish)");
                            break;
                        case "REO":
                            if(debugmode)Console.WriteLine("REOrder (when race restarts after qualifying)");
                            break;

                        case "STA":
                            if (debugmode) Console.WriteLine("STAte");
                            InSim.Decoder.STA state = new InSim.Decoder.STA(recvPacket);
                            currentTrackName = state.ShortTrackName;
                            if (debugmode) Console.WriteLine("Current track:" + currentTrackName
                                                     + " Conn:" + state.NumConns
                                        + " Player:" + state.NumP
                                        + " Flags:" + ( state.Flags & 512 )
                            );
                            if (flagFirst == true && (state.Flags & 512) == 512 )
                            {
                                flagFirst = false;
                                // Get All Connections
                                byte[] ncn = InSim.Encoder.NCN();
                                insimConnection.Send(ncn, ncn.Length);
                                // Get All Players
                                byte[] npl = InSim.Encoder.NPL();
                                insimConnection.Send(npl, npl.Length);
                            }

                            break;
/*
                        case "MSS":
                            InSim.Decoder.MSS mss = new InSim.Decoder.MSS(recvPacket);
                            if (debugmode) Console.WriteLine("MSS Message received Username:{0} Player name:{1} Message:{2}",mss.UserName,mss.PlayerName,mss.Message);
*/
                        case "MSO":
                            InSim.Decoder.MSO msg = new InSim.Decoder.MSO(recvPacket);
                            if(debugmode)Console.WriteLine("MSO Message received:" + msg.UserType + "," + msg.message );

                            luserName = UserNameByUCID(msg.UCID);
                            lnickName = NickNameByUCID(msg.UCID);
                            string nicknamewithoutcolors = lnickName;


                            // TODO:Detect following messages and execute actions

                            //Monkster^L : DRIVE-THROUGH PENALTY
                            //Monkster^L : STOP-GO PENALTY
                            //Monkster^L : completed drive-through penalty
                            //Monkster^L : completed stop-go penalty
                            //Monkster^L made a pit stop
                            if (msg.UserType == 0)
                            {
                                int idx1 = msg.message.IndexOf("^L : STOP-GO PENALTY");
                                if (idx1 != -1)
                                    ActionOnStopGoPenalty(msg.message.Substring(0, idx1));

                                idx1 = msg.message.IndexOf("^L : DRIVE-THROUGH PENALTY");
                                if (idx1 != -1)
                                    ActionOnDriveThroughPenalty(msg.message.Substring(0, idx1));
                                idx1 = msg.message.IndexOf("^L : 30 SECOND TIME PENALTY");
                                if (idx1 != -1)
                                    ActionOn30SecondTimePenalty(msg.message.Substring(0, idx1));
                                idx1 = msg.message.IndexOf("^L : 45 SECOND TIME PENALTY");
                                if (idx1 != -1)
                                    ActionOn45SecondTimePenalty(msg.message.Substring(0, idx1));
                            }
                            if (msg.UserType == 1)
                            {
                                CheckForFlooding(luserName, lnickName);
                                if (msg.message.StartsWith("!cleanspb") || msg.message.StartsWith("!razspb"))
                                {
                                    (playerTmpStatTable[nicknamewithoutcolors] as tempStat).splitLast = 0;
                                    (playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplit1Diff = 0;
                                    (playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplit2Diff = 0;
                                    (playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplit3Diff = 0;
                                    (playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplitLast = 0;
                                    (playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSpeed = (double)0;

                                    try
                                    {
                                        SendMsgToConnection(msg.UCID, nicknamewithoutcolors + " SPB Cleaned");
                                    }
                                    catch { }
                                }
                                if (msg.message.StartsWith("!spb"))
                                {
                                    string spb = "";
                                    long best;
                                    try
                                    {
                                        if ((playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplit1Diff != 0)
                                            spb = spb + "^7SP1:^8" + timeConv.LongToHMS((playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplit1Diff);
                                        if ((playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplit2Diff != 0)
                                            spb = spb + "^7SP2:^8" + timeConv.LongToHMS((playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplit2Diff);
                                        if ((playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplit3Diff != 0)
                                            spb = spb + "^7SP3:^8" + timeConv.LongToHMS((playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplit3Diff);
                                        if ((playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplitLast != 0)
                                            spb = spb + "^7SPL:^8" + timeConv.LongToHMS((playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplitLast);
                                        best = ((playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplit1Diff)
                                                    + (playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplit2Diff
                                                    + (playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplit3Diff
                                                    + (playerTmpStatTable[nicknamewithoutcolors] as tempStat).bestSplitLast
                                                    ;
                                        SendMsgToConnection(msg.UCID, spb);
                                        if (best != 0)
                                        {
                                            spb = "^7TPB:^8" + timeConv.LongToHMS(best);
                                            SendMsgToConnection(msg.UCID, spb);
                                        }


                                    }
                                    catch (Exception) { }

                                }
                                if (msg.message.StartsWith("!ver"))
                                {
                                    Ver(msg.UCID);
                                }
                                else if (msg.message.StartsWith("!drf"))
                                    TopDrift(msg.UCID,luserName, nicknamewithoutcolors, msg.message);
                                else if (msg.message.StartsWith("!topqual"))
                                {
                                    if (RefreshQualUsers)
                                        UpdateQualUsers(QualUsers);
                                    Top(msg.UCID,luserName, nicknamewithoutcolors, msg.message, true);
                                }
                                else if (msg.message.StartsWith("!top"))
                                    Top(msg.UCID,luserName, nicknamewithoutcolors, msg.message, false);
                                else if (msg.message.StartsWith("!nearqual"))
                                {
                                    string mymess;
                                    // Update the FilterTop for qualified

                                    if (RefreshQualUsers)
                                        UpdateQualUsers(QualUsers);
                                    posQualUser retValue = getPosQual(luserName, nicknamewithoutcolors, true);
                                    int iposabs = retValue.posUser;
                                    if (iposabs == 0)
                                        iposabs = 1;
                                    if (iposabs > 8)
                                        iposabs -= 7;
                                    else
                                        iposabs = 1;
                                    mymess = "!topqual " + iposabs.ToString();
                                    Top(msg.UCID,luserName, nicknamewithoutcolors, mymess, true);
                                }
                                else if (msg.message.StartsWith("!near"))
                                {
                                    string mymess;
                                    posQualUser retValue = getPosQual(luserName, nicknamewithoutcolors, false);
                                    int iposabs = retValue.posUser;

                                    if (iposabs == 0)
                                    {
                                        iposabs = 1;
                                    }
                                    if (iposabs > 8)
                                        iposabs -= 7;
                                    else
                                        iposabs = 1;
                                    mymess = "!top " + iposabs.ToString();
                                    Top(msg.UCID,luserName, nicknamewithoutcolors, mymess, false);
                                }
                                else if (msg.message.StartsWith("!statsqual"))
                                    ShowStats(msg.UCID, luserName, nicknamewithoutcolors, msg.message, true);
                                else if (msg.message.StartsWith("!stats"))
                                    ShowStats(msg.UCID,luserName, nicknamewithoutcolors, msg.message, false);
                                else if (msg.message.StartsWith("!dstats"))
                                    ShowDriftStats(msg.UCID,luserName, nicknamewithoutcolors, msg.message);
                                else
                                {
                                    try
                                    {
                                        for (int i = 0; i < autoActionLines.Length; i += 2)
                                        {
                                            string reqline = this.autoActionLines[i];

                                            bool allowAction = true;
                                            int authidx = reqline.IndexOf("@");
                                            if (authidx != -1)
                                            {
                                                allowAction = false;
                                                string[] authUsers = reqline.Substring(authidx + 1).Split(',');
                                                reqline = reqline.Substring(0, authidx);

                                                foreach (string authuser in authUsers)
                                                {

                                                    if (UseUsernameForAuthentication)
                                                    {
                                                        if (luserName.Trim() == authuser.Trim())//   <- for licensed players
                                                        {
                                                            allowAction = true;
                                                            break;
                                                        }
                                                    }
                                                    else
                                                    {
                                                        if (lnickName.Trim() == authuser.Trim())//   <- for demo players
                                                        {
                                                            allowAction = true;
                                                            break;
                                                        }
                                                    }
                                                }
                                            }
                                            // For user in File
                                            authidx = reqline.IndexOf("&");
                                            if (authidx != -1)
                                            {
                                                allowAction = false;
                                                string authUsersFile = reqline.Substring(authidx + 1);
                                                reqline = reqline.Substring(0, authidx);
                                                if (authUsersFile != "")
                                                {
                                                    try
                                                    {
                                                        using (System.IO.StreamReader sr = new System.IO.StreamReader(authUsersFile))
                                                        {
                                                            string lusername;
                                                            while (true)
                                                            {
                                                                lusername = sr.ReadLine();

                                                                if (lusername == null)
                                                                    break;
                                                                if (UseUsernameForAuthentication)
                                                                {
                                                                    if (luserName.Trim().ToLower() == lusername.Trim().ToLower())//   <- for licensed players
                                                                    {
                                                                        allowAction = true;
                                                                        break;
                                                                    }
                                                                }
                                                                else
                                                                {
                                                                    if (lnickName.Trim() == lusername.Trim())//   <- for demo players
                                                                    {
                                                                        allowAction = true;
                                                                        break;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    catch
                                                    {
                                                        allowAction = false;
                                                    }
                                                }
                                            }

                                            string[] words = reqline.Split(':');
                                            string respline = this.autoActionLines[i + 1];
                                            if (allowAction)
                                                foreach (string w in words)
                                                {
                                                    if (msg.message.ToUpper().IndexOf(w.ToUpper()) != -1)
                                                    {
                                                        respline = respline.Replace("{Nickname}", lnickName);
                                                        respline = respline.Replace("{Username}", luserName);

                                                        if (respline.IndexOf("/rcm_") != -1)
                                                            RestartTimer();

                                                        string[] respcommands = respline.Split(':');
                                                        foreach (string respcommand in respcommands)
                                                            SendMsg(this.GlobalOptionsReplace(respcommand));
                                                    }
                                                }
                                        }

                                        for (int i = 0; i < autoMsgLinesPrivate.Length; i += 2)
                                        {
                                            string reqline = this.autoMsgLinesPrivate[i];
                                            string[] words = reqline.Split(':');
                                            string respline = this.autoMsgLinesPrivate[i + 1];

                                            foreach (string w in words)
                                            {
                                                int off = msg.message.ToUpper().IndexOf(w.ToUpper());
                                                if (off != -1)
                                                    SendMultilineMsgPrivate(msg.UCID,nicknamewithoutcolors, msg.message, respline, off);
                                            }
                                        }

                                    }
                                    catch (System.Exception)
                                    {
                                    }
                                }
                            }
                            break;
                        case "MCI":

                            InSim.Decoder.MCI mci = new InSim.Decoder.MCI(recvPacket);
                            for (int i = 0; i < System.Math.Min(8,mci.numOfPlayers); i++)
                            {
                                double xm = mci.compCar[i].x / 65536d;
                                double ym = mci.compCar[i].y / 65536d;
                                double zm = mci.compCar[i].z / 65536d;

                                double spm = mci.compCar[i].speed / 327.68 * 3.6; // kmh
                                double dirm = mci.compCar[i].direction * 180 / 32768d;
                                double headm = mci.compCar[i].heading * 180 / 32768d;
                                double angm = mci.compCar[i].angvel * 180 / 8192d;
                                lfsPlayers.UpdateState(mci.compCar[i].PLID, xm, ym, zm, spm, dirm, headm, angm, MinimumDriftSpeed, MinimumDriftAngle, MaximumDriftAngle, MinAngleVelocity, AccelerationStartSpeed, AccelerationEndSpeed);
                            }

                            foreach(Player p in lfsPlayers.plys)
                            {
                                if (playerTmpStatTable.ContainsKey(p.NickName))
                                {
                                    if (p.speed > (playerTmpStatTable[p.NickName] as tempStat).bestSpeed)
                                        (playerTmpStatTable[p.NickName] as tempStat).bestSpeed = p.speed;
                                }
                                // check for instunt time player


                                if (p.stuntticks == MaxNbInStunt)
                                {
                                    if (MaxNbInStuntAction.IndexOf("/rcm_") != -1)
                                        RestartTimer();

                                    string MaxStuntAction = MaxNbInStuntAction;
                                    MaxStuntAction = MaxStuntAction.Replace("{Nickname}", p.NickName);
                                    MaxStuntAction = MaxStuntAction.Replace("{AngleVelocity}", p.AngVel.ToString("F0"));
                                    MaxStuntAction = MaxStuntAction.Replace("{Username}", p.UserName);
                                    string[] respcommands = MaxStuntAction.Split('|');
                                    foreach (string respcommand in respcommands)
                                        SendMsg(this.GlobalOptionsReplace(respcommand));
                                }
                                else if (p.stuntticks == 1)
                                {
                                    if (AngleVelocityAction.IndexOf("/rcm_") != -1)
                                        RestartTimer();

                                    string StuntAction = AngleVelocityAction;

                                    StuntAction = StuntAction.Replace("{Nickname}", p.NickName);
                                    StuntAction = StuntAction.Replace("{AngleVelocity}", p.AngVel.ToString("F0"));
                                    StuntAction = StuntAction.Replace("{Username}", p.UserName);

                                    string[] respcommands = StuntAction.Split('|');
                                    foreach (string respcommand in respcommands)
                                        SendMsg(this.GlobalOptionsReplace(respcommand));
                                }

                                // check for idle time
                                if (InRace == false) // if not in race, Force IdleTick for each player to 0
                                    p.idleticks = 0;
                                if (p.idleticks > OnIdleTimeout2)
                                {
                                    if (OnIdleAction1.IndexOf("/rcm_") != -1)
                                        RestartTimer();

                                    string _IdleAction = OnIdleAction2;
                                    _IdleAction = _IdleAction.Replace("{Nickname}", p.NickName);
                                    _IdleAction = _IdleAction.Replace("{Username}", p.UserName);

                                    string[] respcommands2 = _IdleAction.Split('|');
                                    foreach (string respcommand in respcommands2)
                                        SendMsg(this.GlobalOptionsReplace(respcommand));

                                    p.idleticks = 0; //reset to zero afterwards, don't want flooding
                                    p.OnIdleAction1Sended = false;
                                }
                                if ((p.idleticks > OnIdleTimeout1) && (p.OnIdleAction1Sended == false ))
                                {
                                    if (OnIdleAction1.IndexOf("/rcm_") != -1)
                                        RestartTimer();

                                    string _IdleAction = OnIdleAction1;
                                    _IdleAction = _IdleAction.Replace("{Nickname}", p.NickName);
                                    _IdleAction = _IdleAction.Replace("{Username}", p.UserName);

                                    string[] respcommands2 = _IdleAction.Split('|');
                                    foreach (string respcommand in respcommands2)
                                        SendMsg(this.GlobalOptionsReplace(respcommand));
                                    p.OnIdleAction1Sended = true;
//                                    p.idleticks = 0; //reset to zero afterwards, don't want flooding
                                }
                                
                                // write current drift score
                                if (p.driftticks==0 && p.lastdriftscore > 0 && p.totaldriftscore > 0)
                                {
                                    string _PrivateMsg = this.PrivateMessageOnDriftScore;
                                    _PrivateMsg = _PrivateMsg.Replace("{Nickname}",p.NickName);
                                    _PrivateMsg = _PrivateMsg.Replace("{Username}", p.UserName);
                                    _PrivateMsg = _PrivateMsg.Replace("{LastDriftScore}", ((int)p.lastdriftscore).ToString());
                                    _PrivateMsg = _PrivateMsg.Replace("{DriftScore}", ((int)p.totaldriftscore).ToString());


                                    SendMsgToConnection((int)PLIDToUCID[p.UniqueID], this.GlobalOptionsReplace(_PrivateMsg));

                                    if (p.lastdriftscore >= GoodDriftScore)
                                    {
                                        string _GoodDriftAction = GoodDriftAction;
                                        _GoodDriftAction = _GoodDriftAction.Replace("{Nickname}", p.NickName);
                                        _GoodDriftAction = _GoodDriftAction.Replace("{Username}", p.UserName);
                                        _GoodDriftAction = _GoodDriftAction.Replace("{LastDriftScore}", ((int)p.lastdriftscore).ToString());

                                        SendMsg(this.GlobalOptionsReplace(_GoodDriftAction));
                                    }

                                    p.lastdriftscore = 0;
                                }

                                if (p.accelerationTimeValid && p.accelerationTime.TotalSeconds <= AccelerationPrivateMaxTime)
                                {
                                    p.accelerationTimeValid = false;
                                    string _PrivateAccMsg = AccelerationPrivateMessage;
                                    _PrivateAccMsg = _PrivateAccMsg.Replace("{AccelerationStartSpeed}", AccelerationStartSpeed.ToString("F0"));
                                    _PrivateAccMsg = _PrivateAccMsg.Replace("{AccelerationEndSpeed}", AccelerationEndSpeed.ToString("F0"));
                                    _PrivateAccMsg = _PrivateAccMsg.Replace("{AccelerationTime}", p.accelerationTime.TotalSeconds.ToString("F1"));

                                    SendMsgToConnection((int)PLIDToUCID[p.UniqueID], this.GlobalOptionsReplace(_PrivateAccMsg));
                                }
                            }

                            break;
                        case "ISM":
                            if (debugmode) Console.WriteLine("ISM multiplayer notification packet");
// Get All Connections
                                byte[] ismncn = InSim.Encoder.NCN();
                                insimConnection.Send(ismncn, ismncn.Length);
// Get All Players
                                byte[] ismnpl = InSim.Encoder.NPL();
                                insimConnection.Send(ismnpl, ismnpl.Length);
                                break;

                        case "NLP":
                            break;
                        case "VTC":
                            break;
                        case "VTN": // Insim Vote
                            break;
                        case "VTA": // Insim Vote Action
                            break;
                        case "III": // NEW III : InSimInfo
                            break;
                        case "PLA": // NEW PLA : (Pit LAne)
                            break;
                        case "PIT": // NEW PIT : (pit stop)
                            break;
                        case "PSF": // NEW PSF : (pit stop finished)
                            break;
                        case "PEN": // NEW PEN : (penalty)
                            break;
                        case "TOC": // NEW TOC : (take over car)
                            break;
                        case "FLG": // NEW FLG : (yellow or blue flags)
                            break;
                        case "PFL": // NEW PFL : (player help flags)
                            break;
                        case "CCH": // NEW CCH : (camera changed)
                            break;
                        default:
                            if (debugmode) Console.WriteLine("Unknown packet received:" + packetHead);
//                            Console.WriteLine("Unknown packet received:" + packetHead);
                            break;
                    }

                }
            }

        }

        private void ActionOnDriveThroughPenalty(string nickname)
        {
            try
            {
                int idx = lfsPlayers.GetByColorlessNickname(nickname);

                if (idx != -1)
                {
                    Player p = (Player)lfsPlayers.plys[idx];
                    p.drivethroughcount++;

                    if (p.drivethroughcount > MaxDriveThroughPenalties)   //max attempts to tolerate
                    {

                        p.drivethroughcount = 0;

                        if (DriveThroughPenaltyAction.IndexOf("/rcm_") != -1)
                            RestartTimer();

                        string _Action = DriveThroughPenaltyAction;
                        _Action = _Action.Replace("{Nickname}", p.NickName);
                        _Action = _Action.Replace("{Username}", p.UserName);
                        string[] commands = _Action.Split('|');
                        foreach (string command in commands)
                            SendMsg(GlobalOptionsReplace(command));
                    }
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }

        private void ActionOnStopGoPenalty(string nickname)
        {
            try
            {
                int idx = lfsPlayers.GetByColorlessNickname(nickname);

                if (idx != -1)
                {
                    Player p = (Player)lfsPlayers.plys[idx];
                    p.stopgocount++;

                    if (p.stopgocount > MaxStopGoPenalties)   //max attempts to tolerate
                    {

                        p.stopgocount = 0;

                        if (StopGoPenaltyAction.IndexOf("/rcm_") != -1)
                            RestartTimer();

                        string _Action = StopGoPenaltyAction;
                        _Action = _Action.Replace("{Nickname}", p.NickName);
                        _Action = _Action.Replace("{Username}", p.UserName);
                        string[] commands = _Action.Split('|');
                        foreach (string command in commands)
                            SendMsg(GlobalOptionsReplace(command));
                    }
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }

        private void ActionOn30SecondTimePenalty(string nickname)
        {
            try
            {
                int idx = lfsPlayers.GetByColorlessNickname(nickname);

                if (idx != -1)
                {
                    Player p = (Player)lfsPlayers.plys[idx];

                    if (Time30PenaltyAction.IndexOf("/rcm_") != -1)
                        RestartTimer();

                    string _Action = Time30PenaltyAction;
                    _Action = _Action.Replace("{Nickname}", p.NickName);
                    _Action = _Action.Replace("{Username}", p.UserName);
                    string[] commands = _Action.Split('|');
                    foreach (string command in commands)
                        SendMsg(GlobalOptionsReplace(command));
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }

        private void ActionOn45SecondTimePenalty(string nickname)
        {
            try
            {
                int idx = lfsPlayers.GetByColorlessNickname(nickname);

                if (idx != -1)
                {
                    Player p = (Player)lfsPlayers.plys[idx];

                    if (Time45PenaltyAction.IndexOf("/rcm_") != -1)
                        RestartTimer();

                    string _Action = Time45PenaltyAction;
                    _Action = _Action.Replace("{Nickname}", p.NickName);
                    _Action = _Action.Replace("{Username}", p.UserName);
                    string[] commands = _Action.Split('|');
                    foreach (string command in commands)
                        SendMsg(GlobalOptionsReplace(command));

                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }

    }
}
