using System;
using WebCamService;
using System.Threading;
using System.Diagnostics;
using System.IO;


namespace LFS
{
    public class DriftPlayerStats
    {
        public int personalBestLap;
        public string nickName;
        public string datePb;
        public string timePb;



        public DriftPlayerStats(string nN, string dPb, string tPb, int pb)
        {
            nickName = nN;
            datePb = dPb;
            timePb = tPb;
            personalBestLap = pb;
        }
    }

    class DriftDb
    {

        System.Collections.Hashtable trackTable = new System.Collections.Hashtable();
        string filepath = null;
        string FtpServer = null;
        string FtpLogin = null;
        string FtpPasswd = null;
        string FtpRemotePath = null;
        ThreadUpload threadHandle;
        private Mutex myMutex;
        string curVersion = "USERNAME 01";


        public DriftDb( Mutex mut )
        {
            Process myProcess = System.Diagnostics.Process.GetCurrentProcess();
//            this.stringMutex = "LFSDriftDb" + myProcess.Id.ToString();
//            this.myMutex = new Mutex(false, stringMutex);
            this.myMutex = mut;
        }
        public bool Load(string filepath, string FtpServer, string FtpLogin, string FtpPasswd, string FtpRemotePath)
        {
            this.filepath = filepath;
            this.FtpServer = FtpServer;
            this.FtpLogin = FtpLogin;
            this.FtpPasswd = FtpPasswd;
            this.FtpRemotePath = FtpRemotePath;

            this.threadHandle = new ThreadUpload(FtpServer, FtpRemotePath, FtpLogin, FtpPasswd, filepath, myMutex);

            try
            {
                while (updPbVersion(filepath) == true) ;
            }
            catch (System.Exception)
            {
                return false;
            }

            try
            {
                using (System.IO.StreamReader sr = new System.IO.StreamReader(filepath))
                {
                    string userName, nickName, datePb, timePb, time, carName, trackName;

                    string pbVersion = sr.ReadLine();
                    if (pbVersion.IndexOf("USERNAME") == -1) // Si pas fichier avec Username, on efface et on recrer
                        return false;

                    while (true)
                    {
                        userName = sr.ReadLine();
                        nickName = sr.ReadLine();
                        datePb = sr.ReadLine();
                        timePb = sr.ReadLine();

                        if (nickName == null)
                            return true;
                        carName = sr.ReadLine();
                        time = sr.ReadLine();
                        trackName = sr.ReadLine();

                        InsertLapTime(userName, nickName,datePb,timePb, carName, int.Parse(time), trackName);
                    }
                }
            }
            catch (System.Exception)
            {
                return false;
            }
        }

        public bool Save()
        {
            bool retValue = false;
            try
            {
                //Exclude Concurrent access to same file when upload to FTP
                if (myMutex.WaitOne(-1, true))
                {
                    using (System.IO.StreamWriter sw = new System.IO.StreamWriter(filepath))
                    {
                        sw.WriteLine(curVersion);
                        System.Collections.IDictionaryEnumerator trackenum = trackTable.GetEnumerator();
                        while (trackenum.MoveNext()) //for each track
                        {
                            System.Collections.IDictionaryEnumerator carenum = (trackenum.Value as System.Collections.Hashtable).GetEnumerator();
                            while (carenum.MoveNext()) //for each car type
                            {
                                System.Collections.IDictionaryEnumerator entryenum = (carenum.Value as System.Collections.Hashtable).GetEnumerator();
                                while (entryenum.MoveNext())	//for each player
                                {
                                    sw.WriteLine(entryenum.Key.ToString());
                                    sw.WriteLine((entryenum.Value as DriftPlayerStats).nickName);
                                    sw.WriteLine((entryenum.Value as DriftPlayerStats).datePb);
                                    sw.WriteLine((entryenum.Value as DriftPlayerStats).timePb);
                                    sw.WriteLine(carenum.Key.ToString());
                                    sw.WriteLine((entryenum.Value as DriftPlayerStats).personalBestLap.ToString());
                                    sw.WriteLine(trackenum.Key.ToString());
                                }
                            }
                        }
                    }
                }
                retValue = true;
            }
            catch (Exception ex)
            {
                Console.WriteLine( "(" + filepath + ")" + ex.Message);   // Print the error message.
                return false;
            }
            finally
            {
                myMutex.ReleaseMutex();
            }
            if (retValue)
            {
                if (FtpServer != "")
                {
                    Thread ftpUpload = new Thread(new ThreadStart(threadHandle.UpLoad));
                    ftpUpload.Start();
                }
            }

            return retValue;
        }

        public bool InsertLapTime(string userName, string nickName, string datePb, string timePb, string carName, int timeLap, string trackName)
        {
            string keyName;

            if (userName == "")
                keyName = nickName.ToLower();
            else
                keyName = userName.ToLower();

            // create new track table if it doesnt exist yet
            if (!trackTable.ContainsKey(trackName))
                trackTable[trackName] = new System.Collections.Hashtable();

            System.Collections.Hashtable carTable = trackTable[trackName] as System.Collections.Hashtable;

            // create new car table if it doesnt exist yet
            if (!carTable.ContainsKey(carName))
                carTable[carName] = new System.Collections.Hashtable();

            System.Collections.Hashtable playerTable = carTable[carName] as System.Collections.Hashtable;

            if (playerTable.ContainsKey(keyName))
            {
                if (timeLap>((playerTable[keyName] as DriftPlayerStats).personalBestLap))
                {
                    playerTable[keyName] = new DriftPlayerStats(nickName, datePb, timePb, timeLap);
                    return true;
                }
                else return false;
            }

            playerTable[keyName] = new DriftPlayerStats(nickName, datePb, timePb, timeLap);
            return true;
        }


        public class DriverLapEntry : System.IComparable
        {
            public string userName;
            public DriftPlayerStats playerStats;

            public DriverLapEntry(string user, DriftPlayerStats ps)
            {
                userName = user;
                playerStats = ps;
            }

            public int CompareTo(object x)
            {
                if ((x as DriverLapEntry).playerStats.personalBestLap<playerStats.personalBestLap)
                    return -1;
                else if ((x as DriverLapEntry).playerStats.personalBestLap>playerStats.personalBestLap)
                    return 1;
                else
                    return 0;
            }

        }

        public System.Collections.ArrayList GetTable(string trackName, string carName, string Filter, bool colorSensitive)
        {
            System.Collections.ArrayList list = new System.Collections.ArrayList();

            if (!trackTable.ContainsKey(trackName))
                return list;

            System.Collections.Hashtable carTable = trackTable[trackName] as System.Collections.Hashtable;

            if (!carTable.ContainsKey(carName))
                return list;

            System.Collections.Hashtable playerTable = carTable[carName] as System.Collections.Hashtable;
            System.Collections.IDictionaryEnumerator entryenum = playerTable.GetEnumerator();

            while (entryenum.MoveNext())
            {
                if (colorSensitive)
                {
                    if (entryenum.Key.ToString().IndexOf(Filter) != -1)
                        list.Add(new DriverLapEntry(entryenum.Key.ToString(), entryenum.Value as DriftPlayerStats));
                }
                else
                {
                    if (entryenum.Key.ToString().Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "").IndexOf(Filter) != -1)
                        list.Add(new DriverLapEntry(entryenum.Key.ToString(), entryenum.Value as DriftPlayerStats));
                }
            }
            list.Sort();
            return list;
        }

        public System.Collections.ArrayList GetTable(string trackName, string carName)
        {
            System.Collections.ArrayList list = new System.Collections.ArrayList();

            if (!trackTable.ContainsKey(trackName))
                return list;

            System.Collections.Hashtable carTable = trackTable[trackName] as System.Collections.Hashtable;

            if (!carTable.ContainsKey(carName))
                return list;

            System.Collections.Hashtable playerTable = carTable[carName] as System.Collections.Hashtable;
            System.Collections.IDictionaryEnumerator entryenum = playerTable.GetEnumerator();

            while (entryenum.MoveNext())
            {
                list.Add(new DriverLapEntry(entryenum.Key.ToString(), entryenum.Value as DriftPlayerStats));
            }

            list.Sort();
            return list;
        }

        /// <summary>
        /// Gets list of car names.
        /// </summary>
        /// <param name="trackName">Name of track.</param>
        /// <returns></returns>
        public System.Collections.ArrayList GetCars(string trackName)
        {
            System.Collections.ArrayList list = new System.Collections.ArrayList();
            System.Collections.IDictionaryEnumerator carTable = (trackTable[trackName] as System.Collections.Hashtable).GetEnumerator();
            while (carTable.MoveNext())
                list.Add(carTable.Key.ToString());

            list.Sort();
            return list;
        }
        private bool updPbVersion(string filePath)
        {
            // If it's not a new version, do nothing
            using (System.IO.StreamReader sr = new System.IO.StreamReader(filepath))
            {
                string pbVersion = sr.ReadLine();
                if (pbVersion.IndexOf("USERNAME") == -1) // Si pas fichier avec Username, on efface et on recrer
                    return false;
                if (pbVersion == curVersion)
                    return false;
            }
            string orig = Path.GetDirectoryName(filepath) + Path.DirectorySeparatorChar + "TMP_" + Path.GetFileName(filepath);
            File.Delete(orig);
            File.Move(filepath, orig);
            using (System.IO.StreamReader sr = new System.IO.StreamReader(orig))
            {
                using (System.IO.StreamWriter sw = new System.IO.StreamWriter(filepath, false))
                {
                    string userName, carName;

                    string pbVersion = sr.ReadLine();
                    switch (pbVersion)
                    {
                        case "USERNAME": // To version 01
                            sw.WriteLine("USERNAME 01");
                            Console.WriteLine("Convert file PB : USERNAME -> USERNAME 01");
                            while (true)
                            {
                                userName = sr.ReadLine();
                                if (userName == null)
                                {
                                    sw.Close();
                                    sr.Close();
                                    File.Delete(orig);
                                    return true;
                                }
                                sw.WriteLine(userName); //username
                                sw.WriteLine(sr.ReadLine()); //nickname
                                sw.WriteLine(sr.ReadLine()); //datePb
                                sw.WriteLine(sr.ReadLine()); //timepB
                                carName = sr.ReadLine();
                                switch (carName)
                                {
                                    case "UF 1000":
                                        carName = "UF1";
                                        break;
                                    case "XF GTI":
                                        carName = "XFG";
                                        break;
                                    case "XR GT":
                                        carName = "XRG";
                                        break;
                                    case "XR GT TURBO":
                                        carName = "XRT";
                                        break;
                                    case "RB4 GT":
                                        carName = "RB4";
                                        break;
                                    case "FXO TURBO":
                                        carName = "FXO";
                                        break;
                                    case "LX4":
                                        carName = "LX4";
                                        break;
                                    case "LX6":
                                        carName = "LX6";
                                        break;
                                    case "RA":
                                        carName = "RAC";
                                        break;
                                    case "FZ50":
                                        carName = "FZ5";
                                        break;
                                    case "MRT5":
                                        carName = "MRT";
                                        break;
                                    case "XF GTR":
                                        carName = "XFR";
                                        break;
                                    case "UF GTR":
                                        carName = "UFR";
                                        break;
                                    case "FORMULA XR":
                                        carName = "FOX";
                                        break;
                                    case "FORMULA V8":
                                        carName = "FO8";
                                        break;
                                    case "FXO GTR":
                                        carName = "FXR";
                                        break;
                                    case "XR GTR":
                                        carName = "XRR";
                                        break;
                                    case "FZ50 GTR":
                                        carName = "FZR";
                                        break;
                                    case "BMW SAUBER":
                                        carName = "BF1";
                                        break;
                                }
                                sw.WriteLine(carName);
                                sw.WriteLine(sr.ReadLine()); //time
                                sw.WriteLine(sr.ReadLine()); //trackName;
                            }
                        default:
                            break;
                    }
                    return false;
                }
            }
        }
    }
}