using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib
{
    public class RawSerialize
    {
        public static byte[] Serialize(object anything)
        {
            int rawsize = Marshal.SizeOf(anything);
            IntPtr buffer = Marshal.AllocHGlobal(rawsize);
            Marshal.StructureToPtr(anything, buffer, false);
            byte[] rawdatas = new byte[rawsize];
            Marshal.Copy(buffer, rawdatas, 0, rawsize);
            Marshal.FreeHGlobal(buffer);
            return rawdatas;
        }

        public static object Deserialize(byte[] rawdatas, Type anytype)
        {
            int rawsize = Marshal.SizeOf(anytype);
            IntPtr buffer = Marshal.AllocHGlobal(rawsize);
            int copyLength = Math.Min(rawsize, rawdatas.Length);
            byte[] fullDataBuf = new byte[rawsize];
            Array.Copy(rawdatas, fullDataBuf, copyLength);
            Marshal.Copy(fullDataBuf, 0, buffer, rawsize);
            object retobj = Marshal.PtrToStructure(buffer, anytype);
            Marshal.FreeHGlobal(buffer);
            return retobj;

            //int rawsize = Marshal.SizeOf(anytype);
            //IntPtr buffer = Marshal.AllocHGlobal(rawsize);
            //int copyLength = Math.Min(rawsize, rawdatas.Length);
            //Marshal.Copy(rawdatas, 0, buffer, copyLength);
            //object retobj = Marshal.PtrToStructure(buffer, anytype);
            //Marshal.FreeHGlobal(buffer);
            //return retobj;
        } 

    }
}
