using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_VER // VERsion
    {
        #region Member

        private byte Size;
        private PacketTypeEnum Type;
        public byte ReqI;			// ReqI as received in the request packet
        private byte Zero;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 8)]
        public string Version;		// LFS version, e.g. 0.3G
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 6)]
        public string Product;		// Product : DEMO or S1
	    public UInt16 InSimVer;		// InSim Version : increased when InSim packets change

        #endregion

        #region Constructor

        public IS_VER()
        {
            Size = 20;
            Type = PacketTypeEnum.ISP_VER;
            Zero = 0;
        }

        #endregion

        #region Static Methods

        public static IS_TINY CreateRequestPacket(byte reqI)
        {
            return new IS_TINY(reqI, IS_TINYTypeEnum.TINY_VER);
        }

        #endregion
    }
}
