using LfsInSimLib.IS_Enums;
using LfsInSimLib.IS_SubPackets;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_STA // STAte
    {
        private byte Size;			// 28
        private PacketTypeEnum Type;			// ISP_STA
        public byte ReqI;			// ReqI if replying to a request packet
        private byte Zero;

        public float ReplaySpeed;	// 4-byte float - 1.0 is normal speed

        public IS_ISSFlagsEnum Flags;			// ISS state flags (see below)
        public ViewEnum InGameCam;		// Which type of camera is selected (see below)
        public byte ViewPLID;		// Unique ID of viewed player (0 = none)

        public byte NumP;			// Number of players in race
        public byte NumConns;		// Number of connections including host
        public byte NumFinished;	// Number finished or qualified
        public RaceInProgEnum RaceInProg;		// 0 - no race / 1 - race / 2 - qualifying

        public byte QualMins;
        public RaceLaps RaceLaps;		// see "RaceLaps" near the top of this document
        private byte Spare2;
        private byte Spare3;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 6)]
        public string Track;		// short name for track e.g. FE2R
        public byte Weather;		// 0,1,2...
        public WindEnum Wind;			// 0=off 1=weak 2=strong

        public IS_STA()
        {
            Size = 28;
            Type = PacketTypeEnum.ISP_STA;
            Zero = 0;
            Spare2 = 0;
            Spare3 = 0;
        }
    }
}
