using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_SMALL // General purpose 8 byte packet
    {
        #region Member

        private byte size;
        private PacketTypeEnum type;
        private byte reqI;		// 0 unless it is an info request or a reply to an info request
        private IS_SMALLTypeEnum subT;		// subtype, from SMALL_ enumeration (e.g. SMALL_SSP)

        private UInt32 uVal;	// value (e.g. for SMALL_SSP this would be the OutSim packet rate)

        #endregion

        #region Properties

        public byte ReqI
        {
            get
            {
                return reqI;
            }
            set
            {
                reqI = value;
            }
        }

        public IS_SMALLTypeEnum SubT
        {
            get
            {
                return subT;
            }
            set
            {
                subT = value;
            }
        }

        public UInt32 UVal
        {
            get
            {
                return uVal;
            }
            set
            {
                uVal = value;
            }
        }

        #endregion

        #region Constructor

        public IS_SMALL()
        {
            size = 8;
            type = PacketTypeEnum.ISP_SMALL;
        }

        #endregion
    }
}
