using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;


namespace LfsInSimLib.IS_Packets
{
    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_SFP
    {
        #region Member

        private byte size;		// 8
        private PacketTypeEnum type;		// ISP_SFP
        private byte reqI;		// 0
        private byte zero;

        private IS_ISSFlagsEnum flag;		// the state to set
        private byte offOn;		// 0 = off / 1 = on
        private byte sp3;		// spare

        #endregion

        #region Properties

        public IS_ISSFlagsEnum Flag
        {
            get
            {
                return flag;
            }
            set
            {
                flag = value;
            }
        }

        public byte OffOn
        {
            get
            {
                return offOn;
            }
            set
            {
                offOn = value;
            }
        }

        #endregion

        #region Constructor

        public IS_SFP()
        {
            size = 8;
            type = PacketTypeEnum.ISP_SFP;
            reqI = 0;
            zero = 0;
            sp3 = 0;
        }

        #endregion
    }
}
