using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_SCH
    {
        #region Member

        private byte size;		// 8
        private PacketTypeEnum type;		// ISP_SCH
        private byte reqI;		// 0
        private byte zero;

        private byte charB;		// key to press
        private byte flags;		// bit 0 : SHIFT / bit 1 : CTRL
        private byte spare2;
        private byte spare3;

        #endregion

        #region Properties

        public byte CharB
        {
            get
            {
                return charB;
            }
            set
            {
                charB = value;
            }
        }

        public byte Flags
        {
            get
            {
                return flags;
            }
            set
            {
                flags = value;
            }
        }

        #endregion

        #region Constructor

        public IS_SCH()
        {
            size = 72;
            type = PacketTypeEnum.ISP_SCH;
            reqI = 0;
            zero = 0;
            spare2 = 0;
            spare3 = 0;
        }

        #endregion
    }
}
