using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_SCC // Set Car Camera - Simplified camera packet (not SHIFT+U mode)
    {
        #region Member

        private byte size;		// 8
        private PacketTypeEnum type;		// ISP_SCC
        private byte reqI;		// 0
        private byte zero;

        private byte viewPLID;	// UniqueID of player to view
        private byte inGameCam;	// InGameCam (as reported in StatePack)
        private byte sp2;
        private byte sp3;

        #endregion

        #region Properties

        public byte ViewPLID
        {
            get { return viewPLID; }
            set { viewPLID = value; }
        }

        public byte InGameCam
        {
            get { return inGameCam; }
            set { inGameCam = value; }
        }
	
        #endregion

        #region Constructor

        public IS_SCC()
        {
            size = 8;
            type = PacketTypeEnum.ISP_SCC;
            reqI = 0;
            zero = 0;

            sp2 = 0;
            sp3 = 0;
        }

        #endregion
    }
}
