using LfsInSimLib.IS_Enums;
using LfsInSimLib.IS_SubPackets;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_RST
    {
        private byte Size;		// 28
        private PacketTypeEnum Type;		// ISP_RST
        public byte ReqI;		// 0 unless this is a reply to an TINY_RST request
        private byte Zero;

        public RaceLaps RaceLaps;	// 0 if qualifying
        public byte QualMins;	// 0 if race
        public byte NumP;		// number of players in race
        private byte Spare;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 6)]
        public string Track;	// short track name
        public byte Weather;
        public WindEnum Wind;

        public IS_RSTFlagsEnum Flags;		// race flags (must pit, can reset, etc - see below)
        public ushort NumNodes;	// total number of nodes in the path
        public ushort Finish;		// node index - finish line
        public ushort Split1;		// node index - split 1
        public ushort Split2;		// node index - split 2
        public ushort Split3;		// node index - split 3

        public IS_RST()
        {
            Size = 28;
            Type = PacketTypeEnum.ISP_RST;
            Zero = 0;
            Spare = 0;
        }
    }
}
