using LfsInSimLib.IS_Enums;
using LfsInSimLib.IS_SubPackets;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_NPL
    {
        private byte Size;		// 76
        private PacketTypeEnum Type;		// ISP_NPL
        public byte ReqI;		// 0 unless this is a reply to an TINY_NPL request
        public byte PLID;		// player's newly assigned unique id

        public byte UCID;		// connection's unique id
        public PlayerTypeEnum PType;		// bit 0 : female / bit 1 : AI / bit 2 : remote
        public PlayerFlagsEnum Flags;		// player flags

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 24)]
        public string PName;	// nickname

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
        private char[] plate;   // number plate - NO ZERO AT END!
        public string Plate
        {
            get
            {
                return new string(plate);
            }
            set
            {
                plate = value.ToCharArray(0, 8);
            }
        }

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 4)]
        public string CName;	// car name
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 16)]
        public string SName;	// skin name - MAX_CAR_TEX_NAME
        public Tyres Tyres;	// compounds

        public byte H_Mass;		// added mass (kg)
        public byte H_TRes;		// intake restriction
        private byte SpB;
        public PassengersFlagsEnum Pass;		// passengers byte

        private int Spare;

        private byte Sp0;
        public byte NumP;		// number in race (same when leaving pits, 1 more if new)
        private byte Sp2;
        private byte Sp3;

        public IS_NPL()
        {
            Size = 76;
            Type = PacketTypeEnum.ISP_NPL;
            SpB = 0;
            Spare = 0;
            Sp0 = 0;
            Sp2 = 0;
            Sp3 = 0;
        }
    }
}
