using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_MTC
    {
        #region Member

        private byte size;		// 72
        private PacketTypeEnum type;		// ISP_MTC
        private byte reqI;		// 0
        private byte zero;

        private byte uCID;		// connection's unique id (0 = host)
        private byte pLID;		// player's unique id (if zero, use UCID)
        private byte sp2;
        private byte sp3;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 64)]
        public string msg;	// last byte must be zero

        #endregion

        #region Properties

        public byte UCID
        {
            get
            {
                return uCID;
            }
            set
            {
                uCID = value;
            }
        }

        public byte PLID
        {
            get
            {
                return pLID;
            }
            set
            {
                pLID = value;
            }
        }

        #endregion

        #region Constructor

        public IS_MTC()
        {
            size = 72;
            type = PacketTypeEnum.ISP_MTC;
            reqI = 0;
            zero = 0;
            sp2 = 0;
            sp3 = 0;
        }

        #endregion
    }
}
