using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_MSO
    {
        private byte Size;		// 136
        private PacketTypeEnum Type;		// ISP_MSO
        private byte ReqI;		// 0
        private byte Zero;

        public byte UCID;		// connection's unique id (0 = host)
        public byte PLID;		// player's unique id (if zero, use UCID)
        public MSOUserTypeEnum UserType;	// set if typed by a user (see User Values below) 
        public byte TextStart;	// first character of the actual text (after player name)

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 128)]
        public string Msg;

        public IS_MSO()
        {
            Size = 136;
            Type = PacketTypeEnum.ISP_MSO;
            ReqI = 0;
            Zero = 0;
        }
    }
}
