using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_MSL
    {
        #region Member

        private byte size;		// 132
        private PacketTypeEnum type;		// ISP_MSL
        private byte reqI;		// 0
        private MessageSoundEnum sound;		// sound effect (see Message Sounds below)

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 128)]
        private string msg;	// last byte must be zero

        #endregion

        #region Properties

        public MessageSoundEnum Sound
        {
            get
            {
                return sound;
            }
            set
            {
                sound = value;
            }
        }

        public string Msg
        {
            get
            {
                return msg;
            }
            set
            {
                msg = value;
            }
        }

        #endregion

        #region Constructor

        public IS_MSL()
        {
            size = 132;
            type = PacketTypeEnum.ISP_MSL;
            reqI = 0;
        }

        #endregion
    }
}
