using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_MOD
    {
        #region Member

        private byte size;		// 20
        private PacketTypeEnum type;		// ISP_MOD
        private byte reqI;		// 0
        private byte zero;

        private int bits16;		// set to choose 16-bit
        private int rr;			// refresh rate - zero for default
        private int width;		// 0 means go to window
        private int height;		// 0 means go to window

        #endregion

        #region Properties

        public int Bits16		// set to choose 16-bit
        {
            get
            {
                return bits16;
            }
            set
            {
                bits16 = value;
            }
        }

        public int RR			// refresh rate - zero for default
        {
            get
            {
                return bits16;
            }
            set
            {
                bits16 = value;
            }
        }

        public int Width		// 0 means go to window
        {
            get
            {
                return width;
            }
            set
            {
                width = value;
            }
        }

        public int Height		// 0 means go to window
        {
            get
            {
                return height;
            }
            set
            {
                height = value;
            }
        }
        
        #endregion

        #region Constructor

        public IS_MOD()
        {
            size = 20;
            type = PacketTypeEnum.ISP_MOD;
            reqI = 0;
            zero = 0;
        }

        #endregion
    }
}
