using LfsInSimLib.IS_Enums;
using LfsInSimLib.IS_SubPackets;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_MCI // Multi Car Info - if more than 8 in race then more than one of these is sent
    {
        private byte Size;		// 4 + NumP * 28
        private PacketTypeEnum Type;		// ISP_MCI
        public byte ReqI;		// 0 unless this is a reply to an TINY_MCI request
        public byte NumC;		// number of valid CompCar structs in this packet

        //[MarshalAs(UnmanagedType.ByValArray, SizeConst = 224)]
        //private byte[] info;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
        public CompCar[] Info;	// car info for each player

        public IS_MCI()
        {
            Size = 228;
            Type = PacketTypeEnum.ISP_MCI;
        }
    }
}
