using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_FIN // FINished race notification (not a final result - use IS_RES)
    {
        private byte Size;		// 20
        private PacketTypeEnum Type;		// ISP_FIN
        private byte ReqI;		// 0
        public byte PLID;		// player's unique id (0 = player left before result was sent)

        public uint TTime;	// race time (ms)
        public uint BTime;	// best lap (ms)

        private byte SpA;
        public byte NumStops;	// number of pit stops
        public ConfirmationFlagsEnum Confirm;	// confirmation flags : disqualified etc - see below
        private byte SpB;

        public ushort LapsDone;	// laps completed
        public PlayerFlagsEnum Flags;		// player flags : help settings etc - see below

        public IS_FIN()
        {
            Size = 20;
            Type = PacketTypeEnum.ISP_FIN;
            ReqI = 0;
            SpA = 0;
            SpB = 0;
        }
    }
}
