using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_CPR
    {
        private byte Size;		// 36
        private PacketTypeEnum Type;		// ISP_CPR
        private byte ReqI;		// 0
        public byte UCID;		// unique id of the connection

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 24)]
        public string PName;	// new name
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
        private char[] plate;   // number plate - NO ZERO AT END!
        public string Plate
        {
            get
            {
                return new string(plate);
            }
            set
            {
                plate = value.ToCharArray(0, 8);
            }
        }

        public IS_CPR()
        {
            Size = 36;
            Type = PacketTypeEnum.ISP_CPR;
            ReqI = 0;
        }
    }
}
