using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_CPP // Cam Pos Pack - Full camera packet (in car OR SHIFT+U mode)
    {
        #region Member

        private byte size;		// 32
        private PacketTypeEnum type;		// ISP_CPP
        private byte reqI;		// instruction : 0 / or reply : ReqI as received in the TINY_SCP
        private byte zero;

        private Vec pos;		// Position vector

        private ushort heading;	// 0 points along Y axis
        private ushort pitch;		// 0 means looking at horizon

        private ushort roll;		// 0 means no roll
        private byte viewPLID;	// Unique ID of viewed player (0 = none)
        private ViewEnum inGameCam;	// InGameCam (as reported in StatePack)

        private float fOV;		// 4-byte float : FOV in radians

        private ushort time;		// Time to get there (0 means instant + reset)
        private IS_ISSFlagsEnum flags;		// ISS state flags (see below)

        #endregion

        #region Properties

        public Byte ReqI
        {
            get
            {
                return reqI;
            }
            set
            {
                reqI = value;
            }
        }

        public Vec Pos
        {
            get
            {
                return pos;
            }
            set
            {
                pos = value;
            }
        }

        public UInt16 Heading
        {
            get
            {
                return heading;
            }
            set
            {
                heading = value;
            }
        }

        public UInt16 Pitch
        {
            get
            {
                return pitch;
            }
            set
            {
                pitch = value;
            }
        }

        public UInt16 Roll
        {
            get
            {
                return roll;
            }
            set
            {
                roll = value;
            }
        }

        public Byte ViewPLID
        {
            get
            {
                return viewPLID;
            }
            set
            {
                viewPLID = value;
            }
        }

        public ViewEnum InGameCam
        {
            get
            {
                return inGameCam;
            }
            set
            {
                inGameCam = value;
            }
        }

        public Single FOV
        {
            get
            {
                return fOV;
            }
            set
            {
                fOV = value;
            }
        }

        public UInt16 Time
        {
            get
            {
                return time;
            }
            set
            {
                time = value;
            }
        }

        public IS_ISSFlagsEnum Flags
        {
            get
            {
                return flags;
            }
            set
            {
                flags = value;
            }
        }

        #endregion

        #region Constructor

        public IS_CPP()
        {
            size = 32;
            type = PacketTypeEnum.ISP_CPP;
            zero = 0;
        }

        #endregion
    }
}
