using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_BTC // BuTton Click - sent back when user clicks a button
    {
        private byte Size;		// 8
        private PacketTypeEnum Type;		// ISP_BTC
        public byte ReqI;		// ReqI as received in the IS_BTN
        public byte UCID;		// connection that clicked the button (zero if local)

        public byte ClickID;	// button identifier originally sent in IS_BTN
        public byte Inst;		// used internally by InSim
        public ButtonClickFlagsEnum CFlags;		// button click flags - see below
        private byte Sp3;

        public IS_BTC()
        {
            Size = 8;
            Type = PacketTypeEnum.ISP_BTC;
            Sp3 = 0;
        }
    }
}
