using System;
using System.Collections.Generic;
using System.Text;

namespace LfsInSimLib.IS_Enums
{
    [Flags()]
    public enum IS_ISSFlagsEnum : ushort
    {
        ISS_GAME = 1,		// in game (or MPR)
        ISS_REPLAY = 2,	// in SPR
        ISS_PAUSED = 4,		// paused
        ISS_SHIFTU = 8,		// in SHIFT+U mode
        ISS_SHIFTU_HIGH = 16,		// HIGH view
        ISS_SHIFTU_FOLLOW = 32,		// following car
        ISS_SHIFTU_NO_OPT = 64,		// buttons are hidden
        ISS_SHOW_2D = 128,		// showing 2d display
        ISS_FRONT_END = 256,		// in front end screen
        ISS_MULTI = 512,		// multiplayer mode
        ISS_MPSPEEDUP = 1024,	// multiplayer speedup option
        ISS_WINDOWED = 2048,	// lfs is running in a window
        ISS_SOUND_MUTE = 4096,	// sound is switched off
        ISS_VIEW_OVERRIDE = 8192,	// override user view
        ISS_VISIBLE = 16384	// buttons are visible
    }
}
