using LfsInSimLib;
using LfsInSimLib.IS_Enums;
using LfsInSimLib.IS_Packets;
using LfsInSimLib.IS_SubPackets;

using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Net.Sockets;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace TestApp
{
    public partial class MainForm : Form
    {
        #region Enumerations

        enum MessageDirection : byte
        {
            Receive,
            Send
        }

        #endregion

        #region Member

        private IsSocket isSocket;

        #endregion

        #region Constructor

        public MainForm()
        {
            InitializeComponent();
            InitializeRequestPacketComboBox();
            InitializeConnectFlagsCheckedListBox();
            InitializeSendPacketComboBox();
        }

        #endregion

        #region UI - EventHandler

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (isSocket != null && isSocket.Connected)
            {
                isSocket.Disconnect();
            }
        }

        private void connectButton_Click(object sender, EventArgs e)
        {
            if (isSocket != null && isSocket.Connected)
            {
                isSocket.Disconnect();
            }

            if (connectTcpRadioButton.Checked)
            {
                isSocket = new IsTcpSocket();
            }
            if (connectUdpRadioButton.Checked)
            {
                isSocket = new IsUdpSocket();
            }

            #region Attach EventHandler

            isSocket.IS_ISIReceived += new IsTcpSocket.IS_ISIReceivedDelegate(structSocket_IS_ISIReceived);
            isSocket.IS_VERReceived += new IsTcpSocket.IS_VERReceivedDelegate(structSocket_IS_VERReceived);
            isSocket.IS_TINYReceived += new IsTcpSocket.IS_TINYReceivedDelegate(structSocket_IS_TINYReceived);
            isSocket.IS_SMALLReceived += new IsTcpSocket.IS_SMALLReceivedDelegate(structSocket_IS_SMALLReceived);
            isSocket.IS_STAReceived += new IsTcpSocket.IS_STAReceivedDelegate(structSocket_IS_STAReceived);
            isSocket.IS_SCHReceived += new IsTcpSocket.IS_SCHReceivedDelegate(structSocket_IS_SCHReceived);
            isSocket.IS_SFPReceived += new IsTcpSocket.IS_SFPReceivedDelegate(structSocket_IS_SFPReceived);
            isSocket.IS_SCCReceived += new IsTcpSocket.IS_SCCReceivedDelegate(structSocket_IS_SCCReceived);
            isSocket.IS_CPPReceived += new IsTcpSocket.IS_CPPReceivedDelegate(structSocket_IS_CPPReceived);
            isSocket.IS_ISMReceived += new IsTcpSocket.IS_ISMReceivedDelegate(structSocket_IS_ISMReceived);
            isSocket.IS_MSOReceived += new IsTcpSocket.IS_MSOReceivedDelegate(structSocket_IS_MSOReceived);
            isSocket.IS_IIIReceived += new IsTcpSocket.IS_IIIReceivedDelegate(structSocket_IS_IIIReceived);
            isSocket.IS_MSTReceived += new IsTcpSocket.IS_MSTReceivedDelegate(structSocket_IS_MSTReceived);
            isSocket.IS_MTCReceived += new IsTcpSocket.IS_MTCReceivedDelegate(structSocket_IS_MTCReceived);
            isSocket.IS_MODReceived += new IsTcpSocket.IS_MODReceivedDelegate(structSocket_IS_MODReceived);
            isSocket.IS_VTNReceived += new IsTcpSocket.IS_VTNReceivedDelegate(structSocket_IS_VTNReceived);
            isSocket.IS_RSTReceived += new IsTcpSocket.IS_RSTReceivedDelegate(structSocket_IS_RSTReceived);
            isSocket.IS_NCNReceived += new IsTcpSocket.IS_NCNReceivedDelegate(structSocket_IS_NCNReceived);
            isSocket.IS_CNLReceived += new IsTcpSocket.IS_CNLReceivedDelegate(structSocket_IS_CNLReceived);
            isSocket.IS_CPRReceived += new IsTcpSocket.IS_CPRReceivedDelegate(structSocket_IS_CPRReceived);
            isSocket.IS_NPLReceived += new IsTcpSocket.IS_NPLReceivedDelegate(structSocket_IS_NPLReceived);
            isSocket.IS_PLPReceived += new IsTcpSocket.IS_PLPReceivedDelegate(structSocket_IS_PLPReceived);
            isSocket.IS_PLLReceived += new IsTcpSocket.IS_PLLReceivedDelegate(structSocket_IS_PLLReceived);
            isSocket.IS_LAPReceived += new IsTcpSocket.IS_LAPReceivedDelegate(structSocket_IS_LAPReceived);
            isSocket.IS_SPXReceived += new IsTcpSocket.IS_SPXReceivedDelegate(structSocket_IS_SPXReceived);
            isSocket.IS_PITReceived += new IsTcpSocket.IS_PITReceivedDelegate(structSocket_IS_PITReceived);
            isSocket.IS_PSFReceived += new IsTcpSocket.IS_PSFReceivedDelegate(structSocket_IS_PSFReceived);
            isSocket.IS_PLAReceived += new IsTcpSocket.IS_PLAReceivedDelegate(structSocket_IS_PLAReceived);
            isSocket.IS_CCHReceived += new IsTcpSocket.IS_CCHReceivedDelegate(structSocket_IS_CCHReceived);
            isSocket.IS_PENReceived += new IsTcpSocket.IS_PENReceivedDelegate(structSocket_IS_PENReceived);
            isSocket.IS_TOCReceived += new IsTcpSocket.IS_TOCReceivedDelegate(structSocket_IS_TOCReceived);
            isSocket.IS_FLGReceived += new IsTcpSocket.IS_FLGReceivedDelegate(structSocket_IS_FLGReceived);
            isSocket.IS_PFLReceived += new IsTcpSocket.IS_PFLReceivedDelegate(structSocket_IS_PFLReceived);
            isSocket.IS_FINReceived += new IsTcpSocket.IS_FINReceivedDelegate(structSocket_IS_FINReceived);
            isSocket.IS_RESReceived += new IsTcpSocket.IS_RESReceivedDelegate(structSocket_IS_RESReceived);
            isSocket.IS_REOReceived += new IsTcpSocket.IS_REOReceivedDelegate(structSocket_IS_REOReceived);
            isSocket.IS_NLPReceived += new IsTcpSocket.IS_NLPReceivedDelegate(structSocket_IS_NLPReceived);
            isSocket.IS_MCIReceived += new IsTcpSocket.IS_MCIReceivedDelegate(structSocket_IS_MCIReceived);
            isSocket.IS_MSXReceived += new IsTcpSocket.IS_MSXReceivedDelegate(structSocket_IS_MSXReceived);
            isSocket.IS_MSLReceived += new IsTcpSocket.IS_MSLReceivedDelegate(structSocket_IS_MSLReceived);
            isSocket.IS_CRSReceived += new IsTcpSocket.IS_CRSReceivedDelegate(structSocket_IS_CRSReceived);
            isSocket.IS_BFNReceived += new IsTcpSocket.IS_BFNReceivedDelegate(structSocket_IS_BFNReceived);
            isSocket.IS_BTNReceived += new IsTcpSocket.IS_BTNReceivedDelegate(structSocket_IS_BTNReceived);
            isSocket.IS_BTCReceived += new IsTcpSocket.IS_BTCReceivedDelegate(structSocket_IS_BTCReceived);
            isSocket.IS_BTTReceived += new IsTcpSocket.IS_BTTReceivedDelegate(structSocket_IS_BTTReceived);

            isSocket.IS_ISISent += new IsTcpSocket.IS_ISISentDelegate(structSocket_IS_ISISent);
            isSocket.IS_VERSent += new IsTcpSocket.IS_VERSentDelegate(structSocket_IS_VERSent);
            isSocket.IS_TINYSent += new IsTcpSocket.IS_TINYSentDelegate(structSocket_IS_TINYSent);
            isSocket.IS_SMALLSent += new IsTcpSocket.IS_SMALLSentDelegate(structSocket_IS_SMALLSent);
            isSocket.IS_STASent += new IsTcpSocket.IS_STASentDelegate(structSocket_IS_STASent);
            isSocket.IS_SCHSent += new IsTcpSocket.IS_SCHSentDelegate(structSocket_IS_SCHSent);
            isSocket.IS_SFPSent += new IsTcpSocket.IS_SFPSentDelegate(structSocket_IS_SFPSent);
            isSocket.IS_SCCSent += new IsTcpSocket.IS_SCCSentDelegate(structSocket_IS_SCCSent);
            isSocket.IS_CPPSent += new IsTcpSocket.IS_CPPSentDelegate(structSocket_IS_CPPSent);
            isSocket.IS_ISMSent += new IsTcpSocket.IS_ISMSentDelegate(structSocket_IS_ISMSent);
            isSocket.IS_MSOSent += new IsTcpSocket.IS_MSOSentDelegate(structSocket_IS_MSOSent);
            isSocket.IS_IIISent += new IsTcpSocket.IS_IIISentDelegate(structSocket_IS_IIISent);
            isSocket.IS_MSTSent += new IsTcpSocket.IS_MSTSentDelegate(structSocket_IS_MSTSent);
            isSocket.IS_MTCSent += new IsTcpSocket.IS_MTCSentDelegate(structSocket_IS_MTCSent);
            isSocket.IS_MODSent += new IsTcpSocket.IS_MODSentDelegate(structSocket_IS_MODSent);
            isSocket.IS_VTNSent += new IsTcpSocket.IS_VTNSentDelegate(structSocket_IS_VTNSent);
            isSocket.IS_RSTSent += new IsTcpSocket.IS_RSTSentDelegate(structSocket_IS_RSTSent);
            isSocket.IS_NCNSent += new IsTcpSocket.IS_NCNSentDelegate(structSocket_IS_NCNSent);
            isSocket.IS_CNLSent += new IsTcpSocket.IS_CNLSentDelegate(structSocket_IS_CNLSent);
            isSocket.IS_CPRSent += new IsTcpSocket.IS_CPRSentDelegate(structSocket_IS_CPRSent);
            isSocket.IS_NPLSent += new IsTcpSocket.IS_NPLSentDelegate(structSocket_IS_NPLSent);
            isSocket.IS_PLPSent += new IsTcpSocket.IS_PLPSentDelegate(structSocket_IS_PLPSent);
            isSocket.IS_PLLSent += new IsTcpSocket.IS_PLLSentDelegate(structSocket_IS_PLLSent);
            isSocket.IS_LAPSent += new IsTcpSocket.IS_LAPSentDelegate(structSocket_IS_LAPSent);
            isSocket.IS_SPXSent += new IsTcpSocket.IS_SPXSentDelegate(structSocket_IS_SPXSent);
            isSocket.IS_PITSent += new IsTcpSocket.IS_PITSentDelegate(structSocket_IS_PITSent);
            isSocket.IS_PSFSent += new IsTcpSocket.IS_PSFSentDelegate(structSocket_IS_PSFSent);
            isSocket.IS_PLASent += new IsTcpSocket.IS_PLASentDelegate(structSocket_IS_PLASent);
            isSocket.IS_CCHSent += new IsTcpSocket.IS_CCHSentDelegate(structSocket_IS_CCHSent);
            isSocket.IS_PENSent += new IsTcpSocket.IS_PENSentDelegate(structSocket_IS_PENSent);
            isSocket.IS_TOCSent += new IsTcpSocket.IS_TOCSentDelegate(structSocket_IS_TOCSent);
            isSocket.IS_FLGSent += new IsTcpSocket.IS_FLGSentDelegate(structSocket_IS_FLGSent);
            isSocket.IS_PFLSent += new IsTcpSocket.IS_PFLSentDelegate(structSocket_IS_PFLSent);
            isSocket.IS_FINSent += new IsTcpSocket.IS_FINSentDelegate(structSocket_IS_FINSent);
            isSocket.IS_RESSent += new IsTcpSocket.IS_RESSentDelegate(structSocket_IS_RESSent);
            isSocket.IS_REOSent += new IsTcpSocket.IS_REOSentDelegate(structSocket_IS_REOSent);
            isSocket.IS_NLPSent += new IsTcpSocket.IS_NLPSentDelegate(structSocket_IS_NLPSent);
            isSocket.IS_MCISent += new IsTcpSocket.IS_MCISentDelegate(structSocket_IS_MCISent);
            isSocket.IS_MSXSent += new IsTcpSocket.IS_MSXSentDelegate(structSocket_IS_MSXSent);
            isSocket.IS_MSLSent += new IsTcpSocket.IS_MSLSentDelegate(structSocket_IS_MSLSent);
            isSocket.IS_CRSSent += new IsTcpSocket.IS_CRSSentDelegate(structSocket_IS_CRSSent);
            isSocket.IS_BFNSent += new IsTcpSocket.IS_BFNSentDelegate(structSocket_IS_BFNSent);
            isSocket.IS_BTNSent += new IsTcpSocket.IS_BTNSentDelegate(structSocket_IS_BTNSent);
            isSocket.IS_BTCSent += new IsTcpSocket.IS_BTCSentDelegate(structSocket_IS_BTCSent);
            isSocket.IS_BTTSent += new IsTcpSocket.IS_BTTSentDelegate(structSocket_IS_BTTSent);

            #endregion

            isSocket.Connect(connectLfsHostTextBox.Text);

            IS_ISI isISI = new IS_ISI();
            isISI.ReqI = Convert.ToByte(connectReqINumericUpDown.Value);
            isISI.UDPPort = Convert.ToUInt16(connectReplyUdpNumericUpDown.Value);
            foreach (object checkedItem in connectFlagsCheckedListBox.CheckedItems)
            {
                IS_ISIFlagsEnum checkedFlag = (IS_ISIFlagsEnum)Enum.Parse(typeof(IS_ISIFlagsEnum), checkedItem.ToString());
                isISI.Flags |= checkedFlag;
            }
            isISI.Prefix = Convert.ToByte(connectPrefixNumericUpDown.Value);
            isISI.Interval = Convert.ToUInt16(connectIntervalNumericUpDown.Value);
            isISI.Admin = connectAdminTextBox.Text;
            isISI.IName = connectINameTextBox.Text;

            isSocket.Send(isISI);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (isSocket != null && isSocket.Connected && 
                requestPacketComboBox.SelectedItem != null)
            {
                string requestPacketName = requestPacketComboBox.SelectedItem.ToString();

                Type requestType = typeof(Request);
                MethodInfo mi = requestType.GetMethod(requestPacketName);
                object requestPacket = mi.Invoke(
                    null,
                    new object[] { Convert.ToByte(reqINumericUpDown.Value) });

                isSocket.Send(requestPacket);
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
        }

        private void sendPacketComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (sendPacketComboBox.SelectedItem != null)
            {
                string sendPacketName = sendPacketComboBox.SelectedItem.ToString();
                string fullName = string.Format(
                    "LfsInSimLib.IS_Packets.{0},LfsInSimLib",
                    sendPacketName);
                Type sendType = Type.GetType(fullName);
                ConstructorInfo ci = sendType.GetConstructor(new Type[] { });
                object sendPacket = ci.Invoke(null);
                sendPacketPropertyGrid.SelectedObject = sendPacket;
            }
        }

        private void sendPacketButton_Click(object sender, EventArgs e)
        {
            if (isSocket != null && isSocket.Connected &&
                sendPacketPropertyGrid.SelectedObject != null)
            {
                isSocket.Send(sendPacketPropertyGrid.SelectedObject);
            }
        }

        #endregion

        #region StructSocket - EventHandler

        void structSocket_IS_ISIReceived(IS_ISI is_isi)
        {
            LogMessage(is_isi, MessageDirection.Receive);
        }

        void structSocket_IS_VERReceived(IS_VER is_ver)
        {
            LogMessage(is_ver, MessageDirection.Receive);
        }

        void structSocket_IS_TINYReceived(IS_TINY is_tiny)
        {
            LogMessage(is_tiny, MessageDirection.Receive);
        }

        void structSocket_IS_SMALLReceived(IS_SMALL is_small)
        {
            LogMessage(is_small, MessageDirection.Receive);
        }

        void structSocket_IS_STAReceived(IS_STA is_sta)
        {
            LogMessage(is_sta, MessageDirection.Receive);
        }

        void structSocket_IS_SCHReceived(IS_SCH is_sch)
        {
            LogMessage(is_sch, MessageDirection.Receive);
        }

        void structSocket_IS_SFPReceived(IS_SFP is_sfp)
        {
            LogMessage(is_sfp, MessageDirection.Receive);
        }

        void structSocket_IS_SCCReceived(IS_SCC is_scc)
        {
            LogMessage(is_scc, MessageDirection.Receive);
        }

        void structSocket_IS_CPPReceived(IS_CPP is_cpp)
        {
            LogMessage(is_cpp, MessageDirection.Receive);
        }

        void structSocket_IS_ISMReceived(IS_ISM is_ism)
        {
            LogMessage(is_ism, MessageDirection.Receive);
        }

        void structSocket_IS_MSOReceived(IS_MSO is_mso)
        {
            LogMessage(is_mso, MessageDirection.Receive);
        }

        void structSocket_IS_IIIReceived(IS_III is_iii)
        {
            LogMessage(is_iii, MessageDirection.Receive);
        }

        void structSocket_IS_MSTReceived(IS_MST is_mst)
        {
            LogMessage(is_mst, MessageDirection.Receive);
        }

        void structSocket_IS_MTCReceived(IS_MTC is_mtc)
        {
            LogMessage(is_mtc, MessageDirection.Receive);
        }

        void structSocket_IS_MODReceived(IS_MOD is_mod)
        {
            LogMessage(is_mod, MessageDirection.Receive);
        }

        void structSocket_IS_VTNReceived(IS_VTN is_vtn)
        {
            LogMessage(is_vtn, MessageDirection.Receive);
        }

        void structSocket_IS_RSTReceived(IS_RST is_rst)
        {
            LogMessage(is_rst, MessageDirection.Receive);
        }

        void structSocket_IS_NCNReceived(IS_NCN is_ncn)
        {
            LogMessage(is_ncn, MessageDirection.Receive);
        }

        void structSocket_IS_CNLReceived(IS_CNL is_cnl)
        {
            LogMessage(is_cnl, MessageDirection.Receive);
        }

        void structSocket_IS_CPRReceived(IS_CPR is_cpr)
        {
            LogMessage(is_cpr, MessageDirection.Receive);
        }

        void structSocket_IS_NPLReceived(IS_NPL is_npl)
        {
            LogMessage(is_npl, MessageDirection.Receive);
        }

        void structSocket_IS_PLPReceived(IS_PLP is_plp)
        {
            LogMessage(is_plp, MessageDirection.Receive);
        }

        void structSocket_IS_PLLReceived(IS_PLL is_pll)
        {
            LogMessage(is_pll, MessageDirection.Receive);
        }

        void structSocket_IS_LAPReceived(IS_LAP is_lap)
        {
            LogMessage(is_lap, MessageDirection.Receive);
        }

        void structSocket_IS_SPXReceived(IS_SPX is_spx)
        {
            LogMessage(is_spx, MessageDirection.Receive);
        }

        void structSocket_IS_PITReceived(IS_PIT is_pit)
        {
            LogMessage(is_pit, MessageDirection.Receive);
        }

        void structSocket_IS_PSFReceived(IS_PSF is_psf)
        {
            LogMessage(is_psf, MessageDirection.Receive);
        }

        void structSocket_IS_PLAReceived(IS_PLA is_pla)
        {
            LogMessage(is_pla, MessageDirection.Receive);
        }

        void structSocket_IS_CCHReceived(IS_CCH is_cch)
        {
            LogMessage(is_cch, MessageDirection.Receive);
        }

        void structSocket_IS_PENReceived(IS_PEN is_pen)
        {
            LogMessage(is_pen, MessageDirection.Receive);
        }

        void structSocket_IS_TOCReceived(IS_TOC is_toc)
        {
            LogMessage(is_toc, MessageDirection.Receive);
        }

        void structSocket_IS_FLGReceived(IS_FLG is_flg)
        {
            LogMessage(is_flg, MessageDirection.Receive);
        }

        void structSocket_IS_PFLReceived(IS_PFL is_pfl)
        {
            LogMessage(is_pfl, MessageDirection.Receive);
        }

        void structSocket_IS_FINReceived(IS_FIN is_fin)
        {
            LogMessage(is_fin, MessageDirection.Receive);
        }

        void structSocket_IS_RESReceived(IS_RES is_res)
        {
            LogMessage(is_res, MessageDirection.Receive);
        }

        void structSocket_IS_REOReceived(IS_REO is_reo)
        {
            LogMessage(is_reo, MessageDirection.Receive);
        }

        void structSocket_IS_NLPReceived(IS_NLP is_nlp)
        {
            LogMessage(is_nlp, MessageDirection.Receive);
        }

        void structSocket_IS_MCIReceived(IS_MCI is_mci)
        {
            LogMessage(is_mci, MessageDirection.Receive);
        }

        void structSocket_IS_MSXReceived(IS_MSX is_msx)
        {
            LogMessage(is_msx, MessageDirection.Receive);
        }

        void structSocket_IS_MSLReceived(IS_MSL is_msl)
        {
            LogMessage(is_msl, MessageDirection.Receive);
        }

        void structSocket_IS_CRSReceived(IS_CRS is_crs)
        {
            LogMessage(is_crs, MessageDirection.Receive);
        }

        void structSocket_IS_BFNReceived(IS_BFN is_bfn)
        {
            LogMessage(is_bfn, MessageDirection.Receive);
        }

        void structSocket_IS_BTNReceived(IS_BTN is_btn)
        {
            LogMessage(is_btn, MessageDirection.Receive);
        }

        void structSocket_IS_BTCReceived(IS_BTC is_btc)
        {
            LogMessage(is_btc, MessageDirection.Receive);
        }

        void structSocket_IS_BTTReceived(IS_BTT is_btt)
        {
            LogMessage(is_btt, MessageDirection.Receive);
        }



        void structSocket_IS_ISISent(IS_ISI is_isi)
        {
            LogMessage(is_isi, MessageDirection.Send);
        }

        void structSocket_IS_VERSent(IS_VER is_ver)
        {
            LogMessage(is_ver, MessageDirection.Send);
        }

        void structSocket_IS_TINYSent(IS_TINY is_tiny)
        {
            LogMessage(is_tiny, MessageDirection.Send);
        }

        void structSocket_IS_SMALLSent(IS_SMALL is_small)
        {
            LogMessage(is_small, MessageDirection.Send);
        }

        void structSocket_IS_STASent(IS_STA is_sta)
        {
            LogMessage(is_sta, MessageDirection.Send);
        }

        void structSocket_IS_SCHSent(IS_SCH is_sch)
        {
            LogMessage(is_sch, MessageDirection.Send);
        }

        void structSocket_IS_SFPSent(IS_SFP is_sfp)
        {
            LogMessage(is_sfp, MessageDirection.Send);
        }

        void structSocket_IS_SCCSent(IS_SCC is_scc)
        {
            LogMessage(is_scc, MessageDirection.Send);
        }

        void structSocket_IS_CPPSent(IS_CPP is_cpp)
        {
            LogMessage(is_cpp, MessageDirection.Send);
        }

        void structSocket_IS_ISMSent(IS_ISM is_ism)
        {
            LogMessage(is_ism, MessageDirection.Send);
        }

        void structSocket_IS_MSOSent(IS_MSO is_mso)
        {
            LogMessage(is_mso, MessageDirection.Send);
        }

        void structSocket_IS_IIISent(IS_III is_iii)
        {
            LogMessage(is_iii, MessageDirection.Send);
        }

        void structSocket_IS_MSTSent(IS_MST is_mst)
        {
            LogMessage(is_mst, MessageDirection.Send);
        }

        void structSocket_IS_MTCSent(IS_MTC is_mtc)
        {
            LogMessage(is_mtc, MessageDirection.Send);
        }

        void structSocket_IS_MODSent(IS_MOD is_mod)
        {
            LogMessage(is_mod, MessageDirection.Send);
        }

        void structSocket_IS_VTNSent(IS_VTN is_vtn)
        {
            LogMessage(is_vtn, MessageDirection.Send);
        }

        void structSocket_IS_RSTSent(IS_RST is_rst)
        {
            LogMessage(is_rst, MessageDirection.Send);
        }

        void structSocket_IS_NCNSent(IS_NCN is_ncn)
        {
            LogMessage(is_ncn, MessageDirection.Send);
        }

        void structSocket_IS_CNLSent(IS_CNL is_cnl)
        {
            LogMessage(is_cnl, MessageDirection.Send);
        }

        void structSocket_IS_CPRSent(IS_CPR is_cpr)
        {
            LogMessage(is_cpr, MessageDirection.Send);
        }

        void structSocket_IS_NPLSent(IS_NPL is_npl)
        {
            LogMessage(is_npl, MessageDirection.Send);
        }

        void structSocket_IS_PLPSent(IS_PLP is_plp)
        {
            LogMessage(is_plp, MessageDirection.Send);
        }

        void structSocket_IS_PLLSent(IS_PLL is_pll)
        {
            LogMessage(is_pll, MessageDirection.Send);
        }

        void structSocket_IS_LAPSent(IS_LAP is_lap)
        {
            LogMessage(is_lap, MessageDirection.Send);
        }

        void structSocket_IS_SPXSent(IS_SPX is_spx)
        {
            LogMessage(is_spx, MessageDirection.Send);
        }

        void structSocket_IS_PITSent(IS_PIT is_pit)
        {
            LogMessage(is_pit, MessageDirection.Send);
        }

        void structSocket_IS_PSFSent(IS_PSF is_psf)
        {
            LogMessage(is_psf, MessageDirection.Send);
        }

        void structSocket_IS_PLASent(IS_PLA is_pla)
        {
            LogMessage(is_pla, MessageDirection.Send);
        }

        void structSocket_IS_CCHSent(IS_CCH is_cch)
        {
            LogMessage(is_cch, MessageDirection.Send);
        }

        void structSocket_IS_PENSent(IS_PEN is_pen)
        {
            LogMessage(is_pen, MessageDirection.Send);
        }

        void structSocket_IS_TOCSent(IS_TOC is_toc)
        {
            LogMessage(is_toc, MessageDirection.Send);
        }

        void structSocket_IS_FLGSent(IS_FLG is_flg)
        {
            LogMessage(is_flg, MessageDirection.Send);
        }

        void structSocket_IS_PFLSent(IS_PFL is_pfl)
        {
            LogMessage(is_pfl, MessageDirection.Send);
        }

        void structSocket_IS_FINSent(IS_FIN is_fin)
        {
            LogMessage(is_fin, MessageDirection.Send);
        }

        void structSocket_IS_RESSent(IS_RES is_res)
        {
            LogMessage(is_res, MessageDirection.Send);
        }

        void structSocket_IS_REOSent(IS_REO is_reo)
        {
            LogMessage(is_reo, MessageDirection.Send);
        }

        void structSocket_IS_NLPSent(IS_NLP is_nlp)
        {
            LogMessage(is_nlp, MessageDirection.Send);
        }

        void structSocket_IS_MCISent(IS_MCI is_mci)
        {
            LogMessage(is_mci, MessageDirection.Send);
        }

        void structSocket_IS_MSXSent(IS_MSX is_msx)
        {
            LogMessage(is_msx, MessageDirection.Send);
        }

        void structSocket_IS_MSLSent(IS_MSL is_msl)
        {
            LogMessage(is_msl, MessageDirection.Send);
        }

        void structSocket_IS_CRSSent(IS_CRS is_crs)
        {
            LogMessage(is_crs, MessageDirection.Send);
        }

        void structSocket_IS_BFNSent(IS_BFN is_bfn)
        {
            LogMessage(is_bfn, MessageDirection.Send);
        }

        void structSocket_IS_BTNSent(IS_BTN is_btn)
        {
            LogMessage(is_btn, MessageDirection.Send);
        }

        void structSocket_IS_BTCSent(IS_BTC is_btc)
        {
            LogMessage(is_btc, MessageDirection.Send);
        }

        void structSocket_IS_BTTSent(IS_BTT is_btt)
        {
            LogMessage(is_btt, MessageDirection.Send);
        }

        #endregion

        #region ThreadSafe UI-Methods

        private delegate void LogMessageDelegate(object message, MessageDirection messageDirection);
        private void LogMessage(object message, MessageDirection messageDirection)
        {
            if (InvokeRequired)
            {
                Invoke(new LogMessageDelegate(LogMessage), new object[] { message, messageDirection });
            }
            else
            {
                TreeView trv = null;
                bool autoScroll = false;

                switch (messageDirection)
                {
                    case MessageDirection.Receive:
                        trv = receivedMessagesTreeView;
                        autoScroll = receivedMessagesAutoScrollCheckBox.Checked;
                        break;
                    case MessageDirection.Send:
                        trv = sentMessagesTreeView;
                        autoScroll = sentMessagesAutoScrollCheckBox.Checked;
                        break;
                }

                LogMessage(trv, message, autoScroll);
            }
        }

        #endregion

        #region Methods

        private void InitializeRequestPacketComboBox()
        {
            Type t = typeof(Request);
            foreach (MethodInfo mi in t.GetMethods())
            {
                if (mi.Name.StartsWith("IS_"))
                {
                    requestPacketComboBox.Items.Add(mi.Name);
                }
            }
            ArrayList.Adapter(requestPacketComboBox.Items).Sort();
        }

        private void InitializeConnectFlagsCheckedListBox()
        {
            foreach (string enumName in Enum.GetNames(typeof(IS_ISIFlagsEnum)))
            {
                connectFlagsCheckedListBox.Items.Add(enumName);
            }
        }

        private void InitializeSendPacketComboBox()
        {
            Assembly asm = Assembly.GetAssembly(typeof(IsTcpSocket));
            foreach (Type t in asm.GetTypes())
            {
                if (Attribute.GetCustomAttribute(t, typeof(IS_SendableAttribute)) != null)
                {
                    sendPacketComboBox.Items.Add(t.Name);
                }
            }
            ArrayList.Adapter(sendPacketComboBox.Items).Sort();
        }

        private void LogMessage(TreeView trv, object message, bool autoScroll)
        {
            trv.BeginUpdate();

            Type messageType = message.GetType();
            TreeNode treeNode = trv.Nodes.Add(messageType.ToString());

            LogMessage(treeNode, message);

            if (autoScroll)
            {
                trv.TopNode = treeNode;
            }

            trv.EndUpdate();
        }

        private void LogMessage(TreeNode treeNode, object message)
        {
            Type messageType = message.GetType();

            if (treeNode.Parent != null)
            {
                treeNode = treeNode.Nodes.Add(messageType.ToString());
            }
            foreach (FieldInfo fi in messageType.GetFields())
            {
                object val = fi.GetValue(message);
                string description = string.Format("{0} - {1}",
                    fi.Name,
                    val.ToString());
                TreeNode childTreeNode = treeNode.Nodes.Add(description);

                if (fi.FieldType.IsArray)
                {
                    Array arr = val as Array;
                    foreach (object arrVal in arr)
                    {
                        LogMessage(childTreeNode, arrVal);
                    }
                }
            }
            foreach (PropertyInfo pi in messageType.GetProperties())
            {
                object val = pi.GetValue(message, null);
                string propertyDescription = string.Format("{0} - {1}",
                    pi.Name,
                    val.ToString());
                TreeNode childTreeNode = treeNode.Nodes.Add(propertyDescription);

                if (pi.PropertyType.IsArray)
                {
                    Array arr = val as Array;
                    foreach (object arrVal in arr)
                    {
                        LogMessage(childTreeNode, arrVal);
                    }
                }
            }
        }

        #endregion
    }
}