using LfsInSimLib.IS_Enums;
using LfsInSimLib.IS_Packets;

using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Sockets;
using System.Text;

namespace LfsInSimLib
{
    public abstract class IsSocket
    {
        #region Member

        protected Socket clientSocket;

        #endregion

        #region Properties

        public bool Connected
        {
            get
            {
                return clientSocket != null && clientSocket.Connected;
            }
        }

        #endregion

        #region Abstract Properties

        protected abstract ProtocolType ProtocolType { get; }

        protected abstract SocketType SocketType { get; }

        #endregion

        #region Delegates & Events

        private delegate void MessageReceivedDelegate(byte[] msg);
        private event MessageReceivedDelegate MessageReceived;
        private delegate void MessageSentDelegate(byte[] msg);
        private event MessageSentDelegate MessageSent;

        public delegate void IS_ISIReceivedDelegate(IS_ISI is_isi);
        public event IS_ISIReceivedDelegate IS_ISIReceived;
        public delegate void IS_ISISentDelegate(IS_ISI is_isi);
        public event IS_ISISentDelegate IS_ISISent;

        public delegate void IS_VERReceivedDelegate(IS_VER is_ver);
        public event IS_VERReceivedDelegate IS_VERReceived;
        public delegate void IS_VERSentDelegate(IS_VER is_ver);
        public event IS_VERSentDelegate IS_VERSent;

        public delegate void IS_TINYReceivedDelegate(IS_TINY is_tiny);
        public event IS_TINYReceivedDelegate IS_TINYReceived;
        public delegate void IS_TINYSentDelegate(IS_TINY is_tiny);
        public event IS_TINYSentDelegate IS_TINYSent;

        public delegate void IS_SMALLReceivedDelegate(IS_SMALL is_small);
        public event IS_SMALLReceivedDelegate IS_SMALLReceived;
        public delegate void IS_SMALLSentDelegate(IS_SMALL is_small);
        public event IS_SMALLSentDelegate IS_SMALLSent;

        public delegate void IS_STAReceivedDelegate(IS_STA is_sta);
        public event IS_STAReceivedDelegate IS_STAReceived;
        public delegate void IS_STASentDelegate(IS_STA is_sta);
        public event IS_STASentDelegate IS_STASent;

        public delegate void IS_SCHReceivedDelegate(IS_SCH is_sch);
        public event IS_SCHReceivedDelegate IS_SCHReceived;
        public delegate void IS_SCHSentDelegate(IS_SCH is_sch);
        public event IS_SCHSentDelegate IS_SCHSent;

        public delegate void IS_SFPReceivedDelegate(IS_SFP is_sfp);
        public event IS_SFPReceivedDelegate IS_SFPReceived;
        public delegate void IS_SFPSentDelegate(IS_SFP is_sfp);
        public event IS_SFPSentDelegate IS_SFPSent;

        public delegate void IS_SCCReceivedDelegate(IS_SCC is_scc);
        public event IS_SCCReceivedDelegate IS_SCCReceived;
        public delegate void IS_SCCSentDelegate(IS_SCC is_scc);
        public event IS_SCCSentDelegate IS_SCCSent;

        public delegate void IS_CPPReceivedDelegate(IS_CPP is_cpp);
        public event IS_CPPReceivedDelegate IS_CPPReceived;
        public delegate void IS_CPPSentDelegate(IS_CPP is_cpp);
        public event IS_CPPSentDelegate IS_CPPSent;

        public delegate void IS_ISMReceivedDelegate(IS_ISM is_ism);
        public event IS_ISMReceivedDelegate IS_ISMReceived;
        public delegate void IS_ISMSentDelegate(IS_ISM is_ism);
        public event IS_ISMSentDelegate IS_ISMSent;

        public delegate void IS_MSOReceivedDelegate(IS_MSO is_mso);
        public event IS_MSOReceivedDelegate IS_MSOReceived;
        public delegate void IS_MSOSentDelegate(IS_MSO is_mso);
        public event IS_MSOSentDelegate IS_MSOSent;

        public delegate void IS_IIIReceivedDelegate(IS_III is_iii);
        public event IS_IIIReceivedDelegate IS_IIIReceived;
        public delegate void IS_IIISentDelegate(IS_III is_iii);
        public event IS_IIISentDelegate IS_IIISent;

        public delegate void IS_MSTReceivedDelegate(IS_MST is_mst);
        public event IS_MSTReceivedDelegate IS_MSTReceived;
        public delegate void IS_MSTSentDelegate(IS_MST is_mst);
        public event IS_MSTSentDelegate IS_MSTSent;

        public delegate void IS_MTCReceivedDelegate(IS_MTC is_mtc);
        public event IS_MTCReceivedDelegate IS_MTCReceived;
        public delegate void IS_MTCSentDelegate(IS_MTC is_mtc);
        public event IS_MTCSentDelegate IS_MTCSent;

        public delegate void IS_MODReceivedDelegate(IS_MOD is_mod);
        public event IS_MODReceivedDelegate IS_MODReceived;
        public delegate void IS_MODSentDelegate(IS_MOD is_mod);
        public event IS_MODSentDelegate IS_MODSent;

        public delegate void IS_VTNReceivedDelegate(IS_VTN is_vtn);
        public event IS_VTNReceivedDelegate IS_VTNReceived;
        public delegate void IS_VTNSentDelegate(IS_VTN is_vtn);
        public event IS_VTNSentDelegate IS_VTNSent;

        public delegate void IS_RSTReceivedDelegate(IS_RST is_rst);
        public event IS_RSTReceivedDelegate IS_RSTReceived;
        public delegate void IS_RSTSentDelegate(IS_RST is_rst);
        public event IS_RSTSentDelegate IS_RSTSent;

        public delegate void IS_NCNReceivedDelegate(IS_NCN is_ncn);
        public event IS_NCNReceivedDelegate IS_NCNReceived;
        public delegate void IS_NCNSentDelegate(IS_NCN is_ncn);
        public event IS_NCNSentDelegate IS_NCNSent;

        public delegate void IS_CNLReceivedDelegate(IS_CNL is_cnl);
        public event IS_CNLReceivedDelegate IS_CNLReceived;
        public delegate void IS_CNLSentDelegate(IS_CNL is_cnl);
        public event IS_CNLSentDelegate IS_CNLSent;

        public delegate void IS_CPRReceivedDelegate(IS_CPR is_cpr);
        public event IS_CPRReceivedDelegate IS_CPRReceived;
        public delegate void IS_CPRSentDelegate(IS_CPR is_cpr);
        public event IS_CPRSentDelegate IS_CPRSent;

        public delegate void IS_NPLReceivedDelegate(IS_NPL is_npl);
        public event IS_NPLReceivedDelegate IS_NPLReceived;
        public delegate void IS_NPLSentDelegate(IS_NPL is_npl);
        public event IS_NPLSentDelegate IS_NPLSent;

        public delegate void IS_PLPReceivedDelegate(IS_PLP is_plp);
        public event IS_PLPReceivedDelegate IS_PLPReceived;
        public delegate void IS_PLPSentDelegate(IS_PLP is_plp);
        public event IS_PLPSentDelegate IS_PLPSent;

        public delegate void IS_PLLReceivedDelegate(IS_PLL is_pll);
        public event IS_PLLReceivedDelegate IS_PLLReceived;
        public delegate void IS_PLLSentDelegate(IS_PLL is_pll);
        public event IS_PLLSentDelegate IS_PLLSent;

        public delegate void IS_LAPReceivedDelegate(IS_LAP is_lap);
        public event IS_LAPReceivedDelegate IS_LAPReceived;
        public delegate void IS_LAPSentDelegate(IS_LAP is_lap);
        public event IS_LAPSentDelegate IS_LAPSent;

        public delegate void IS_SPXReceivedDelegate(IS_SPX is_spx);
        public event IS_SPXReceivedDelegate IS_SPXReceived;
        public delegate void IS_SPXSentDelegate(IS_SPX is_spx);
        public event IS_SPXSentDelegate IS_SPXSent;

        public delegate void IS_PITReceivedDelegate(IS_PIT is_pit);
        public event IS_PITReceivedDelegate IS_PITReceived;
        public delegate void IS_PITSentDelegate(IS_PIT is_pit);
        public event IS_PITSentDelegate IS_PITSent;

        public delegate void IS_PSFReceivedDelegate(IS_PSF is_psf);
        public event IS_PSFReceivedDelegate IS_PSFReceived;
        public delegate void IS_PSFSentDelegate(IS_PSF is_psf);
        public event IS_PSFSentDelegate IS_PSFSent;

        public delegate void IS_PLAReceivedDelegate(IS_PLA is_pla);
        public event IS_PLAReceivedDelegate IS_PLAReceived;
        public delegate void IS_PLASentDelegate(IS_PLA is_pla);
        public event IS_PLASentDelegate IS_PLASent;

        public delegate void IS_CCHReceivedDelegate(IS_CCH is_cch);
        public event IS_CCHReceivedDelegate IS_CCHReceived;
        public delegate void IS_CCHSentDelegate(IS_CCH is_cch);
        public event IS_CCHSentDelegate IS_CCHSent;

        public delegate void IS_PENReceivedDelegate(IS_PEN is_pen);
        public event IS_PENReceivedDelegate IS_PENReceived;
        public delegate void IS_PENSentDelegate(IS_PEN is_pen);
        public event IS_PENSentDelegate IS_PENSent;

        public delegate void IS_TOCReceivedDelegate(IS_TOC is_toc);
        public event IS_TOCReceivedDelegate IS_TOCReceived;
        public delegate void IS_TOCSentDelegate(IS_TOC is_toc);
        public event IS_TOCSentDelegate IS_TOCSent;

        public delegate void IS_FLGReceivedDelegate(IS_FLG is_flg);
        public event IS_FLGReceivedDelegate IS_FLGReceived;
        public delegate void IS_FLGSentDelegate(IS_FLG is_flg);
        public event IS_FLGSentDelegate IS_FLGSent;

        public delegate void IS_PFLReceivedDelegate(IS_PFL is_pfl);
        public event IS_PFLReceivedDelegate IS_PFLReceived;
        public delegate void IS_PFLSentDelegate(IS_PFL is_pfl);
        public event IS_PFLSentDelegate IS_PFLSent;

        public delegate void IS_FINReceivedDelegate(IS_FIN is_fin);
        public event IS_FINReceivedDelegate IS_FINReceived;
        public delegate void IS_FINSentDelegate(IS_FIN is_fin);
        public event IS_FINSentDelegate IS_FINSent;

        public delegate void IS_RESReceivedDelegate(IS_RES is_res);
        public event IS_RESReceivedDelegate IS_RESReceived;
        public delegate void IS_RESSentDelegate(IS_RES is_res);
        public event IS_RESSentDelegate IS_RESSent;

        public delegate void IS_REOReceivedDelegate(IS_REO is_reo);
        public event IS_REOReceivedDelegate IS_REOReceived;
        public delegate void IS_REOSentDelegate(IS_REO is_reo);
        public event IS_REOSentDelegate IS_REOSent;

        public delegate void IS_NLPReceivedDelegate(IS_NLP is_nlp);
        public event IS_NLPReceivedDelegate IS_NLPReceived;
        public delegate void IS_NLPSentDelegate(IS_NLP is_nlp);
        public event IS_NLPSentDelegate IS_NLPSent;

        public delegate void IS_MCIReceivedDelegate(IS_MCI is_mci);
        public event IS_MCIReceivedDelegate IS_MCIReceived;
        public delegate void IS_MCISentDelegate(IS_MCI is_mci);
        public event IS_MCISentDelegate IS_MCISent;

        public delegate void IS_MSXReceivedDelegate(IS_MSX is_msx);
        public event IS_MSXReceivedDelegate IS_MSXReceived;
        public delegate void IS_MSXSentDelegate(IS_MSX is_msx);
        public event IS_MSXSentDelegate IS_MSXSent;

        public delegate void IS_MSLReceivedDelegate(IS_MSL is_msl);
        public event IS_MSLReceivedDelegate IS_MSLReceived;
        public delegate void IS_MSLSentDelegate(IS_MSL is_msl);
        public event IS_MSLSentDelegate IS_MSLSent;

        public delegate void IS_CRSReceivedDelegate(IS_CRS is_crs);
        public event IS_CRSReceivedDelegate IS_CRSReceived;
        public delegate void IS_CRSSentDelegate(IS_CRS is_crs);
        public event IS_CRSSentDelegate IS_CRSSent;

        public delegate void IS_BFNReceivedDelegate(IS_BFN is_bfn);
        public event IS_BFNReceivedDelegate IS_BFNReceived;
        public delegate void IS_BFNSentDelegate(IS_BFN is_bfn);
        public event IS_BFNSentDelegate IS_BFNSent;

        public delegate void IS_BTNReceivedDelegate(IS_BTN is_btn);
        public event IS_BTNReceivedDelegate IS_BTNReceived;
        public delegate void IS_BTNSentDelegate(IS_BTN is_btn);
        public event IS_BTNSentDelegate IS_BTNSent;

        public delegate void IS_BTCReceivedDelegate(IS_BTC is_btc);
        public event IS_BTCReceivedDelegate IS_BTCReceived;
        public delegate void IS_BTCSentDelegate(IS_BTC is_btc);
        public event IS_BTCSentDelegate IS_BTCSent;

        public delegate void IS_BTTReceivedDelegate(IS_BTT is_btt);
        public event IS_BTTReceivedDelegate IS_BTTReceived;
        public delegate void IS_BTTSentDelegate(IS_BTT is_btt);
        public event IS_BTTSentDelegate IS_BTTSent;


        #endregion

		#region Constructor

		public IsSocket()
		{
            this.MessageReceived += new MessageReceivedDelegate(StructSocket_MessageReceived);
            this.MessageSent += new MessageSentDelegate(StructSocket_MessageSent);
            this.IS_TINYReceived += new IS_TINYReceivedDelegate(StructSocket_IS_TINYReceived);
		}

		#endregion

        #region Public Methods

        public void Connect(string ipAddressOrHostNameAndPort)
        {
            string[] ipAddressOrHostNameAndPortArr = ipAddressOrHostNameAndPort.Split(new char[] { ':' });
            string ipAddressOrHostName = ipAddressOrHostNameAndPortArr[0];
            int port = Convert.ToInt32(ipAddressOrHostNameAndPortArr[1]);
            Connect(ipAddressOrHostName, port);
        }

        public void Connect(string ipAddressOrHostName, int port)
        {
            Connect(ipAddressOrHostName, port, false);
        }

        public void Connect(string ipAddressOrHostName, int port, bool asynchronous)
        {
            clientSocket = new Socket(AddressFamily.InterNetwork, this.SocketType, this.ProtocolType);

            IPAddress ipAddr = Dns.GetHostAddresses(ipAddressOrHostName)[0];
            IPEndPoint ipEndPoint = new IPEndPoint(ipAddr, port);

            if (!asynchronous)
            {
                clientSocket.Connect(ipEndPoint);
                StateObject so = new StateObject();
                clientSocket.BeginReceive(
                    so.initBuf,
                    0,
                    so.initBuf.Length,
                    SocketFlags.None,
                    new AsyncCallback(OnReceiveInit),
                    so);
            }
            else
            {
                clientSocket.BeginConnect(ipEndPoint, new AsyncCallback(OnConnect), null);
            }
        }

        public void Disconnect()
        {
            Disconnect(false);
        }

        public void Disconnect(bool asynchronous)
        {
            if (clientSocket != null && clientSocket.Connected)
            {
                if (!asynchronous)
                {
                    clientSocket.Shutdown(SocketShutdown.Both);
                    clientSocket.Disconnect(false);
                }
                else
                {
                    clientSocket.BeginDisconnect(false, new AsyncCallback(OnDisconnect), null);
                }
            }
        }

        public void Send(object anyObject)
        {
            Send(RawSerialize.Serialize(anyObject));
        }

        #endregion

        #region Private Methods

        private void Send(byte[] sendBuffer)
        {
            if (clientSocket != null && clientSocket.Connected)
            {
                clientSocket.BeginSend(
                    sendBuffer,
                    0,
                    sendBuffer.Length,
                    SocketFlags.None,
                    new AsyncCallback(OnSend),
                    sendBuffer);
            }
        }

        #endregion

        #region Callback - Methods

        private void OnConnect(IAsyncResult ar)
		{
			clientSocket.EndConnect(ar);

			StateObject so = new StateObject();
			clientSocket.BeginReceive(
				so.initBuf,
				0,
				so.initBuf.Length,
				SocketFlags.None,
				new AsyncCallback(OnReceiveInit),
				so);
		}

		private void OnSend(IAsyncResult ar)
		{
			clientSocket.EndSend(ar);
            if (MessageSent != null)
                MessageSent((byte[])ar.AsyncState);
		}

		private void OnReceiveInit(IAsyncResult ar)
		{
			StateObject so = (StateObject)ar.AsyncState;
			int bytesRead = clientSocket.EndReceive(ar);

			if (bytesRead > 0)
			{
				int messageLength = so.initBuf[0];
				so.messageBuf = new byte[messageLength];

                if (messageLength > bytesRead)
                {
                    Array.Copy(so.initBuf, so.messageBuf, so.initBuf.Length);
                    clientSocket.BeginReceive(
                        so.messageBuf,
                        so.initBuf.Length,
                        so.messageBuf.Length - so.initBuf.Length,
                        SocketFlags.None,
                        new AsyncCallback(OnReceive),
                        so);
                }
                else
                {
                    if (MessageReceived != null)
                        MessageReceived(so.initBuf);

                    clientSocket.BeginReceive(
                        so.initBuf,
                        0,
                        so.initBuf.Length,
                        SocketFlags.None,
                        new AsyncCallback(OnReceiveInit),
                        so);
                }
			}
		}

		private void OnReceive(IAsyncResult ar)
		{
			StateObject so = (StateObject)ar.AsyncState;

			int bytesRead = clientSocket.EndReceive(ar);

			if (bytesRead > 0)
			{
                if (MessageReceived != null)
                    MessageReceived(so.messageBuf);
			}
			clientSocket.BeginReceive(
				so.initBuf,
				0,
				so.initBuf.Length,
				SocketFlags.None,
				new AsyncCallback(OnReceiveInit),
				so);
		}

		private void OnDisconnect(IAsyncResult ar)
		{
			clientSocket.Shutdown(SocketShutdown.Both);
			clientSocket.EndDisconnect(ar);
		}

		#endregion

		#region EventHandler

        void StructSocket_MessageReceived(byte[] msg)
        {
            Header header = (Header)RawSerialize.Deserialize(msg, typeof(Header));

            switch (header.Type)
            {
                case PacketTypeEnum.ISP_ISI:
                    if (IS_ISIReceived != null)
                        IS_ISIReceived((IS_ISI)RawSerialize.Deserialize(msg, typeof(IS_ISI)));
                    break;
                case PacketTypeEnum.ISP_VER:
                    if (IS_VERReceived != null)
                        IS_VERReceived((IS_VER)RawSerialize.Deserialize(msg, typeof(IS_VER)));
                    break;
                case PacketTypeEnum.ISP_TINY:
                    if (IS_TINYReceived != null)
                        IS_TINYReceived((IS_TINY)RawSerialize.Deserialize(msg, typeof(IS_TINY)));
                    break;
                case PacketTypeEnum.ISP_SMALL:
                    if (IS_SMALLReceived != null)
                        IS_SMALLReceived((IS_SMALL)RawSerialize.Deserialize(msg, typeof(IS_SMALL)));
                    break;
                case PacketTypeEnum.ISP_STA:
                    if (IS_STAReceived != null)
                        IS_STAReceived((IS_STA)RawSerialize.Deserialize(msg, typeof(IS_STA)));
                    break;
                case PacketTypeEnum.ISP_SCH:
                    if (IS_SCHReceived != null)
                        IS_SCHReceived((IS_SCH)RawSerialize.Deserialize(msg, typeof(IS_SCH)));
                    break;
                case PacketTypeEnum.ISP_SFP:
                    if (IS_SFPReceived != null)
                        IS_SFPReceived((IS_SFP)RawSerialize.Deserialize(msg, typeof(IS_SFP)));
                    break;
                case PacketTypeEnum.ISP_SCC:
                    if (IS_SCCReceived != null)
                        IS_SCCReceived((IS_SCC)RawSerialize.Deserialize(msg, typeof(IS_SCC)));
                    break;
                case PacketTypeEnum.ISP_CPP:
                    if (IS_CPPReceived != null)
                        IS_CPPReceived((IS_CPP)RawSerialize.Deserialize(msg, typeof(IS_CPP)));
                    break;
                case PacketTypeEnum.ISP_ISM:
                    if (IS_ISMReceived != null)
                        IS_ISMReceived((IS_ISM)RawSerialize.Deserialize(msg, typeof(IS_ISM)));
                    break;
                case PacketTypeEnum.ISP_MSO:
                    if (IS_MSOReceived != null)
                        IS_MSOReceived((IS_MSO)RawSerialize.Deserialize(msg, typeof(IS_MSO)));
                    break;
                case PacketTypeEnum.ISP_III:
                    if (IS_IIIReceived != null)
                        IS_IIIReceived((IS_III)RawSerialize.Deserialize(msg, typeof(IS_III)));
                    break;
                case PacketTypeEnum.ISP_MST:
                    if (IS_MSTReceived != null)
                        IS_MSTReceived((IS_MST)RawSerialize.Deserialize(msg, typeof(IS_MST)));
                    break;
                case PacketTypeEnum.ISP_MTC:
                    if (IS_MTCReceived != null)
                        IS_MTCReceived((IS_MTC)RawSerialize.Deserialize(msg, typeof(IS_MTC)));
                    break;
                case PacketTypeEnum.ISP_MOD:
                    if (IS_MODReceived != null)
                        IS_MODReceived((IS_MOD)RawSerialize.Deserialize(msg, typeof(IS_MOD)));
                    break;
                case PacketTypeEnum.ISP_VTN:
                    if (IS_VTNReceived != null)
                        IS_VTNReceived((IS_VTN)RawSerialize.Deserialize(msg, typeof(IS_VTN)));
                    break;
                case PacketTypeEnum.ISP_RST:
                    if (IS_RSTReceived != null)
                        IS_RSTReceived((IS_RST)RawSerialize.Deserialize(msg, typeof(IS_RST)));
                    break;
                case PacketTypeEnum.ISP_NCN:
                    if (IS_NCNReceived != null)
                        IS_NCNReceived((IS_NCN)RawSerialize.Deserialize(msg, typeof(IS_NCN)));
                    break;
                case PacketTypeEnum.ISP_CNL:
                    if (IS_CNLReceived != null)
                        IS_CNLReceived((IS_CNL)RawSerialize.Deserialize(msg, typeof(IS_CNL)));
                    break;
                case PacketTypeEnum.ISP_CPR:
                    if (IS_CPRReceived != null)
                        IS_CPRReceived((IS_CPR)RawSerialize.Deserialize(msg, typeof(IS_CPR)));
                    break;
                case PacketTypeEnum.ISP_NPL:
                    if (IS_NPLReceived != null)
                        IS_NPLReceived((IS_NPL)RawSerialize.Deserialize(msg, typeof(IS_NPL)));
                    break;
                case PacketTypeEnum.ISP_PLP:
                    if (IS_PLPReceived != null)
                        IS_PLPReceived((IS_PLP)RawSerialize.Deserialize(msg, typeof(IS_PLP)));
                    break;
                case PacketTypeEnum.ISP_PLL:
                    if (IS_PLLReceived != null)
                        IS_PLLReceived((IS_PLL)RawSerialize.Deserialize(msg, typeof(IS_PLL)));
                    break;
                case PacketTypeEnum.ISP_LAP:
                    if (IS_LAPReceived != null)
                        IS_LAPReceived((IS_LAP)RawSerialize.Deserialize(msg, typeof(IS_LAP)));
                    break;
                case PacketTypeEnum.ISP_SPX:
                    if (IS_SPXReceived != null)
                        IS_SPXReceived((IS_SPX)RawSerialize.Deserialize(msg, typeof(IS_SPX)));
                    break;
                case PacketTypeEnum.ISP_PIT:
                    if (IS_PITReceived != null)
                        IS_PITReceived((IS_PIT)RawSerialize.Deserialize(msg, typeof(IS_PIT)));
                    break;
                case PacketTypeEnum.ISP_PSF:
                    if (IS_PSFReceived != null)
                        IS_PSFReceived((IS_PSF)RawSerialize.Deserialize(msg, typeof(IS_PSF)));
                    break;
                case PacketTypeEnum.ISP_PLA:
                    if (IS_PLAReceived != null)
                        IS_PLAReceived((IS_PLA)RawSerialize.Deserialize(msg, typeof(IS_PLA)));
                    break;
                case PacketTypeEnum.ISP_CCH:
                    if (IS_CCHReceived != null)
                        IS_CCHReceived((IS_CCH)RawSerialize.Deserialize(msg, typeof(IS_CCH)));
                    break;
                case PacketTypeEnum.ISP_PEN:
                    if (IS_PENReceived != null)
                        IS_PENReceived((IS_PEN)RawSerialize.Deserialize(msg, typeof(IS_PEN)));
                    break;
                case PacketTypeEnum.ISP_TOC:
                    if (IS_TOCReceived != null)
                        IS_TOCReceived((IS_TOC)RawSerialize.Deserialize(msg, typeof(IS_TOC)));
                    break;
                case PacketTypeEnum.ISP_FLG:
                    if (IS_FLGReceived != null)
                        IS_FLGReceived((IS_FLG)RawSerialize.Deserialize(msg, typeof(IS_FLG)));
                    break;
                case PacketTypeEnum.ISP_PFL:
                    if (IS_PFLReceived != null)
                        IS_PFLReceived((IS_PFL)RawSerialize.Deserialize(msg, typeof(IS_PFL)));
                    break;
                case PacketTypeEnum.ISP_FIN:
                    if (IS_FINReceived != null)
                        IS_FINReceived((IS_FIN)RawSerialize.Deserialize(msg, typeof(IS_FIN)));
                    break;
                case PacketTypeEnum.ISP_RES:
                    if (IS_RESReceived != null)
                        IS_RESReceived((IS_RES)RawSerialize.Deserialize(msg, typeof(IS_RES)));
                    break;
                case PacketTypeEnum.ISP_REO:
                    if (IS_REOReceived != null)
                        IS_REOReceived((IS_REO)RawSerialize.Deserialize(msg, typeof(IS_REO)));
                    break;
                case PacketTypeEnum.ISP_NLP:
                    if (IS_NLPReceived != null)
                        IS_NLPReceived((IS_NLP)RawSerialize.Deserialize(msg, typeof(IS_NLP)));
                    break;
                case PacketTypeEnum.ISP_MCI:
                    if (IS_MCIReceived != null)
                        IS_MCIReceived((IS_MCI)RawSerialize.Deserialize(msg, typeof(IS_MCI)));
                    break;
                case PacketTypeEnum.ISP_MSX:
                    if (IS_MSXReceived != null)
                        IS_MSXReceived((IS_MSX)RawSerialize.Deserialize(msg, typeof(IS_MSX)));
                    break;
                case PacketTypeEnum.ISP_MSL:
                    if (IS_MSLReceived != null)
                        IS_MSLReceived((IS_MSL)RawSerialize.Deserialize(msg, typeof(IS_MSL)));
                    break;
                case PacketTypeEnum.ISP_CRS:
                    if (IS_CRSReceived != null)
                        IS_CRSReceived((IS_CRS)RawSerialize.Deserialize(msg, typeof(IS_CRS)));
                    break;
                case PacketTypeEnum.ISP_BFN:
                    if (IS_BFNReceived != null)
                        IS_BFNReceived((IS_BFN)RawSerialize.Deserialize(msg, typeof(IS_BFN)));
                    break;
                case PacketTypeEnum.ISP_BTN:
                    if (IS_BTNReceived != null)
                        IS_BTNReceived((IS_BTN)RawSerialize.Deserialize(msg, typeof(IS_BTN)));
                    break;
                case PacketTypeEnum.ISP_BTC:
                    if (IS_BTCReceived != null)
                        IS_BTCReceived((IS_BTC)RawSerialize.Deserialize(msg, typeof(IS_BTC)));
                    break;
                case PacketTypeEnum.ISP_BTT:
                    if (IS_BTTReceived != null)
                        IS_BTTReceived((IS_BTT)RawSerialize.Deserialize(msg, typeof(IS_BTT)));
                    break;
                default:
                    throw new ApplicationException("unknown message received");
            }
        }

        void StructSocket_MessageSent(byte[] msg)
        {
            Header header = (Header)RawSerialize.Deserialize(msg, typeof(Header));

            switch (header.Type)
            {
                case PacketTypeEnum.ISP_ISI:
                    if (IS_ISISent != null)
                        IS_ISISent((IS_ISI)RawSerialize.Deserialize(msg, typeof(IS_ISI)));
                    break;
                case PacketTypeEnum.ISP_VER:
                    if (IS_VERSent != null)
                        IS_VERSent((IS_VER)RawSerialize.Deserialize(msg, typeof(IS_VER)));
                    break;
                case PacketTypeEnum.ISP_TINY:
                    if (IS_TINYSent != null)
                        IS_TINYSent((IS_TINY)RawSerialize.Deserialize(msg, typeof(IS_TINY)));
                    break;
                case PacketTypeEnum.ISP_SMALL:
                    if (IS_SMALLSent != null)
                        IS_SMALLSent((IS_SMALL)RawSerialize.Deserialize(msg, typeof(IS_SMALL)));
                    break;
                case PacketTypeEnum.ISP_STA:
                    if (IS_STASent != null)
                        IS_STASent((IS_STA)RawSerialize.Deserialize(msg, typeof(IS_STA)));
                    break;
                case PacketTypeEnum.ISP_SCH:
                    if (IS_SCHSent != null)
                        IS_SCHSent((IS_SCH)RawSerialize.Deserialize(msg, typeof(IS_SCH)));
                    break;
                case PacketTypeEnum.ISP_SFP:
                    if (IS_SFPSent != null)
                        IS_SFPSent((IS_SFP)RawSerialize.Deserialize(msg, typeof(IS_SFP)));
                    break;
                case PacketTypeEnum.ISP_SCC:
                    if (IS_SCCSent != null)
                        IS_SCCSent((IS_SCC)RawSerialize.Deserialize(msg, typeof(IS_SCC)));
                    break;
                case PacketTypeEnum.ISP_CPP:
                    if (IS_CPPSent != null)
                        IS_CPPSent((IS_CPP)RawSerialize.Deserialize(msg, typeof(IS_CPP)));
                    break;
                case PacketTypeEnum.ISP_ISM:
                    if (IS_ISMSent != null)
                        IS_ISMSent((IS_ISM)RawSerialize.Deserialize(msg, typeof(IS_ISM)));
                    break;
                case PacketTypeEnum.ISP_MSO:
                    if (IS_MSOSent != null)
                        IS_MSOSent((IS_MSO)RawSerialize.Deserialize(msg, typeof(IS_MSO)));
                    break;
                case PacketTypeEnum.ISP_III:
                    if (IS_IIISent != null)
                        IS_IIISent((IS_III)RawSerialize.Deserialize(msg, typeof(IS_III)));
                    break;
                case PacketTypeEnum.ISP_MST:
                    if (IS_MSTSent != null)
                        IS_MSTSent((IS_MST)RawSerialize.Deserialize(msg, typeof(IS_MST)));
                    break;
                case PacketTypeEnum.ISP_MTC:
                    if (IS_MTCSent != null)
                        IS_MTCSent((IS_MTC)RawSerialize.Deserialize(msg, typeof(IS_MTC)));
                    break;
                case PacketTypeEnum.ISP_MOD:
                    if (IS_MODSent != null)
                        IS_MODSent((IS_MOD)RawSerialize.Deserialize(msg, typeof(IS_MOD)));
                    break;
                case PacketTypeEnum.ISP_VTN:
                    if (IS_VTNSent != null)
                        IS_VTNSent((IS_VTN)RawSerialize.Deserialize(msg, typeof(IS_VTN)));
                    break;
                case PacketTypeEnum.ISP_RST:
                    if (IS_RSTSent != null)
                        IS_RSTSent((IS_RST)RawSerialize.Deserialize(msg, typeof(IS_RST)));
                    break;
                case PacketTypeEnum.ISP_NCN:
                    if (IS_NCNSent != null)
                        IS_NCNSent((IS_NCN)RawSerialize.Deserialize(msg, typeof(IS_NCN)));
                    break;
                case PacketTypeEnum.ISP_CNL:
                    if (IS_CNLSent != null)
                        IS_CNLSent((IS_CNL)RawSerialize.Deserialize(msg, typeof(IS_CNL)));
                    break;
                case PacketTypeEnum.ISP_CPR:
                    if (IS_CPRSent != null)
                        IS_CPRSent((IS_CPR)RawSerialize.Deserialize(msg, typeof(IS_CPR)));
                    break;
                case PacketTypeEnum.ISP_NPL:
                    if (IS_NPLSent != null)
                        IS_NPLSent((IS_NPL)RawSerialize.Deserialize(msg, typeof(IS_NPL)));
                    break;
                case PacketTypeEnum.ISP_PLP:
                    if (IS_PLPSent != null)
                        IS_PLPSent((IS_PLP)RawSerialize.Deserialize(msg, typeof(IS_PLP)));
                    break;
                case PacketTypeEnum.ISP_PLL:
                    if (IS_PLLSent != null)
                        IS_PLLSent((IS_PLL)RawSerialize.Deserialize(msg, typeof(IS_PLL)));
                    break;
                case PacketTypeEnum.ISP_LAP:
                    if (IS_LAPSent != null)
                        IS_LAPSent((IS_LAP)RawSerialize.Deserialize(msg, typeof(IS_LAP)));
                    break;
                case PacketTypeEnum.ISP_SPX:
                    if (IS_SPXSent != null)
                        IS_SPXSent((IS_SPX)RawSerialize.Deserialize(msg, typeof(IS_SPX)));
                    break;
                case PacketTypeEnum.ISP_PIT:
                    if (IS_PITSent != null)
                        IS_PITSent((IS_PIT)RawSerialize.Deserialize(msg, typeof(IS_PIT)));
                    break;
                case PacketTypeEnum.ISP_PSF:
                    if (IS_PSFSent != null)
                        IS_PSFSent((IS_PSF)RawSerialize.Deserialize(msg, typeof(IS_PSF)));
                    break;
                case PacketTypeEnum.ISP_PLA:
                    if (IS_PLASent != null)
                        IS_PLASent((IS_PLA)RawSerialize.Deserialize(msg, typeof(IS_PLA)));
                    break;
                case PacketTypeEnum.ISP_CCH:
                    if (IS_CCHSent != null)
                        IS_CCHSent((IS_CCH)RawSerialize.Deserialize(msg, typeof(IS_CCH)));
                    break;
                case PacketTypeEnum.ISP_PEN:
                    if (IS_PENSent != null)
                        IS_PENSent((IS_PEN)RawSerialize.Deserialize(msg, typeof(IS_PEN)));
                    break;
                case PacketTypeEnum.ISP_TOC:
                    if (IS_TOCSent != null)
                        IS_TOCSent((IS_TOC)RawSerialize.Deserialize(msg, typeof(IS_TOC)));
                    break;
                case PacketTypeEnum.ISP_FLG:
                    if (IS_FLGSent != null)
                        IS_FLGSent((IS_FLG)RawSerialize.Deserialize(msg, typeof(IS_FLG)));
                    break;
                case PacketTypeEnum.ISP_PFL:
                    if (IS_PFLSent != null)
                        IS_PFLSent((IS_PFL)RawSerialize.Deserialize(msg, typeof(IS_PFL)));
                    break;
                case PacketTypeEnum.ISP_FIN:
                    if (IS_FINSent != null)
                        IS_FINSent((IS_FIN)RawSerialize.Deserialize(msg, typeof(IS_FIN)));
                    break;
                case PacketTypeEnum.ISP_RES:
                    if (IS_RESSent != null)
                        IS_RESSent((IS_RES)RawSerialize.Deserialize(msg, typeof(IS_RES)));
                    break;
                case PacketTypeEnum.ISP_REO:
                    if (IS_REOSent != null)
                        IS_REOSent((IS_REO)RawSerialize.Deserialize(msg, typeof(IS_REO)));
                    break;
                case PacketTypeEnum.ISP_NLP:
                    if (IS_NLPSent != null)
                        IS_NLPSent((IS_NLP)RawSerialize.Deserialize(msg, typeof(IS_NLP)));
                    break;
                case PacketTypeEnum.ISP_MCI:
                    if (IS_MCISent != null)
                        IS_MCISent((IS_MCI)RawSerialize.Deserialize(msg, typeof(IS_MCI)));
                    break;
                case PacketTypeEnum.ISP_MSX:
                    if (IS_MSXSent != null)
                        IS_MSXSent((IS_MSX)RawSerialize.Deserialize(msg, typeof(IS_MSX)));
                    break;
                case PacketTypeEnum.ISP_MSL:
                    if (IS_MSLSent != null)
                        IS_MSLSent((IS_MSL)RawSerialize.Deserialize(msg, typeof(IS_MSL)));
                    break;
                case PacketTypeEnum.ISP_CRS:
                    if (IS_CRSSent != null)
                        IS_CRSSent((IS_CRS)RawSerialize.Deserialize(msg, typeof(IS_CRS)));
                    break;
                case PacketTypeEnum.ISP_BFN:
                    if (IS_BFNSent != null)
                        IS_BFNSent((IS_BFN)RawSerialize.Deserialize(msg, typeof(IS_BFN)));
                    break;
                case PacketTypeEnum.ISP_BTN:
                    if (IS_BTNSent != null)
                        IS_BTNSent((IS_BTN)RawSerialize.Deserialize(msg, typeof(IS_BTN)));
                    break;
                case PacketTypeEnum.ISP_BTC:
                    if (IS_BTCSent != null)
                        IS_BTCSent((IS_BTC)RawSerialize.Deserialize(msg, typeof(IS_BTC)));
                    break;
                case PacketTypeEnum.ISP_BTT:
                    if (IS_BTTSent != null)
                        IS_BTTSent((IS_BTT)RawSerialize.Deserialize(msg, typeof(IS_BTT)));
                    break;
                default:
                    throw new ApplicationException("unknown message received");
            }
        }


        void StructSocket_IS_TINYReceived(IS_TINY isTiny)
        {
            if (isTiny.SubT == IS_TINYTypeEnum.TINY_NONE)
            {
                this.Send(RawSerialize.Serialize(isTiny));
            }
        }

		#endregion
    }
}
