using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_SubPackets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class RaceLaps
    {
        #region Member

        private byte raceLaps;

        #endregion

        #region Properties

        public bool IsQualifying
        {
            get
            {
                return (raceLaps == 0);
            }
            set
            {
                raceLaps = 0;
            }
        }

        public ushort? Laps
        {
            get
            {
                ushort? uRet = null;

                if (raceLaps >= 1 &&
                    raceLaps <= 99)
                {
                    uRet = raceLaps;
                }
                if (raceLaps >= 100 &&
                    raceLaps <= 190)
                {
                    uRet = (ushort)((raceLaps - 100) * 10 + 100);
                }

                return uRet;
            }
            set
            {
                if (value >= 1 &&
                    value <= 99)
                {
                    raceLaps = (byte)value;
                }
                if (value >= 100 &&
                    value <= 1000)
                {
                    raceLaps = (byte)((value - 100) / 10 + 100);
                }
            }
        }

        public byte? Hours
        {
            get
            {
                byte? bRet = null;

                if (raceLaps >= 191 &&
                    raceLaps <= 238)
                {
                    bRet = (byte)(raceLaps - 190);
                }

                return bRet;
            }
            set
            {
                if (value >= 1 &&
                    value <= 48)
                {
                    raceLaps = (byte)(value + 190);
                }
            }
        }

        #endregion

        #region overriden Methods

        public override string ToString()
        {
            string sRet = string.Empty;

            if (Laps.HasValue)
            {
                sRet = Laps.ToString() + " Laps";
            }
            if (Hours.HasValue)
            {
                sRet = Hours.ToString() + " Hours";
            }

            return sRet;
        }

        #endregion
    }
}
