using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_SubPackets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class PLIDOrder
    {
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public byte[] PLID; // all PLIDs in new order

        public PLIDOrder()
        {
            this.PLID = new byte[32];
        }

        public PLIDOrder(byte[] PLID) : this()
        {
            Array.Copy(PLID, this.PLID, PLID.LongLength);
        }

        public override string ToString()
        {
            string sRet = string.Empty;

            for (int i = 0; i < 32; i++)
            {
                sRet += string.Format("{0}, ", PLID[i]);
            }
            sRet.Remove(sRet.Length - 2);

            return sRet;
        }
    }
}
