using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_SubPackets
{
    // NOTE : NodeLapHi3 - To allow laps up to 2047 to be reported, without increasing
    // the size of NLP packets, the next 3 high bits of the current lap are placed in
    // the highest 3 bits of the Node_Lap_Hi3 member of the NodeLap structure.

    // Example C code to extract the correct values from the packets :

    // int node		= Node_Lap_Hi3 & 0x1fff;
    // int lap		= Lap_Lo8 | ((Node_Lap_Hi3 & 0xe000) >> 5);}
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct NodeLap // Car info in 6 bytes - there is an array of these in the NLP (below)
    {
        public ushort Node;		// current path node
        public ushort Lap; // current lap
        public byte PLID;		// player's unique id
        public byte Position;		// current race position : 0 = unknown, 1 = leader, etc...
    }
}

