using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_SubPackets
{
    // NOTE 1) Heading : 0 = world y axis direction, 32768 = 180 degrees, anticlockwise from above
    // NOTE 2) AngVel  : 0 = no change in heading,    8192 = 180 degrees per second anticlockwise
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CompCar // Car info in 28 bytes - there is an array of these in the MCI (below)
    {
        public ushort Node;		// current path node
        public ushort Lap;		// current lap
        public byte PLID;	// player's unique id
        public byte Position; // current race position : 0 = unknown, 1 = leader, etc...
        public byte Sp2;
        public byte Sp3;
        public int X;			// X map (65536 = 1 metre)
        public int Y;			// Y map (65536 = 1 metre)
        public int Z;			// Z alt (65536 = 1 metre)
        public ushort Speed;		// speed (32768 = 100 m/s)
        public ushort Direction;	// direction of car's motion : 0 = world y direction, 32768 = 180 deg
        public ushort Heading;	// direction of forward axis : 0 = world y direction, 32768 = 180 deg
        public short AngVel;		// signed, rate of change of heading : (16384 = 360 deg/s)
    }
}
