using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_TINY // General purpose 4 byte packet
    {
        #region Member

        private byte size;		// always 4
        private PacketTypeEnum type;		// always ISP_TINY
        private byte reqI;		// 0 unless it is an info request or a reply to an info request
        private IS_TINYTypeEnum subT;		// subtype, from TINY_ enumeration (e.g. TINY_RACE_END)

        #endregion

        #region Properties

        public byte ReqI
        {
            get
            {
                return reqI;
            }
            set
            {
                reqI = value;
            }
        }

        public IS_TINYTypeEnum SubT
        {
            get
            {
                return subT;
            }
            set
            {
                subT = value;
            }
        }

        #endregion

        #region Constructor

        public IS_TINY()
        {
            size = 4;
            type = PacketTypeEnum.ISP_TINY;
        }

        public IS_TINY(byte reqI) 
            : this()
        {
            this.reqI = reqI;
        }

        public IS_TINY(IS_TINYTypeEnum subT)
            : this()
        {
            this.subT = subT;
        }

        public IS_TINY(byte reqI, IS_TINYTypeEnum subT)
            : this()
        {
            this.reqI = reqI;
            this.subT = subT;
        }

        #endregion

    }
}
