using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_SPX // SPlit X time
    {
        private byte Size;		// 16
        private PacketTypeEnum Type;		// ISP_SPX
        private byte ReqI;		// 0
        public byte PLID;		// player's unique id

        public uint STime;	// split time (ms)
        public uint ETime;	// total time (ms)

        public byte Split;		// split number 1, 2, 3
        public byte Penalty;	// current penalty value (see below)
        public byte NumStops;	// number of pit stops
        private byte Sp3;

        public IS_SPX()
        {
            Size = 16;
            Type = PacketTypeEnum.ISP_SPX;
            ReqI = 0;
            Sp3 = 0;
        }
    }
}
