using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_RES // RESult (qualify or confirmed finish)
    {
        private byte Size;		// 84
        private PacketTypeEnum Type;		// ISP_RES
        public byte ReqI;		// 0 unless this is a reply to a TINY_RES request
        public byte PLID;		// player's unique id (0 = player left before result was sent)

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 24)]
        public string UName;	// username
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 24)]
        public string PName;	// nickname
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
        private char[] plate;   // number plate - NO ZERO AT END!
        public string Plate
        {
            get
            {
                return new string(plate);
            }
            set
            {
                plate = value.ToCharArray(0, 8);
            }
        }
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 4)]
        public string CName;	// skin prefix

        public uint TTime;	// race time (ms)
        public uint BTime;	// best lap (ms)

        private byte SpA;
        public byte NumStops;	// number of pit stops
        public byte Confirm;	// confirmation flags : disqualified etc - see below
        private byte SpB;

        public ushort LapsDone;	// laps completed
        public ushort Flags;		// player flags : help settings etc - see below

        public byte ResultNum;	// finish or qualify pos (0 = win / 255 = not added to table)
        public byte NumRes;		// total number of results (qualify doesn't always add a new one)
        private byte Sp2;
        private byte Sp3;

        public IS_RES()
        {
            Size = 84;
            Type = PacketTypeEnum.ISP_RES;
            SpA = 0;
            SpB = 0;
            Sp2 = 0;
            Sp3 = 0;
        }
    }
}
