using LfsInSimLib.IS_Enums;
using LfsInSimLib.IS_SubPackets;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    // IS_REO : REOrder - this packet can be sent in either direction

    // LFS sends one at the start of every race or qualifying session, listing the start order

    // You can send one to LFS before a race start, to specify the starting order.
    // It may be a good idea to avoid conflict by using /start=fixed (LFS setting).
    // Alternatively, you can leave the LFS setting, but make sure you send your IS_REO
    // AFTER you receive the IS_VTA.  LFS does its default grid reordering at the same time
    // as it sends the IS_VTA (VoTe Action) and you can override this by sending an IS_REO.

    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_REO // REOrder (when race restarts after qualifying)
    {
        #region Member

        private byte size;		// 36
        private PacketTypeEnum type;		// ISP_REO
        private byte reqI;		// 0 unless this is a reply to an TINY_REO request
        private byte numP;		// number of players in race

        private PLIDOrder pLID;

        #endregion

        #region Properties

        public Byte ReqI
        {
            get
            {
                return reqI;
            }
            set
            {
                reqI = value;
            }
        }

        public Byte NumP
        {
            get
            {
                return numP;
            }
            set
            {
                numP = value;
            }
        }

        public PLIDOrder PLID
        {
            get
            {
                return pLID;
            }
            set
            {
                pLID = value;
            }
        }

        #endregion

        #region Constructor

        public IS_REO()
        {
            size = 36;
            type = PacketTypeEnum.ISP_REO;
        }

        #endregion
    }
}
