using LfsInSimLib.IS_Enums;
using LfsInSimLib.IS_SubPackets;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_PIT // PIT stop (stop at pit garage)
    {
        private byte Size;		// 24
        private PacketTypeEnum Type;		// ISP_PIT
        private byte ReqI;		// 0
        public byte PLID;		// player's unique id

        public ushort LapsDone;	// laps completed
        public ushort Flags;		// player flags

        private byte Sp0;
        public byte Penalty;	// current penalty value (see below)
        public byte NumStops;	// number of pit stops
        private byte Sp3;

        public Tyres Tyres;	// tyres changed

        public uint Work;	// pit work
        private uint Spare;

        public IS_PIT()
        {
            Size = 24;
            Type = PacketTypeEnum.ISP_PIT;
            ReqI = 0;
            Sp0 = 0;
            Sp3 = 0;
            Spare = 0;
        }
    }
}
