using LfsInSimLib.IS_Enums;
using LfsInSimLib.IS_SubPackets;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_NLP // Node and Lap Packet
    {
        #region Member

        private byte Size;		// 4 + NumP * 6 (PLUS 2 if needed to make it a multiple of 4)
        private PacketTypeEnum Type;		// ISP_NLP
        public byte ReqI;		// 0 unless this is a reply to an TINY_NLP request
        public byte NumP;		// number of players in race

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public NodeLap[] Info;	// node and lap of each player, 1 to 32 of these (NumP)

        #endregion

        #region Constructor

        public IS_NLP()
        {
            Size = 196;
            Type = PacketTypeEnum.ISP_NLP;
        }

        #endregion
    }
}
