using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_NCN
    {
        private byte Size;		// 56
        private PacketTypeEnum Type;		// ISP_NCN
        public byte ReqI;		// 0 unless this is a reply to a TINY_NCN request
        public byte UCID;		// new connection's unique id (0 = host)

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 24)]
        public string UName;	// username
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 24)]
        public string PName;	// nickname

        public byte Admin;		// 1 if admin
        public byte Total;		// number of connections including host
        public byte Flags;		// bit 2 : remote
        private byte Sp3;

        public IS_NCN()
        {
            Size = 56;
            Type = PacketTypeEnum.ISP_NCN;
            Sp3 = 0;
        }
    }
}
