using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_MSX
    {
        #region Member

        private byte size;		// 100
        private PacketTypeEnum type;		// ISP_MSX
        private byte reqI;		// 0
        private byte zero;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 96)]
        private string msg;	// last byte must be zero

        #endregion

        #region Properties

        public string Msg
        {
            get
            {
                return msg;
            }
            set
            {
                msg = value;
            }
        }

        #endregion

        #region Constructor

        public IS_MSX()
        {
            size = 100;
            type = PacketTypeEnum.ISP_MSX;
            reqI = 0;
            zero = 0;
        }

        #endregion
    }
}
