using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [IS_Sendable]
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_MST
    {
        #region Member

        private byte size;		// 68
        private PacketTypeEnum type;		// ISP_MST
        private byte reqI;		// 0
        private byte zero;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 64)]
        private string msg;	// last byte must be zero

        #endregion

        #region Properties

        public string Msg
        {
            get
            {
                return msg;
            }
            set
            {
                msg = value;
            }
        }

        #endregion

        #region Constructor

        public IS_MST()
        {
            size = 68;
            type = PacketTypeEnum.ISP_MST;
            reqI = 0;
            zero = 0;
        }

        #endregion
    }
}
