using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_LAP // LAP time
    {
        private byte Size;		// 20
        private PacketTypeEnum Type;		// ISP_LAP
        private byte ReqI;		// 0
        public byte PLID;		// player's unique id

        public uint LTime;	// lap time (ms)
        public uint ETime;	// total time (ms)

        public ushort LapsDone;	// laps completed
        public ushort Flags;		// player flags

        private byte Sp0;
        public PenaltyEnum Penalty;	// current penalty value (see below)
        public byte NumStops;	// number of pit stops
        private byte Sp3;

        public IS_LAP()
        {
            Size = 20;
            Type = PacketTypeEnum.ISP_LAP;
            ReqI = 0;
            Sp0 = 0;
            Sp3 = 0;
        }
    }
}
