using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_ISM
    {
        private byte Size;		// 40
        private PacketTypeEnum Type;		// ISP_ISM
        public byte ReqI;		// usually 0 / or if a reply : ReqI as received in the TINY_ISM
        private byte Zero;

        public HostTypeEnum Host;		// 0 = guest / 1 = host
        private byte Sp1;
        private byte Sp2;
        private byte Sp3;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
        string HName;	// the name of the host joined or started

        public IS_ISM()
        {
            Size = 40;
            Type = PacketTypeEnum.ISP_ISM;
            Zero = 0;
            Sp1 = 0;
            Sp2 = 0;
            Sp3 = 0;

        }
    }
}
