using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_ISI
    {
        #region Member

        private byte size;		// 44
        private PacketTypeEnum type;
        private byte reqI;		// If non-zero LFS will send an IS_VER packet
        private byte zero;		// 0

        private UInt16 uDPPort;
        private IS_ISIFlagsEnum flags;

        private byte sp0;
        private byte prefix;
        private UInt16 interval;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 16)]
        private string admin;
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 16)]
        private string iName;

        #endregion

        #region Properties

        public Byte ReqI
        {
            get
            {
                return reqI;
            }
            set
            {
                reqI = value;
            }
        }

        public UInt16 UDPPort
        {
            get
            {
                return uDPPort;
            }
            set
            {
                uDPPort = value;
            }
        }

        public IS_ISIFlagsEnum Flags
        {
            get
            {
                return flags;
            }
            set
            {
                flags = value;
            }
        }

        public Byte Prefix
        {
            get
            {
                return prefix;
            }
            set
            {
                prefix = value;
            }
        }

        public UInt16 Interval
        {
            get
            {
                return interval;
            }
            set
            {
                interval = value;
            }
        }

        public String Admin
        {
            get
            {
                return admin;
            }
            set
            {
                admin = value;
            }
        }

        public String IName
        {
            get
            {
                return iName;
            }
            set
            {
                iName = value;
            }
        }



        #endregion

        #region Constructor

        public IS_ISI()
        {
            size = 44;
            type = PacketTypeEnum.ISP_ISI;
            zero = 0;
            sp0 = 0;
        }

    	#endregion    
    }
}
