using LfsInSimLib.IS_Enums;

using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace LfsInSimLib.IS_Packets
{
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public class IS_III
    {
        private byte Size;		// 72
        private PacketTypeEnum Type;		// ISP_III
        private byte ReqI;		// 0
        private byte Zero;

        public byte UCID;		// connection's unique id (0 = host)
        public byte PLID;		// player's unique id (if zero, use UCID)
        private byte Sp2;
        private byte Sp3;

        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 64)]
        public string Msg;

        public IS_III()
        {
            Size = 72;
            Type = PacketTypeEnum.ISP_III;
            ReqI = 0;
            Zero = 0;
            Sp2 = 0;
            Sp3 = 0;
        }
    }
}
